/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.filter.AggregateFilterProperties;
import com.fizzgate.filter.FilterResult;
import com.fizzgate.fizz.AggregateResource;
import com.fizzgate.fizz.ConfigLoader;
import com.fizzgate.fizz.Pipeline;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.util.MapUtil;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.WebUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Component
@Order(value=30)
public class AggregateFilter
implements WebFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateFilter.class);
    private static final String X_FORWARDED_FOR = "X-FORWARDED-FOR";
    @Resource
    private ConfigLoader configLoader;
    @Resource
    private AggregateFilterProperties aggregateFilterProperties;
    @Resource
    private SystemConfig systemConfig;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Map fizzHeaders;
        AggregateResource aggregateResource;
        String p;
        byte act;
        String serviceId = WebUtils.getBackendService(exchange);
        if (serviceId == null) {
            return chain.filter(exchange);
        }
        if ((!WebUtils.ignorePlugin(exchange) || WebUtils.getRoute((ServerWebExchange)exchange).type != 1) && ((act = WebUtils.getApiConfigType(exchange)) == 0 ? (StringUtils.startsWith((CharSequence)(p = exchange.getRequest().getURI().getPath()), (CharSequence)"/_proxytest/") ? this.systemConfig.isAggregateTestAuth() : this.aggregateFilterProperties.isNeedAuth()) : act != 1)) {
            return chain.filter(exchange);
        }
        FilterResult pfr = WebUtils.getPrevFilterResult(exchange);
        if (!pfr.success) {
            return WebUtils.getDirectResponse(exchange);
        }
        long start = System.currentTimeMillis();
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse serverHttpResponse = exchange.getResponse();
        String clientReqPathPrefix = WebUtils.getClientReqPathPrefix(exchange);
        String path = clientReqPathPrefix + serviceId + WebUtils.getBackendPath(exchange);
        String method = request.getMethodValue();
        if (HttpMethod.HEAD.matches(method.toUpperCase())) {
            method = HttpMethod.GET.name();
        }
        if ((aggregateResource = this.configLoader.matchAggregateResource(method, path)) == null) {
            if ("/_proxytest/".equals(clientReqPathPrefix) || WebUtils.getApiConfigType(exchange) == 1) {
                return WebUtils.responseError(exchange, HttpStatus.NOT_FOUND.value(), "API not found in aggregation: " + path);
            }
            return chain.filter(exchange);
        }
        Pipeline pipeline = aggregateResource.getPipeline();
        Input input = aggregateResource.getInput();
        HttpHeaders hds = request.getHeaders();
        Map headers = MapUtil.headerToHashMap((HttpHeaders)hds);
        if (CollectionUtils.isEmpty((Collection)hds.get((Object)X_FORWARDED_FOR)) && this.systemConfig.isFizzWebClientXForwardedForEnable()) {
            headers.put(X_FORWARDED_FOR, WebUtils.getOriginIp(exchange));
        }
        if ((fizzHeaders = (Map)exchange.getAttributes().get("ahs@")) != null && !fizzHeaders.isEmpty()) {
            Set entrys = fizzHeaders.entrySet();
            for (Map.Entry entry : entrys) {
                headers.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
            }
        }
        String traceId = WebUtils.getTraceId(exchange);
        ThreadContext.put((String)"traceId", (String)traceId);
        LOGGER.debug("{} matched api in aggregation: {}", (Object)traceId, (Object)path);
        HashMap<String, Object> clientInput = new HashMap<String, Object>();
        clientInput.put("path", path);
        clientInput.put("method", method);
        clientInput.put("headers", headers);
        clientInput.put("params", MapUtil.toHashMap((MultiValueMap)request.getQueryParams()));
        clientInput.put("contentType", request.getHeaders().getFirst("Content-Type"));
        Mono result = null;
        MediaType contentType = request.getHeaders().getContentType();
        result = MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType) ? exchange.getMultipartData().flatMap(md -> {
            HashMap filePartMap = new HashMap();
            clientInput.put("body", MapUtil.extractFormData((MultiValueMap)md, (String)"__fizz_file__", filePartMap));
            clientInput.put("filePartMap", filePartMap);
            return pipeline.run(input, clientInput, traceId);
        }) : (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType) ? exchange.getFormData().flatMap(fd -> {
            clientInput.put("body", MapUtil.toHashMap((MultiValueMap)fd));
            return pipeline.run(input, clientInput, traceId);
        }) : (HttpMethod.POST.name().equalsIgnoreCase(method) ? DataBufferUtils.join((Publisher)request.getBody()).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(buf -> {
            if (buf != NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                try {
                    clientInput.put("body", buf.toString(StandardCharsets.UTF_8));
                }
                finally {
                    DataBufferUtils.release((DataBuffer)buf);
                }
            }
            return pipeline.run(input, clientInput, traceId);
        }) : pipeline.run(input, clientInput, traceId)));
        return result.subscribeOn(Schedulers.elastic()).flatMap(aggResult -> {
            List headerTraceIds;
            ThreadContext.put((String)"traceId", (String)traceId);
            if (aggResult.getHttpStatus() != null) {
                serverHttpResponse.setRawStatusCode(aggResult.getHttpStatus());
            }
            String jsonString = null;
            jsonString = aggResult.getBody() instanceof String ? (String)aggResult.getBody() : (this.aggregateFilterProperties.isWriteMapNullValue() ? JSON.toJSONString((Object)aggResult.getBody(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}) : JSON.toJSONString((Object)aggResult.getBody()));
            LOGGER.debug("{} response body: {}", (Object)traceId, (Object)jsonString);
            if (aggResult.getHeaders() != null && !aggResult.getHeaders().isEmpty()) {
                serverHttpResponse.getHeaders().addAll(aggResult.getHeaders());
                serverHttpResponse.getHeaders().remove((Object)"Content-Length");
            }
            if (!serverHttpResponse.getHeaders().containsKey((Object)"Content-Type")) {
                serverHttpResponse.getHeaders().add("Content-Type", "application/json; charset=UTF-8");
            }
            if ((headerTraceIds = serverHttpResponse.getHeaders().get((Object)this.systemConfig.fizzTraceIdHeader())) == null || !headerTraceIds.contains(traceId)) {
                serverHttpResponse.getHeaders().add(this.systemConfig.fizzTraceIdHeader(), traceId);
            }
            long end = System.currentTimeMillis();
            pipeline.getStepContext().addElapsedTime("\u603b\u8017\u65f6", end - start);
            LOGGER.info("{} ElapsedTimes={}", (Object)traceId, (Object)JSON.toJSONString((Object)pipeline.getStepContext().getElapsedTimes()));
            return serverHttpResponse.writeWith((Publisher)Flux.just((Object)exchange.getResponse().bufferFactory().wrap(jsonString.getBytes())));
        });
    }
}

