/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.alibaba.fastjson.JSON;
import com.fizzgate.filter.CallbackFilterProperties;
import com.fizzgate.filter.FilterResult;
import com.fizzgate.filter.FizzWebFilter;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.plugin.auth.CallbackConfig;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.fizzgate.plugin.auth.Receiver;
import com.fizzgate.proxy.CallbackService;
import com.fizzgate.proxy.DiscoveryClientUriSelector;
import com.fizzgate.proxy.ServiceInstance;
import com.fizzgate.service_registry.RegistryCenterService;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.ThreadContext;
import com.fizzgate.util.WebUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component(value="callbackFilter")
@Order(value=20)
public class CallbackFilter
extends FizzWebFilter {
    private static final Logger log = LoggerFactory.getLogger(CallbackFilter.class);
    private static final Logger CALLBACK_LOGGER = LoggerFactory.getLogger((String)"callback");
    public static final String CALLBACK_FILTER = "callbackFilter";
    private static final String s2im = "s2imT";
    private static final String json = "json";
    @Resource
    private DiscoveryClientUriSelector discoveryClientSelector;
    @Resource
    private CallbackFilterProperties callbackFilterProperties;
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Resource
    private CallbackService callbackService;
    @Resource
    private GatewayGroupService gatewayGroupService;
    private static final String _id = "\"id\":";
    private static final String _datetime = "\"datetime\":";
    private static final String _origin = "\"origin\":";
    private static final String _app = "\"app\":";
    private static final String _method = "\"method\":";
    private static final String _service = "\"service\":";
    private static final String _path = "\"path\":";
    private static final String _query = "\"query\":";
    private static final String _headers = "\"headers\":";
    private static final String _body = "\"body\":";
    private static final String _callbackConfigId = "\"callbackConfigId\":";
    private static final String _receivers = "\"receivers\":";
    private static final String _gatewayGroup = "\"gatewayGroup\":";

    @Override
    public Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        FilterResult pfr = WebUtils.getPrevFilterResult(exchange);
        if (!pfr.success) {
            return WebUtils.getDirectResponse(exchange);
        }
        ApiConfig ac = WebUtils.getApiConfig(exchange);
        if (ac != null && ac.type == 4) {
            CallbackConfig cc = ac.callbackConfig;
            ServerHttpRequest req = exchange.getRequest();
            return DataBufferUtils.join((Publisher)req.getBody()).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(b -> {
                DataBuffer body = null;
                if (b != NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                    if (b instanceof PooledDataBuffer) {
                        try {
                            body = NettyDataBufferUtils.copy2heap((DataBuffer)b);
                        }
                        finally {
                            NettyDataBufferUtils.release((DataBuffer)b);
                        }
                    } else {
                        body = b;
                    }
                }
                HashMap<String, ServiceInstance> service2instMap = this.getService2instMap(ac);
                HttpHeaders headers = WebUtils.mergeAppendHeaders(exchange);
                this.pushReq2manager(exchange, headers, body, service2instMap, cc.id, ac.gatewayGroups.iterator().next());
                if (cc.type == 'a' || StringUtils.isNotBlank((CharSequence)cc.respBody)) {
                    return this.directResponse(exchange, cc);
                }
                return this.callbackService.requestBackends(exchange, headers, body, cc, service2instMap);
            });
        }
        return chain.filter(exchange);
    }

    private Mono<Void> directResponse(ServerWebExchange exchange, CallbackConfig cc) {
        HttpHeaders httpHeaders = new HttpHeaders();
        cc.respHeaders.forEach((h, v) -> httpHeaders.addAll(h, v));
        return WebUtils.response(exchange.getResponse(), HttpStatus.OK, httpHeaders, cc.respBody);
    }

    private HashMap<String, ServiceInstance> getService2instMap(ApiConfig ac) {
        HashMap service2instMap = ThreadContext.getHashMap((String)s2im);
        List<Receiver> receivers = ac.callbackConfig.receivers;
        for (Receiver r : receivers) {
            if (r.type != 2) continue;
            ServiceInstance inst = null;
            if (r.registryCenter == null) {
                inst = this.discoveryClientSelector.getNextInstance(r.service);
            } else {
                String instance = this.registryCenterService.getInstance(r.registryCenter, r.service);
                String[] ipAndPort = StringUtils.split((String)instance, (char)':');
                inst = new ServiceInstance(ipAndPort[0], Integer.parseInt(ipAndPort[1]));
            }
            service2instMap.put(r.service, inst);
        }
        return service2instMap;
    }

    private void pushReq2manager(ServerWebExchange exchange, HttpHeaders headers, DataBuffer body, HashMap<String, ServiceInstance> service2instMap, int callbackConfigId, String gatewayGroup) {
        ServerHttpRequest req = exchange.getRequest();
        StringBuilder b = ThreadContext.getStringBuilder();
        b.append('{');
        b.append(_id);
        CallbackFilter.toJsonStringValue(b, WebUtils.getTraceId(exchange));
        b.append(',');
        b.append(_datetime);
        b.append(System.currentTimeMillis());
        b.append(',');
        b.append(_origin);
        CallbackFilter.toJsonStringValue(b, WebUtils.getOriginIp(exchange));
        b.append(',');
        String appId = WebUtils.getAppId(exchange);
        if (appId != null) {
            b.append(_app);
            CallbackFilter.toJsonStringValue(b, appId);
            b.append(',');
        }
        b.append(_method);
        CallbackFilter.toJsonStringValue(b, req.getMethod().name());
        b.append(',');
        b.append(_service);
        CallbackFilter.toJsonStringValue(b, WebUtils.getClientService(exchange));
        b.append(',');
        b.append(_path);
        CallbackFilter.toJsonStringValue(b, WebUtils.getClientReqPath(exchange));
        b.append(',');
        String query = WebUtils.getClientReqQuery(exchange);
        if (query != null) {
            b.append(_query);
            CallbackFilter.toJsonStringValue(b, query);
            b.append(',');
        }
        String headersJson = JSON.toJSONString((Object)headers);
        b.append(_headers);
        b.append(headersJson);
        b.append(',');
        b.append(_callbackConfigId);
        b.append(callbackConfigId);
        b.append(',');
        if (!service2instMap.isEmpty()) {
            String rs = JSON.toJSONString((Object)JSON.toJSONString(service2instMap));
            b.append(_receivers);
            b.append(rs);
            b.append(',');
        }
        b.append(_gatewayGroup);
        CallbackFilter.toJsonStringValue(b, gatewayGroup);
        if (body != null) {
            b.append(',');
            String bodyStr = body.toString(StandardCharsets.UTF_8);
            MediaType contentType = req.getHeaders().getContentType();
            if (contentType != null && contentType.getSubtype().equalsIgnoreCase(json)) {
                b.append(_body);
                b.append(JSON.toJSONString((Object)bodyStr));
            } else {
                b.append(_body);
                CallbackFilter.toJsonStringValue(b, bodyStr);
            }
        }
        b.append('}');
        String msg = b.toString();
        if ("kafka".equals(this.callbackFilterProperties.getDest())) {
            CALLBACK_LOGGER.info(msg);
        } else {
            this.rt.convertAndSend(this.callbackFilterProperties.getQueue(), (Object)msg).subscribe();
        }
        if (log.isDebugEnabled()) {
            log.debug("push callback req: " + msg);
        }
    }

    private static void toJsonStringValue(StringBuilder b, String value) {
        b.append('\"').append(value).append('\"');
    }
}

