/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.fizzgate.Fizz;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.exception.ExecuteScriptException;
import com.fizzgate.exception.RedirectException;
import com.fizzgate.exception.StopAndResponseException;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.legacy.RespEntity;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.WebUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

@Configuration
public class FilterExceptionHandlerConfig {
    @Bean
    @Order(value=-10)
    public FilterExceptionHandler filterExceptionHandler() {
        return new FilterExceptionHandler();
    }

    public static class FilterExceptionHandler
    implements WebExceptionHandler {
        private static final Logger log = LoggerFactory.getLogger(FilterExceptionHandler.class);
        private static final String filterExceptionHandler = "filterExceptionHandler";

        public Mono<Void> handle(ServerWebExchange exchange, Throwable t) {
            Mono vm;
            RuntimeException ex;
            exchange.getAttributes().put("origerr@", t);
            String traceId = WebUtils.getTraceId(exchange);
            ServerHttpResponse resp = exchange.getResponse();
            if (SystemConfig.FIZZ_ERR_RESP_HTTP_STATUS_ENABLE) {
                if (t instanceof ResponseStatusException) {
                    resp.setStatusCode(((ResponseStatusException)t).getStatus());
                } else {
                    resp.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
            HttpHeaders respHeaders = resp.getHeaders();
            String value = Fizz.context.getEnvironment().getProperty("fizz.dedicated-line.client.enable");
            if (StringUtils.isNotBlank((CharSequence)value) && value.equals("true")) {
                respHeaders.set("b-ecyt", "0");
            }
            if (t instanceof StopAndResponseException && ((StopAndResponseException)(ex = (StopAndResponseException)t)).getData() != null) {
                respHeaders.add("Content-Type", "application/json");
                return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(((StopAndResponseException)ex).getData().toString().getBytes())));
            }
            if (t instanceof RedirectException && ((RedirectException)(ex = (RedirectException)t)).getRedirectUrl() != null) {
                resp.setStatusCode(HttpStatus.MOVED_PERMANENTLY);
                respHeaders.setLocation(URI.create(((RedirectException)ex).getRedirectUrl()));
                return Mono.empty();
            }
            String tMsg = t.getMessage();
            if (tMsg == null) {
                tMsg = t.toString();
            }
            if (t instanceof ExecuteScriptException) {
                ExecuteScriptException ex2 = (ExecuteScriptException)t;
                respHeaders.add("Content-Type", "application/json");
                RespEntity rs = null;
                if (ex2.getStepContext() != null && ex2.getStepContext().returnContext()) {
                    rs = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), tMsg, traceId, ex2.getStepContext());
                    return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(JacksonUtils.writeValueAsBytes((Object)rs))));
                }
                rs = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), tMsg, traceId);
                return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(rs.toString().getBytes())));
            }
            if (t instanceof FizzRuntimeException) {
                FizzRuntimeException ex3 = (FizzRuntimeException)t;
                ThreadContext.put((String)"traceId", (String)traceId);
                log.error(traceId + ' ' + tMsg, (Throwable)ex3);
                respHeaders.add("Content-Type", "application/json");
                RespEntity rs = null;
                if (ex3.getStepContext() != null && ex3.getStepContext().returnContext()) {
                    rs = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), tMsg, traceId, ex3.getStepContext());
                    return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(JacksonUtils.writeValueAsString((Object)rs).getBytes())));
                }
                rs = new RespEntity(HttpStatus.INTERNAL_SERVER_ERROR.value(), tMsg, traceId);
                return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(rs.toString().getBytes())));
            }
            Object fc = exchange.getAttribute("fc@");
            if (fc == null) {
                StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
                WebUtils.request2stringBuilder(exchange, b);
                ThreadContext.put((String)"traceId", (String)traceId);
                log.error(b.toString(), t);
                String s = WebUtils.jsonRespBody(HttpStatus.INTERNAL_SERVER_ERROR.value(), tMsg, traceId);
                respHeaders.add("Content-Type", "application/json");
                vm = resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(s.getBytes())));
            } else {
                vm = WebUtils.responseError(exchange, filterExceptionHandler, HttpStatus.INTERNAL_SERVER_ERROR.value(), tMsg, t);
            }
            return vm;
        }
    }
}

