/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.fizzgate.util.WebUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@Order(value=0)
public class FizzLogFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(FizzLogFilter.class);
    private static final String resp = "\nresponse ";
    private static final String in = " in ";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        long start = System.currentTimeMillis();
        return chain.filter(exchange).doFinally(c -> {
            if (log.isInfoEnabled()) {
                StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
                WebUtils.request2stringBuilder(exchange, b);
                b.append(resp).append(exchange.getResponse().getStatusCode()).append(in).append(System.currentTimeMillis() - start);
                ThreadContext.put((String)"traceId", (String)WebUtils.getTraceId(exchange));
                log.info(b.toString());
            }
        });
    }
}

