/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.filter.FizzWebFilter;
import com.fizzgate.filter.FlowControlFilterProperties;
import com.fizzgate.monitor.FizzMonitorService;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.plugin.auth.AppService;
import com.fizzgate.stats.BlockType;
import com.fizzgate.stats.FlowStat;
import com.fizzgate.stats.IncrRequestResult;
import com.fizzgate.stats.ResourceConfig;
import com.fizzgate.stats.circuitbreaker.CircuitBreakManager;
import com.fizzgate.stats.circuitbreaker.CircuitBreaker;
import com.fizzgate.stats.degrade.DegradeRule;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfig;
import com.fizzgate.stats.ratelimit.ResourceRateLimitConfigService;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ResourceIdUtils;
import com.fizzgate.util.UUIDUtil;
import com.fizzgate.util.Utils;
import com.fizzgate.util.WebUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

@Component(value="flowControlFilter")
@Order(value=-10)
public class FlowControlFilter
extends FizzWebFilter {
    public static final String FLOW_CONTROL_FILTER = "flowControlFilter";
    private static final Logger log = LoggerFactory.getLogger(FlowControlFilter.class);
    private static final String admin = "admin";
    private static final String actuator = "actuator";
    private static final String uuid = "uuid";
    private static final String defaultFizzTraceIdValueStrategy = "requestId";
    private static final String _fizz = "_fizz-";
    private static final String concurrents = "concurrents";
    private static final String qps = "qps";
    private static final String favPath = "/favicon.ico";
    @Resource
    private FlowControlFilterProperties flowControlFilterProperties;
    @Resource
    private ResourceRateLimitConfigService resourceRateLimitConfigService;
    @Autowired(required=false)
    private FlowStat flowStat;
    @Resource
    private ApiConfigService apiConfigService;
    @Resource
    private AppService appService;
    @Resource
    private SystemConfig systemConfig;
    @Resource
    private CircuitBreakManager circuitBreakManager;
    @Resource
    private FizzMonitorService fizzMonitorService;

    @Override
    public Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getURI().getPath();
        boolean adminReq = false;
        boolean proxyTestReq = false;
        boolean fizzApiReq = false;
        boolean favReq = false;
        if (path.equals(favPath)) {
            exchange.getAttributes().put("fa@", "");
            favReq = true;
        }
        String service = null;
        if (!favReq) {
            int secFS;
            String gatewayPrefix = this.systemConfig.getGatewayPrefix();
            if (StringUtils.isBlank((CharSequence)gatewayPrefix) || "/".equals(gatewayPrefix)) {
                secFS = path.indexOf(47, 1);
                service = secFS == -1 ? path.substring(1) : path.substring(1, secFS);
            } else {
                secFS = path.indexOf(47, 1);
                if (secFS == -1) {
                    return WebUtils.responseError(exchange, HttpStatus.INTERNAL_SERVER_ERROR.value(), "request path should like /gateway-prefix/service-name/real-biz-path");
                }
                service = path.substring(1, secFS);
            }
            if (service.equals(admin) || service.equals(actuator)) {
                adminReq = true;
                exchange.getAttributes().put("ar@", "");
            } else if (service.equals("_proxytest")) {
                proxyTestReq = true;
            } else {
                service = WebUtils.getClientService(exchange);
                if (service.startsWith(_fizz)) {
                    fizzApiReq = true;
                    exchange.getAttributes().put("fr@", "");
                }
            }
            this.setTraceId(exchange);
        }
        if (!(favReq || !this.flowControlFilterProperties.isFlowControl() || adminReq || proxyTestReq || fizzApiReq)) {
            String traceId = WebUtils.getTraceId(exchange);
            ThreadContext.put((String)"traceId", (String)traceId);
            if (!this.apiConfigService.serviceConfigMap.containsKey(service)) {
                String json = WebUtils.jsonRespBody(HttpStatus.FORBIDDEN.value(), "no service " + service + " in flow config", traceId);
                return WebUtils.responseJson(exchange, HttpStatus.FORBIDDEN, null, json);
            }
            String app = WebUtils.getAppId(exchange);
            path = WebUtils.getClientReqPath(exchange);
            String ip = WebUtils.getOriginIp(exchange);
            long currentTimeSlot = this.flowStat.currentTimeSlotId();
            String host = request.getHeaders().getFirst("Host");
            List<ResourceConfig> resourceConfigs = this.getFlowControlConfigs(app, ip, host, service, path);
            IncrRequestResult result = this.flowStat.incrRequest(exchange, resourceConfigs, currentTimeSlot, (rc, rcs) -> this.getResourceConfigItselfAndParents((ResourceConfig)rc, (List<ResourceConfig>)rcs));
            if (result != null && !result.isSuccess()) {
                long currentTimeMillis = System.currentTimeMillis();
                String blockedResourceId = result.getBlockedResourceId();
                if (BlockType.CIRCUIT_BREAK == result.getBlockType()) {
                    this.fizzMonitorService.alarm(service, path, (byte)4, null);
                    log.info("{} trigger {} circuit breaker limit", (Object)traceId, (Object)blockedResourceId);
                    String responseContentType = this.flowControlFilterProperties.getDegradeDefaultResponseContentType();
                    String responseContent = this.flowControlFilterProperties.getDegradeDefaultResponseContent();
                    CircuitBreaker cb = this.circuitBreakManager.getCircuitBreaker(blockedResourceId);
                    if (cb == null) {
                        cb = this.circuitBreakManager.getCircuitBreaker(ResourceIdUtils.buildResourceId(null, null, null, service, null));
                    }
                    if (cb.responseContentType != null) {
                        responseContentType = cb.responseContentType;
                        responseContent = cb.responseContent;
                    } else {
                        cb = this.circuitBreakManager.getCircuitBreaker(ResourceIdUtils.SERVICE_DEFAULT_RESOURCE);
                        if (cb.responseContentType != null) {
                            responseContentType = cb.responseContentType;
                            responseContent = cb.responseContent;
                        }
                    }
                    ServerHttpResponse resp = exchange.getResponse();
                    resp.setStatusCode(HttpStatus.FORBIDDEN);
                    HttpHeaders headers = resp.getHeaders();
                    headers.set("Content-Type", responseContentType);
                    headers.set("traceId", traceId);
                    return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(responseContent.getBytes())));
                }
                if (BlockType.CONCURRENT_REQUEST == result.getBlockType()) {
                    this.fizzMonitorService.alarm(service, path, (byte)3, concurrents);
                    log.info("{} exceed {} flow limit, blocked by maximum concurrent requests", (Object)traceId, (Object)blockedResourceId);
                } else {
                    this.fizzMonitorService.alarm(service, path, (byte)3, qps);
                    log.info("{} exceed {} flow limit, blocked by maximum QPS", (Object)traceId, (Object)blockedResourceId);
                }
                ResourceRateLimitConfig c = this.resourceRateLimitConfigService.getResourceRateLimitConfig(ResourceIdUtils.NODE_RESOURCE);
                String rt = c.responseType;
                String rc2 = c.responseContent;
                c = this.resourceRateLimitConfigService.getResourceRateLimitConfig(blockedResourceId);
                if (c != null) {
                    if (StringUtils.isNotBlank((CharSequence)c.responseType)) {
                        rt = c.responseType;
                    }
                    if (StringUtils.isNotBlank((CharSequence)c.responseContent)) {
                        rc2 = c.responseContent;
                    }
                }
                ServerHttpResponse resp = exchange.getResponse();
                resp.setStatusCode(HttpStatus.OK);
                resp.getHeaders().add("Content-Type", rt);
                return resp.writeWith((Publisher)Mono.just((Object)resp.bufferFactory().wrap(rc2.getBytes())));
            }
            long start = System.currentTimeMillis();
            this.setTraceId(exchange);
            String finalService = service;
            String finalPath = path;
            return chain.filter(exchange).doFinally(s -> {
                long rt = System.currentTimeMillis() - start;
                CircuitBreaker cb = (CircuitBreaker)exchange.getAttribute("detectReq@");
                HttpStatus statusCode = exchange.getResponse().getStatusCode();
                Throwable t = (Throwable)exchange.getAttribute("origerr@");
                if (t instanceof TimeoutException) {
                    statusCode = HttpStatus.GATEWAY_TIMEOUT;
                }
                if (s == SignalType.ON_ERROR || statusCode.is5xxServerError()) {
                    this.flowStat.addRequestRT(resourceConfigs, currentTimeSlot, rt, false, statusCode);
                    if (cb != null) {
                        cb.transit(CircuitBreaker.State.RESUME_DETECTIVE, CircuitBreaker.State.OPEN, currentTimeSlot, this.flowStat);
                    }
                    if (statusCode == HttpStatus.GATEWAY_TIMEOUT) {
                        this.fizzMonitorService.alarm(finalService, finalPath, (byte)2, t.getMessage());
                    } else if (statusCode.is5xxServerError()) {
                        this.fizzMonitorService.alarm(finalService, finalPath, (byte)1, String.valueOf(statusCode.value()));
                    } else if (s == SignalType.ON_ERROR && t != null) {
                        this.fizzMonitorService.alarm(finalService, finalPath, (byte)1, t.getMessage());
                    }
                } else {
                    this.flowStat.addRequestRT(resourceConfigs, currentTimeSlot, rt, true, statusCode);
                    if (cb != null) {
                        cb.transit(CircuitBreaker.State.RESUME_DETECTIVE, CircuitBreaker.State.CLOSED, currentTimeSlot, this.flowStat);
                    }
                }
            });
        }
        return chain.filter(exchange);
    }

    private void setTraceId(ServerWebExchange exchange) {
        String fizzTraceIdValuePrefix;
        String traceId = exchange.getRequest().getHeaders().getFirst(this.systemConfig.fizzTraceIdHeader());
        if (StringUtils.isBlank((CharSequence)traceId)) {
            String fizzTraceIdValueStrategy = this.systemConfig.fizzTraceIdValueStrategy();
            if (fizzTraceIdValueStrategy.equals(defaultFizzTraceIdValueStrategy)) {
                traceId = exchange.getRequest().getId();
            } else if (fizzTraceIdValueStrategy.equals(uuid)) {
                traceId = UUIDUtil.getUUID();
            } else {
                throw Utils.runtimeExceptionWithoutStack((String)("unsupported " + fizzTraceIdValueStrategy + " trace id value strategy!"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(fizzTraceIdValuePrefix = this.systemConfig.fizzTraceIdValuePrefix()))) {
            traceId = fizzTraceIdValuePrefix + '-' + traceId;
        }
        exchange.getAttributes().put("traid@", traceId);
    }

    private List<ResourceConfig> getResourceConfigItselfAndParents(ResourceConfig rc, List<ResourceConfig> rcs) {
        boolean check = false;
        String rcId = rc.getResourceId();
        String rcApp = ResourceIdUtils.getApp(rcId);
        String rcIp = ResourceIdUtils.getIp(rcId);
        ArrayList<ResourceConfig> result = new ArrayList<ResourceConfig>();
        for (int i = rcs.size() - 1; i > -1; --i) {
            ResourceConfig r = rcs.get(i);
            String id = r.getResourceId();
            String node = ResourceIdUtils.getNode(id);
            if (node != null && !node.equals("_global")) {
                result.add(r);
                continue;
            }
            String app = ResourceIdUtils.getApp(id);
            String ip = ResourceIdUtils.getIp(id);
            String path = ResourceIdUtils.getPath(id);
            if (check) {
                if (rcIp != null) {
                    if (ip != null) {
                        result.add(r);
                        continue;
                    }
                    if (app != null || path != null) continue;
                    result.add(r);
                    continue;
                }
                if (rcApp != null) {
                    if (app != null) {
                        result.add(r);
                        continue;
                    }
                    if (path != null) continue;
                    result.add(r);
                    continue;
                }
                result.add(r);
                continue;
            }
            if (!id.equals(rcId)) continue;
            result.add(r);
            check = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("getResourceConfigItselfAndParents:\n" + JacksonUtils.writeValueAsString((Object)rc) + '\n' + JacksonUtils.writeValueAsString(result));
        }
        return result;
    }

    private List<ResourceConfig> getFlowControlConfigs(String app, String ip, String node, String service, String path) {
        if (log.isDebugEnabled()) {
            log.debug("get flow control configs by app={}, ip={}, node={}, service={}, path={}", new Object[]{app, ip, node, service, path});
        }
        boolean hasHost = StringUtils.isNotBlank((CharSequence)node) && !node.equals("_global");
        int sz = hasHost ? 10 : 9;
        ArrayList<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>(sz);
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        if (hasHost) {
            String resourceId = ResourceIdUtils.buildResourceId(null, null, node, null, null);
            ResourceConfig resourceConfig = new ResourceConfig(resourceId, 0L, 0L);
            resourceConfigs.add(resourceConfig);
        }
        this.checkRateLimitConfigAndAddTo(resourceConfigs, b, null, null, "_global", null, null, null);
        this.checkRateLimitConfigAndAddTo(resourceConfigs, b, null, null, null, service, null, "service_default");
        this.checkRateLimitConfigAndAddTo(resourceConfigs, b, null, null, null, service, path, null);
        if (app != null) {
            this.checkRateLimitConfigAndAddTo(resourceConfigs, b, app, null, null, null, null, "app_default");
            this.checkRateLimitConfigAndAddTo(resourceConfigs, b, app, null, null, service, null, null);
            this.checkRateLimitConfigAndAddTo(resourceConfigs, b, app, null, null, service, path, null);
        }
        if (ip != null) {
            this.checkRateLimitConfigAndAddTo(resourceConfigs, b, null, ip, null, null, null, null);
            this.checkRateLimitConfigAndAddTo(resourceConfigs, b, null, ip, null, service, null, null);
            this.checkRateLimitConfigAndAddTo(resourceConfigs, b, null, ip, null, service, path, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("resource configs: " + JacksonUtils.writeValueAsString(resourceConfigs));
        }
        return resourceConfigs;
    }

    private void checkRateLimitConfigAndAddTo(List<ResourceConfig> resourceConfigs, StringBuilder b, String app, String ip, String node, String service, String path, String defaultRateLimitConfigId) {
        ResourceIdUtils.buildResourceIdTo(b, app, ip, node, service, path);
        String resourceId = b.toString();
        boolean checkDegradeRule = app == null && ip == null && node == null;
        this.checkRateLimitConfigAndAddTo(resourceConfigs, resourceId, defaultRateLimitConfigId, checkDegradeRule);
        b.delete(0, b.length());
    }

    private void checkRateLimitConfigAndAddTo(List<ResourceConfig> resourceConfigs, String resource, String defaultRateLimitConfigId, boolean checkDegradeRule) {
        CircuitBreaker cb;
        int prevSize = resourceConfigs.size();
        ResourceConfig rc = null;
        ResourceRateLimitConfig rateLimitConfig = this.resourceRateLimitConfigService.getResourceRateLimitConfig(resource);
        if (rateLimitConfig != null && rateLimitConfig.isEnable()) {
            this.something4appAndIp(resourceConfigs, rateLimitConfig);
            rc = new ResourceConfig(resource, rateLimitConfig.concurrents, rateLimitConfig.qps);
            resourceConfigs.add(rc);
        } else {
            String node = ResourceIdUtils.getNode(resource);
            if (node != null && node.equals("_global")) {
                rc = new ResourceConfig(resource, 0L, 0L);
            }
            if (defaultRateLimitConfigId != null) {
                if (defaultRateLimitConfigId.equals("service_default")) {
                    rc = new ResourceConfig(resource, 0L, 0L);
                    rateLimitConfig = this.resourceRateLimitConfigService.getResourceRateLimitConfig(ResourceIdUtils.SERVICE_DEFAULT_RESOURCE);
                    if (rateLimitConfig != null && rateLimitConfig.isEnable()) {
                        rc.setMaxCon(rateLimitConfig.concurrents);
                        rc.setMaxQPS(rateLimitConfig.qps);
                    }
                }
                if (defaultRateLimitConfigId.equals("app_default") && (rateLimitConfig = this.resourceRateLimitConfigService.getResourceRateLimitConfig(ResourceIdUtils.APP_DEFAULT_RESOURCE)) != null && rateLimitConfig.isEnable()) {
                    rc = new ResourceConfig(resource, rateLimitConfig.concurrents, rateLimitConfig.qps);
                }
            }
            if (rc != null) {
                resourceConfigs.add(rc);
            }
        }
        if (checkDegradeRule && resourceConfigs.size() == prevSize && (cb = this.circuitBreakManager.getCircuitBreaker(resource)) != null) {
            rc = new ResourceConfig(resource, 0L, 0L);
            resourceConfigs.add(rc);
        }
    }

    private void something4appAndIp(List<ResourceConfig> resourceConfigs, ResourceRateLimitConfig rateLimitConfig) {
        int sz = resourceConfigs.size();
        String prev = null;
        String prevPrev = null;
        if (sz > 1) {
            prev = resourceConfigs.get(sz - 1).getResourceId();
            prevPrev = resourceConfigs.get(sz - 2).getResourceId();
            if (rateLimitConfig.type == 6) {
                String app = ResourceIdUtils.getApp(prev);
                if (rateLimitConfig.path == null) {
                    if (rateLimitConfig.service != null && app == null) {
                        this.something4(resourceConfigs, rateLimitConfig.app, null, null);
                    }
                } else if (app == null) {
                    this.something4(resourceConfigs, rateLimitConfig.app, null, null);
                    this.something4(resourceConfigs, rateLimitConfig.app, null, rateLimitConfig.service);
                } else {
                    String service = ResourceIdUtils.getService(prev);
                    if (service == null) {
                        this.something4(resourceConfigs, rateLimitConfig.app, null, rateLimitConfig.service);
                    }
                }
            } else if (rateLimitConfig.type == 7 && (rateLimitConfig.service != null || rateLimitConfig.path != null)) {
                if (rateLimitConfig.path == null) {
                    String ip = ResourceIdUtils.getIp(prev);
                    if (ip == null) {
                        this.something4(resourceConfigs, null, rateLimitConfig.ip, null);
                    }
                } else {
                    String ip = ResourceIdUtils.getIp(prev);
                    if (ip == null) {
                        this.something4(resourceConfigs, null, rateLimitConfig.ip, null);
                        this.something4(resourceConfigs, null, rateLimitConfig.ip, rateLimitConfig.service);
                    } else {
                        String service = ResourceIdUtils.getService(prev);
                        if (service == null) {
                            this.something4(resourceConfigs, null, rateLimitConfig.ip, rateLimitConfig.service);
                        }
                    }
                }
            }
        }
    }

    private void something4(List<ResourceConfig> resourceConfigs, String app, String ip, String service) {
        String r = ResourceIdUtils.buildResourceId(app, ip, null, service, null);
        ResourceConfig rc = new ResourceConfig(r, 0L, 0L);
        resourceConfigs.add(rc);
    }

    private void fillDegradeRuleData(ResourceConfig resourceConfig, DegradeRule degradeRule) {
        resourceConfig.setStrategy(degradeRule.getStrategy());
        resourceConfig.setRatioThreshold(degradeRule.getRatioThreshold());
        resourceConfig.setExceptionCount(degradeRule.getExceptionCount());
        resourceConfig.setMinRequestCount(degradeRule.getMinRequestCount());
        resourceConfig.setTimeWindow(degradeRule.getTimeWindow());
        resourceConfig.setStatInterval(degradeRule.getStatInterval());
        resourceConfig.setRecoveryStrategy(degradeRule.getRecoveryStrategy());
        resourceConfig.setRecoveryTimeWindow(degradeRule.getRecoveryTimeWindow());
    }
}

