/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.fizzgate.filter.FilterResult;
import com.fizzgate.filter.FizzWebFilter;
import com.fizzgate.plugin.FixedPluginFilter;
import com.fizzgate.plugin.FizzPluginFilterChain;
import com.fizzgate.plugin.PluginConfig;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.plugin.auth.AuthPluginFilter;
import com.fizzgate.plugin.auth.GatewayGroup;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.fizzgate.plugin.stat.StatPluginFilter;
import com.fizzgate.proxy.Route;
import com.fizzgate.util.ReactorUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.WebUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component(value="preprocessFilter")
@Order(value=10)
public class PreprocessFilter
extends FizzWebFilter {
    private static final Logger log = LoggerFactory.getLogger(PreprocessFilter.class);
    public static final String PREPROCESS_FILTER = "preprocessFilter";
    private static final FilterResult succFr = FilterResult.SUCCESS("preprocessFilter");
    @Resource(name="statPlugin")
    private StatPluginFilter statPluginFilter;
    @Resource(name="authPlugin")
    private AuthPluginFilter authPluginFilter;
    @Resource
    private GatewayGroupService gatewayGroupService;

    @Override
    public Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        HashMap<String, FilterResult> fc = new HashMap<String, FilterResult>();
        fc.put("pfr@", succFr);
        HashMap appendHdrs = new HashMap(8);
        Map eas = exchange.getAttributes();
        eas.put("fc@", fc);
        eas.put("ahs@", appendHdrs);
        return this.statPluginFilter.filter(exchange, null, null).then(this.authPluginFilter.filter(exchange, null, null)).thenReturn(ReactorUtils.Void).flatMap(v -> {
            Result auth = (Result)WebUtils.getFilterResultDataItem(exchange, "authPlugin", "result");
            if (auth.code == 0) {
                return WebUtils.responseError(exchange, HttpStatus.FORBIDDEN.value(), auth.msg);
            }
            ApiConfig ac = (ApiConfig)auth.data;
            if (ac == null) {
                this.afterAuth(exchange, null, null);
                return this.executeFixedPluginFilters(exchange).thenReturn(ReactorUtils.Void).flatMap(this.checkDirectRespOrChainFilter(exchange, chain));
            }
            List<PluginConfig> gatewayGroupPluginConfigs = null;
            GatewayGroup gatewayGroup = this.gatewayGroupService.get(ac.firstGatewayGroup);
            if (gatewayGroup != null) {
                gatewayGroupPluginConfigs = gatewayGroup.pluginConfigs;
            }
            Route route = ac.getRoute(exchange, gatewayGroupPluginConfigs);
            eas.put("rout@", route);
            this.afterAuth(exchange, ac, route);
            return this.executeFixedPluginFilters(exchange).thenReturn(ReactorUtils.Void).flatMap(e -> {
                if (route.pluginConfigs.isEmpty()) {
                    return this.checkDirectRespOrChainFilter(exchange, chain).apply(ReactorUtils.NULL);
                }
                eas.put("wfc@", chain);
                return FizzPluginFilterChain.next(exchange);
            });
        });
    }

    private void afterAuth(ServerWebExchange exchange, ApiConfig ac, Route route) {
        String bs = null;
        String bp = null;
        if (ac == null) {
            bs = WebUtils.getClientService(exchange);
            bp = WebUtils.getClientReqPath(exchange);
        } else if (ac.type != 4) {
            if (ac.type != 3) {
                bs = ac.backendService;
            }
            if (ac.type != 5) {
                route.backendPath = bp = ac.transform(WebUtils.getClientReqPath(exchange));
            }
        }
        if (bs != null) {
            WebUtils.setBackendService(exchange, bs);
        }
        if (bp != null) {
            WebUtils.setBackendPath(exchange, bp);
        }
    }

    private Function<Object, Mono<Void>> checkDirectRespOrChainFilter(ServerWebExchange exchange, WebFilterChain chain) {
        return v -> {
            Mono<Void> dr = WebUtils.getDirectResponse(exchange);
            if (dr != null) {
                return dr;
            }
            return chain.filter(exchange);
        };
    }

    private Mono<Void> executeFixedPluginFilters(ServerWebExchange exchange) {
        Mono vm = Mono.empty();
        List<FixedPluginFilter> fixedPluginFilters = FixedPluginFilter.getPluginFilters();
        for (int i = 0; i < fixedPluginFilters.size(); i = (int)((byte)(i + 1))) {
            FixedPluginFilter fpf = fixedPluginFilters.get(i);
            vm = vm.then(fpf.filter(exchange, null, null));
        }
        return vm;
    }
}

