/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.filter;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.filter.FilterResult;
import com.fizzgate.filter.FizzWebFilter;
import com.fizzgate.proxy.FizzWebClient;
import com.fizzgate.proxy.Route;
import com.fizzgate.proxy.dubbo.ApacheDubboGenericService;
import com.fizzgate.proxy.dubbo.DubboInterfaceDeclaration;
import com.fizzgate.service_registry.RegistryCenterService;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.WebUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@Order(value=0x7FFFFFFF)
public class RouteFilter
extends FizzWebFilter {
    private static final Logger log = LoggerFactory.getLogger(RouteFilter.class);
    @Resource
    private FizzWebClient fizzWebClient;
    @Resource
    private ApacheDubboGenericService dubboGenericService;
    @Resource
    private SystemConfig systemConfig;

    @Override
    public Mono<Void> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        FilterResult pfr = WebUtils.getPrevFilterResult(exchange);
        if (pfr.success) {
            return this.doFilter0(exchange, chain);
        }
        Mono<Void> resp = WebUtils.getDirectResponse(exchange);
        if (resp == null) {
            ServerHttpRequest clientReq = exchange.getRequest();
            String traceId = WebUtils.getTraceId(exchange);
            ThreadContext.put((String)"traceId", (String)traceId);
            String msg = traceId + ' ' + pfr.id + " fail";
            if (pfr.cause == null) {
                log.error(msg);
            } else {
                log.error(msg, pfr.cause);
            }
            HttpStatus s = HttpStatus.INTERNAL_SERVER_ERROR;
            if (!SystemConfig.FIZZ_ERR_RESP_HTTP_STATUS_ENABLE) {
                s = HttpStatus.OK;
            }
            return WebUtils.buildJsonDirectResponseAndBindContext(exchange, s, null, WebUtils.jsonRespBody(s.value(), msg, traceId));
        }
        return resp;
    }

    private Mono<Void> doFilter0(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest req = exchange.getRequest();
        String traceId = WebUtils.getTraceId(exchange);
        Route route = (Route)exchange.getAttribute("rout@");
        HttpHeaders hdrs = null;
        if (route != null && route.type != 5) {
            hdrs = WebUtils.mergeAppendHeaders(exchange);
            WebUtils.setXForwardedFor(exchange, hdrs);
        }
        if (route == null) {
            Map.Entry<String, List<String>> pathQueryTemplate = WebUtils.getClientReqPathQueryTemplate(exchange).entrySet().iterator().next();
            return this.fizzWebClient.send2service(traceId, req.getMethod(), WebUtils.getClientService(exchange), pathQueryTemplate.getKey(), hdrs, (Object)req.getBody(), 0L, 0L, 0L, pathQueryTemplate.getValue().toArray(new String[0])).flatMap(this.genServerResponse(exchange));
        }
        if (route.type == 2) {
            Map.Entry<String, List<String>> pathQueryTemplate = this.getBackendPathQueryTemplate(req, route).entrySet().iterator().next();
            String svc = RegistryCenterService.getServiceNameSpace(route.registryCenter, route.backendService);
            return this.fizzWebClient.send2service(traceId, route.method, svc, pathQueryTemplate.getKey(), hdrs, (Object)req.getBody(), route.timeout, route.retryCount, route.retryInterval, pathQueryTemplate.getValue().toArray(new String[0])).flatMap(this.genServerResponse(exchange));
        }
        if (route.type == 3) {
            Map.Entry<String, List<String>> pathQueryTemplate = this.getBackendPathQueryTemplate(req, route).entrySet().iterator().next();
            String uri = com.fizzgate.util.ThreadContext.getStringBuilder().append(route.nextHttpHostPort).append(pathQueryTemplate.getKey()).toString();
            return this.fizzWebClient.send(traceId, route.method, uri, hdrs, (Object)req.getBody(), route.timeout, route.retryCount, route.retryInterval, pathQueryTemplate.getValue().toArray(new String[0])).flatMap(this.genServerResponse(exchange));
        }
        return this.dubboRpc(exchange, route);
    }

    private String getBackendPathQuery(ServerHttpRequest request, Route route) {
        String qry = route.query;
        if (qry == null) {
            MultiValueMap queryParams = request.getQueryParams();
            if (queryParams.isEmpty()) {
                return route.backendPath;
            }
            return route.backendPath + '?' + WebUtils.toQueryString((MultiValueMap<String, String>)queryParams);
        }
        return route.backendPath + '?' + qry;
    }

    private Map<String, List<String>> getBackendPathQueryTemplate(ServerHttpRequest request, Route route) {
        String qry = route.query;
        if (qry == null) {
            MultiValueMap queryParams = request.getQueryParams();
            if (queryParams.isEmpty()) {
                return Collections.singletonMap(route.backendPath, Collections.emptyList());
            }
            Map<String, List<String>> queryStringTemplate = WebUtils.toQueryStringTemplate((MultiValueMap<String, String>)queryParams);
            Map.Entry<String, List<String>> entry = queryStringTemplate.entrySet().iterator().next();
            qry = route.backendPath + '?' + entry.getKey();
            return Collections.singletonMap(qry, entry.getValue());
        }
        return Collections.singletonMap(route.backendPath + '?' + qry, Collections.emptyList());
    }

    private Function<ClientResponse, Mono<? extends Void>> genServerResponse(ServerWebExchange exchange) {
        return remoteResp -> {
            ServerHttpResponse clientResp = exchange.getResponse();
            clientResp.setStatusCode(remoteResp.statusCode());
            HttpHeaders clientRespHeaders = clientResp.getHeaders();
            HttpHeaders remoteRespHeaders = remoteResp.headers().asHttpHeaders();
            remoteRespHeaders.entrySet().forEach(h -> {
                String k = (String)h.getKey();
                if (clientRespHeaders.containsKey((Object)k)) {
                    if (!(k.equals("Access-Control-Allow-Origin") || k.equals("Access-Control-Allow-Credentials") || k.equals("Access-Control-Allow-Headers") || k.equals("Access-Control-Max-Age") || k.equals("Access-Control-Allow-Methods"))) {
                        clientRespHeaders.put(k, (List)h.getValue());
                    }
                } else {
                    clientRespHeaders.put(k, (List)h.getValue());
                }
            });
            if (log.isDebugEnabled()) {
                StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
                String traceId = WebUtils.getTraceId(exchange);
                WebUtils.response2stringBuilder(traceId, remoteResp, b);
                ThreadContext.put((String)"traceId", (String)traceId);
                log.debug(b.toString());
            }
            return clientResp.writeWith((Publisher)remoteResp.body(BodyExtractors.toDataBuffers())).doOnError(throwable -> this.cleanup((ClientResponse)remoteResp)).doOnCancel(() -> this.cleanup((ClientResponse)remoteResp));
        };
    }

    private void cleanup(ClientResponse clientResponse) {
        if (clientResponse != null) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }

    private Mono<Void> dubboRpc(ServerWebExchange exchange, Route route) {
        String[] ls = new String[]{null};
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(b -> {
            HashMap<String, Object> parameters = null;
            if (b != NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                String json;
                ls[0] = json = b.toString(StandardCharsets.UTF_8).trim();
                NettyDataBufferUtils.release((DataBuffer)b);
                if (json.charAt(0) == '[') {
                    ArrayList lst = (ArrayList)JacksonUtils.readValue((String)json, ArrayList.class);
                    parameters = new HashMap<String, Object>();
                    for (int i = 0; i < lst.size(); ++i) {
                        parameters.put("p" + (i + 1), lst.get(i));
                    }
                } else {
                    parameters = (HashMap<String, Object>)JacksonUtils.readValue((String)json, HashMap.class);
                }
            }
            DubboInterfaceDeclaration declaration = new DubboInterfaceDeclaration();
            declaration.setServiceName(route.backendService);
            declaration.setVersion(route.rpcVersion);
            declaration.setGroup(route.rpcGroup);
            declaration.setMethod(route.rpcMethod);
            declaration.setParameterTypes(route.rpcParamTypes);
            int t = 20000;
            if (route.timeout != 0L) {
                t = (int)route.timeout;
            }
            declaration.setTimeout(t);
            Map<String, String> attachments = Collections.singletonMap(this.systemConfig.fizzTraceIdHeader(), WebUtils.getTraceId(exchange));
            return this.dubboGenericService.send(parameters, declaration, attachments);
        }).flatMap(dubboRpcResponseBody -> {
            Mono<Void> m = WebUtils.responseJson(exchange, HttpStatus.OK, null, JacksonUtils.writeValueAsString((Object)dubboRpcResponseBody));
            return m;
        }).doOnError(t -> {
            StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
            WebUtils.request2stringBuilder(exchange, b);
            if (ls[0] != null) {
                b.append('\n').append(ls[0]);
            }
            ThreadContext.put((String)"traceId", (String)WebUtils.getTraceId(exchange));
            log.error(b.toString(), t);
        });
    }
}

