/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz;

import com.alibaba.fastjson.JSON;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.fizz.AggregateResource;
import com.fizzgate.fizz.AggregateResult;
import com.fizzgate.fizz.ConfigLoader;
import com.fizzgate.fizz.Pipeline;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.util.MapUtil;
import com.fizzgate.util.Utils;
import com.fizzgate.util.WebUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class AggregateService {
    private static final Logger log = LoggerFactory.getLogger(AggregateService.class);
    @Resource
    private ConfigLoader aggregateResourceLoader;
    @Resource
    private SystemConfig systemConfig;

    public Mono<AggregateResult> request(String traceId, String clientReqPathPrefix, String method, String service, String path, MultiValueMap<String, String> queryParams, HttpHeaders headers, String body) {
        String pash = clientReqPathPrefix + service + path;
        AggregateResource aggregateResource = this.aggregateResourceLoader.matchAggregateResource(method, pash);
        if (aggregateResource == null) {
            return Mono.error((Throwable)Utils.runtimeExceptionWithoutStack((String)("no aggregate resource: " + method + ' ' + pash)));
        }
        Pipeline pipeline = aggregateResource.getPipeline();
        Input input = aggregateResource.getInput();
        Map hs = MapUtil.toHashMap((MultiValueMap)headers);
        ThreadContext.put((String)"traceId", (String)traceId);
        log.debug("matched aggregation api: {}", (Object)pash);
        HashMap<String, Object> clientInput = new HashMap<String, Object>();
        clientInput.put("path", pash);
        clientInput.put("method", method);
        clientInput.put("headers", hs);
        if (queryParams != null) {
            clientInput.put("params", MapUtil.toHashMap(queryParams));
        }
        if (body != null) {
            clientInput.put("body", JSON.parse((String)body));
        }
        return pipeline.run(input, clientInput, traceId).subscribeOn(Schedulers.elastic());
    }

    public Mono<AggregateResult> request(String traceId, String clientReqPathPrefix, String method, String service, String path, MultiValueMap<String, String> queryParams, HttpHeaders headers, DataBuffer body) {
        String b = null;
        if (body != null) {
            b = body.toString(StandardCharsets.UTF_8);
        }
        return this.request(traceId, clientReqPathPrefix, method, service, path, queryParams, headers, b);
    }

    public Mono<? extends Void> genAggregateResponse(ServerWebExchange exchange, AggregateResult ar) {
        List headerTraceIds;
        ServerHttpResponse clientResp = exchange.getResponse();
        String traceId = WebUtils.getTraceId(exchange);
        ThreadContext.put((String)"traceId", (String)traceId);
        String js = null;
        js = ar.getBody() instanceof String ? (String)ar.getBody() : JSON.toJSONString((Object)ar.getBody());
        log.debug("aggregate response body: {}", (Object)js);
        if (ar.getHeaders() != null && !ar.getHeaders().isEmpty()) {
            ar.getHeaders().remove((Object)"Content-Length");
            clientResp.getHeaders().addAll(ar.getHeaders());
        }
        if (!clientResp.getHeaders().containsKey((Object)"Content-Type")) {
            clientResp.getHeaders().add("Content-Type", "application/json; charset=UTF-8");
        }
        if ((headerTraceIds = clientResp.getHeaders().get((Object)this.systemConfig.fizzTraceIdHeader())) == null || !headerTraceIds.contains(traceId)) {
            clientResp.getHeaders().add(this.systemConfig.fizzTraceIdHeader(), traceId);
        }
        return clientResp.writeWith((Publisher)Flux.just((Object)exchange.getResponse().bufferFactory().wrap(js.getBytes())));
    }
}

