/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.fizzgate.config.AppConfigProperties;
import com.fizzgate.fizz.AggregateResource;
import com.fizzgate.fizz.ConfigLoaderProperties;
import com.fizzgate.fizz.Pipeline;
import com.fizzgate.fizz.Step;
import com.fizzgate.fizz.input.ClientInputConfig;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.fizz.input.InputFactory;
import com.fizzgate.fizz.input.InputType;
import com.fizzgate.util.ReactorUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.ThreadContext;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ConfigLoader {
    private static final String LEGACY_FORMAL_PATH_PREFIX = "/proxy";
    private static final String LEGACY_TEST_PATH_PREFIX = "/proxytest";
    private static final String TEST_PATH_PREFIX = "/_proxytest";
    private static final int TEST_PATH_SERVICE_NAME_START_INDEX = "/_proxytest".length() + 1;
    @Autowired
    public ConfigurableApplicationContext appContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoader.class);
    private static final String AGGREGATE_HASH_KEY = "fizz_aggregate_config";
    private static Map<String, String> aggregateResources = null;
    private static Map<String, ConfigInfo> resourceKey2ConfigInfoMap = null;
    private static Map<String, String> aggregateId2ResourceKeyMap = null;
    @Resource
    private AppConfigProperties appConfigProperties;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate reactiveStringRedisTemplate;
    @Resource
    private ConfigLoaderProperties configLoaderProperties;
    private String formalPathPrefix;
    private int formalPathServiceNameStartIndex;

    public Input createInput(String configStr) throws IOException {
        ONode cfgNode = ONode.loadStr((String)configStr);
        Input input = new Input();
        input.setName(cfgNode.select("$.name").getString());
        ClientInputConfig clientInputConfig = new ClientInputConfig();
        clientInputConfig.setDataMapping((Map)cfgNode.select("$.dataMapping").toObject(Map.class));
        clientInputConfig.setHeaders((Map)cfgNode.select("$.headers").toObject(Map.class));
        clientInputConfig.setMethod(cfgNode.select("$.method").getString());
        clientInputConfig.setPath(cfgNode.select("$.path").getString());
        if (clientInputConfig.getPath().startsWith(TEST_PATH_PREFIX)) {
            clientInputConfig.setDebug(true);
        } else if (cfgNode.select("$.debug") != null) {
            clientInputConfig.setDebug(cfgNode.select("$.debug").getBoolean());
        }
        clientInputConfig.setType(InputType.valueOf(cfgNode.select("$.type").getString()));
        clientInputConfig.setLangDef((Map)cfgNode.select("$.langDef").toObject(Map.class));
        clientInputConfig.setBodyDef((Map)cfgNode.select("$.bodyDef").toObject(Map.class));
        clientInputConfig.setHeadersDef((Map)cfgNode.select("$.headersDef").toObject(Map.class));
        clientInputConfig.setParamsDef((Map)cfgNode.select("$.paramsDef").toObject(Map.class));
        clientInputConfig.setScriptValidate((Map)cfgNode.select("$.scriptValidate").toObject(Map.class));
        clientInputConfig.setValidateResponse((Map)cfgNode.select("$.validateResponse").toObject(Map.class));
        clientInputConfig.setContentType(cfgNode.select("$.contentType").getString());
        clientInputConfig.setXmlArrPaths(cfgNode.select("$.xmlArrPaths").getString());
        input.setConfig(clientInputConfig);
        return input;
    }

    public Pipeline createPipeline(String configStr) throws IOException {
        ONode cfgNode = ONode.loadStr((String)configStr);
        Pipeline pipeline = new Pipeline();
        pipeline.setApplicationContext(this.appContext);
        List stepConfigs = (List)cfgNode.select("$.stepConfigs").toObject(List.class);
        for (Map stepConfig : stepConfigs) {
            this.handleRequestURL(stepConfig);
            SoftReference<Pipeline> weakPipeline = new SoftReference<Pipeline>(pipeline);
            Step step = new Step.Builder().read(stepConfig, weakPipeline);
            step.setName((String)stepConfig.get("name"));
            if (stepConfig.get("stop") != null) {
                step.setStop((Boolean)stepConfig.get("stop"));
            } else {
                step.setStop(false);
            }
            step.setDataMapping((Map)stepConfig.get("dataMapping"));
            pipeline.addStep(step);
        }
        return pipeline;
    }

    public List<ConfigInfo> getConfigInfo() {
        if (aggregateResources == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<ConfigInfo>(resourceKey2ConfigInfoMap.values());
    }

    public String getConfigStr(String configId) {
        String resourceKey;
        if (aggregateResources == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((resourceKey = aggregateId2ResourceKeyMap.get(configId)) == null) {
            return null;
        }
        return aggregateResources.get(resourceKey);
    }

    private void handleRequestURL(Map<String, Object> stepConfig) {
        List requests = (List)stepConfig.get("requests");
        for (Object obj : requests) {
            Map request = (Map)obj;
            String envUrl = (String)request.get(this.appConfigProperties.getEnv() + "Url");
            if (StringUtils.isEmpty((Object)envUrl)) continue;
            request.put("url", request.get(this.appConfigProperties.getEnv() + "Url"));
        }
    }

    @PostConstruct
    public synchronized void init() throws Exception {
        this.refreshLocalCache();
        InputFactory.loadInputClasses();
    }

    public synchronized void refreshLocalCache() throws Exception {
        if (this.formalPathPrefix == null) {
            String formalPathPrefixTmp = this.appContext.getEnvironment().getProperty("gateway.prefix", LEGACY_FORMAL_PATH_PREFIX);
            if (formalPathPrefixTmp.endsWith("/")) {
                formalPathPrefixTmp = formalPathPrefixTmp.substring(0, formalPathPrefixTmp.length() - 1);
            }
            this.formalPathPrefix = formalPathPrefixTmp;
            this.formalPathServiceNameStartIndex = this.formalPathPrefix.length() + 1;
        }
        ConcurrentHashMap<String, String> aggregateResourcesTmp = new ConcurrentHashMap<String, String>(1024);
        ConcurrentHashMap<String, ConfigInfo> resourceKey2ConfigInfoMapTmp = new ConcurrentHashMap<String, ConfigInfo>(1024);
        ConcurrentHashMap<String, String> aggregateId2ResourceKeyMapTmp = new ConcurrentHashMap<String, String>(1024);
        if (this.configLoaderProperties.getReadLocalConfigFlag().booleanValue()) {
            File[] files;
            File dir = new File("json");
            if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
                for (File file : files) {
                    if (!file.exists()) {
                        throw new IOException("File not found");
                    }
                    String configStr = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    this.addConfig(configStr, aggregateResourcesTmp, resourceKey2ConfigInfoMapTmp, aggregateId2ResourceKeyMapTmp);
                }
            }
        } else {
            Throwable[] throwable = new Throwable[1];
            Throwable error = (Throwable)Mono.just((Object)Objects.requireNonNull(this.reactiveStringRedisTemplate.opsForHash().entries((Object)AGGREGATE_HASH_KEY).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(t -> LOGGER.info(null, t)).concatMap(entry -> {
                Object k = entry.getKey();
                if (k == ReactorUtils.OBJ) {
                    return Flux.just((Object)entry);
                }
                String configStr = (String)entry.getValue();
                ThreadContext.put((String)"traceId", (String)k.toString());
                LOGGER.info("aggregate config: " + k.toString() + ':' + configStr);
                try {
                    this.addConfig(configStr, aggregateResourcesTmp, resourceKey2ConfigInfoMapTmp, aggregateId2ResourceKeyMapTmp);
                    return Flux.just((Object)entry);
                }
                catch (Throwable t) {
                    throwable[0] = t;
                    LOGGER.info(configStr, t);
                    return Flux.error((Throwable)t);
                }
            }).blockLast())).flatMap(e -> {
                if (throwable[0] != null) {
                    return Mono.error((Throwable)throwable[0]);
                }
                return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
            }).block();
            if (error != ReactorUtils.EMPTY_THROWABLE) {
                assert (error != null);
                throw new RuntimeException(error);
            }
        }
        aggregateResources = aggregateResourcesTmp;
        resourceKey2ConfigInfoMap = resourceKey2ConfigInfoMapTmp;
        aggregateId2ResourceKeyMap = aggregateId2ResourceKeyMapTmp;
    }

    public synchronized void addConfig(String configStr) {
        if (aggregateResources == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addConfig(configStr, aggregateResources, resourceKey2ConfigInfoMap, aggregateId2ResourceKeyMap);
    }

    private void addConfig(String configStr, Map<String, String> aggregateResources, Map<String, ConfigInfo> resourceKey2ConfigInfoMap, Map<String, String> aggregateId2ResourceKeyMap) {
        ONode cfgNode = ONode.loadStr((String)configStr);
        boolean needReGenConfigStr = false;
        boolean existAggrVersion = cfgNode.contains("aggrVersion");
        String method = cfgNode.select("$.method").getString();
        String path = cfgNode.select("$.path").getString();
        if (!existAggrVersion) {
            if (path.startsWith(LEGACY_TEST_PATH_PREFIX)) {
                path = path.replaceFirst(LEGACY_TEST_PATH_PREFIX, TEST_PATH_PREFIX);
                needReGenConfigStr = true;
            } else if (path.startsWith(LEGACY_FORMAL_PATH_PREFIX)) {
                path = path.replace(LEGACY_FORMAL_PATH_PREFIX, "");
                needReGenConfigStr = true;
            }
        }
        if (!path.startsWith(TEST_PATH_PREFIX)) {
            path = String.format("%s%s", this.formalPathPrefix, path);
            needReGenConfigStr = true;
        }
        String resourceKey = method.toUpperCase() + ":" + path;
        String configId = cfgNode.select("$.id").getString();
        String configName = cfgNode.select("$.name").getString();
        long version = cfgNode.select("$.version").getLong();
        if (needReGenConfigStr) {
            cfgNode.set("path", (Object)path);
            configStr = cfgNode.toJson();
        }
        LOGGER.debug("add aggregation config, key={} config={}", (Object)resourceKey, (Object)configStr);
        if (StringUtils.hasText((String)configId)) {
            String existResourceKey = aggregateId2ResourceKeyMap.get(configId);
            if (StringUtils.hasText((String)existResourceKey)) {
                aggregateResources.remove(existResourceKey);
                resourceKey2ConfigInfoMap.remove(existResourceKey);
            }
            aggregateId2ResourceKeyMap.put(configId, resourceKey);
        }
        aggregateResources.put(resourceKey, configStr);
        resourceKey2ConfigInfoMap.put(resourceKey, this.buildConfigInfo(configId, configName, method, path, version));
    }

    public synchronized void deleteConfig(String configIds) {
        if (CollectionUtils.isEmpty(aggregateId2ResourceKeyMap)) {
            return;
        }
        JSONArray idArray = JSON.parseArray((String)configIds);
        idArray.forEach(it -> {
            String configId = (String)it;
            String existResourceKey = aggregateId2ResourceKeyMap.get(configId);
            if (StringUtils.hasText((String)existResourceKey)) {
                LOGGER.debug("delete aggregation config: {}", (Object)existResourceKey);
                aggregateResources.remove(existResourceKey);
                resourceKey2ConfigInfoMap.remove(existResourceKey);
                aggregateId2ResourceKeyMap.remove(configId);
            }
        });
    }

    public AggregateResource matchAggregateResource(String method, String path) {
        String key;
        if (aggregateResources == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (aggregateResources.containsKey(key = method.toUpperCase() + ":" + path) && aggregateResources.get(key) != null) {
            String configStr = aggregateResources.get(key);
            Input input = null;
            Pipeline pipeline = null;
            try {
                input = this.createInput(configStr);
                pipeline = this.createPipeline(configStr);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (pipeline != null && input != null) {
                ClientInputConfig cfg = (ClientInputConfig)input.getConfig();
                return new AggregateResource(pipeline, input);
            }
        }
        return null;
    }

    private ConfigInfo buildConfigInfo(String configId, String configName, String method, String path, long version) {
        String serviceName = this.extractServiceName(path);
        ConfigInfo configInfo = new ConfigInfo();
        configInfo.setConfigId(configId);
        configInfo.setConfigName(configName);
        configInfo.setServiceName(serviceName);
        configInfo.setMethod(method);
        configInfo.setPath(path);
        configInfo.setVersion(version == 0L ? null : Long.valueOf(version));
        return configInfo;
    }

    private String extractServiceName(String path) {
        if (path != null) {
            int endIndex;
            if (path.startsWith(TEST_PATH_PREFIX)) {
                int endIndex2 = path.indexOf(47, TEST_PATH_SERVICE_NAME_START_INDEX);
                if (endIndex2 > TEST_PATH_SERVICE_NAME_START_INDEX) {
                    return path.substring(TEST_PATH_SERVICE_NAME_START_INDEX, endIndex2);
                }
            } else if (path.startsWith(this.formalPathPrefix) && (endIndex = path.indexOf(47, this.formalPathServiceNameStartIndex)) > this.formalPathServiceNameStartIndex) {
                return path.substring(this.formalPathServiceNameStartIndex, endIndex);
            }
        }
        return null;
    }

    public static class ConfigInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String configId;
        private String configName;
        private String serviceName;
        private String method;
        private String path;
        private Long version;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigInfo that = (ConfigInfo)o;
            return Objects.equals(this.configId, that.configId) && Objects.equals(this.configName, that.configName) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.configId, this.configName, this.serviceName, this.method, this.path, this.version);
        }

        public String getConfigId() {
            return this.configId;
        }

        public void setConfigId(String configId) {
            this.configId = configId;
        }

        public String getConfigName() {
            return this.configName;
        }

        public void setConfigName(String configName) {
            this.configName = configName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Long getVersion() {
            return this.version;
        }

        public void setVersion(Long version) {
            this.version = version;
        }
    }
}

