/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz;

import com.alibaba.fastjson.JSON;
import com.fizzgate.exception.ExecuteScriptException;
import com.fizzgate.exception.RedirectException;
import com.fizzgate.exception.StopAndResponseException;
import com.fizzgate.fizz.AggregateResult;
import com.fizzgate.fizz.Step;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.StepResponse;
import com.fizzgate.fizz.component.ComponentExecutor;
import com.fizzgate.fizz.component.ComponentResult;
import com.fizzgate.fizz.component.IComponent;
import com.fizzgate.fizz.component.StepContextPosition;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.field.FieldConfig;
import com.fizzgate.fizz.field.ValueTypeEnum;
import com.fizzgate.fizz.input.ClientInputConfig;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.fizz.input.InputConfig;
import com.fizzgate.fizz.input.PathMapping;
import com.fizzgate.fizz.input.ScriptHelper;
import com.fizzgate.schema.util.I18nUtils;
import com.fizzgate.schema.util.PropertiesSupportUtils;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.JsonSchemaUtils;
import com.fizzgate.util.MapUtil;
import com.fizzgate.xml.JsonToXml;
import com.fizzgate.xml.XmlToJson;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.logging.log4j.ThreadContext;
import org.noear.snack.ONode;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Pipeline {
    private static final String CONTENT_TYPE_XML = "application/xml";
    private ConfigurableApplicationContext applicationContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(Pipeline.class);
    private LinkedList<Step> steps = new LinkedList();
    private StepContext<String, Object> stepContext = new StepContext();
    private static final String LANGUAGE_CHINESE = "zh";
    private static final String LANGUAGE_ENGLISH = "en";

    public void addStep(Step step) {
        this.steps.add(step);
    }

    static void displayValue(String n) {
        System.out.println("input : " + n);
    }

    public StepContext<String, Object> getStepContext() {
        return this.stepContext;
    }

    public Mono<AggregateResult> run(Input input, Map<String, Object> clientInput, String traceId) {
        return this.runPipeline(input, clientInput, traceId).onErrorResume(ex -> {
            String message = ex.getMessage();
            if (ex.getMessage() == null) {
                message = "failed to run aggregation pipeline, message: " + ex.toString();
                StackTraceElement[] stacks = ex.getStackTrace();
                if (stacks != null && stacks.length > 0) {
                    message = message + " at " + stacks[0];
                }
            }
            if (ex instanceof StopAndResponseException) {
                throw (StopAndResponseException)ex;
            }
            if (ex instanceof RedirectException) {
                throw (RedirectException)ex;
            }
            if (ex instanceof ExecuteScriptException) {
                throw (ExecuteScriptException)ex;
            }
            if (ex instanceof FizzRuntimeException && ex.getMessage() != null) {
                FizzRuntimeException e = (FizzRuntimeException)ex;
                if (e.getStepContext() == null) {
                    e.setStepContext(this.stepContext);
                }
                throw e;
            }
            throw new FizzRuntimeException(message, (Throwable)ex, this.stepContext);
        });
    }

    public Mono<AggregateResult> runPipeline(Input input, Map<String, Object> clientInput, String traceId) {
        ClientInputConfig config = (ClientInputConfig)input.getConfig();
        this.initialStepContext(clientInput, config);
        this.stepContext.setDebug(config.isDebug());
        this.stepContext.setApplicationContext(this.applicationContext);
        if (traceId != null) {
            this.stepContext.setTraceId(traceId);
        }
        long t1 = System.currentTimeMillis();
        String validateMsg = this.inputValidate(input, (Map)((Map)this.stepContext.get("input")).get("request"));
        this.stepContext.addElapsedTime("\u5165\u53c2\u6821\u9a8c", System.currentTimeMillis() - t1);
        if (StringUtils.hasText((String)validateMsg)) {
            long t2 = System.currentTimeMillis();
            this.stepContext.put("validateMsg", validateMsg);
            Map<String, Object> validateResponse = config.getValidateResponse();
            AggregateResult aggregateResult = this.doInputDataMapping(input, validateResponse);
            this.stepContext.addElapsedTime("\u5165\u53c2\u6821\u9a8c\u7ed3\u679c\u8f6c\u6362", System.currentTimeMillis() - t2);
            return Mono.just((Object)aggregateResult);
        }
        if (CollectionUtils.isEmpty(this.steps)) {
            return this.handleOutput(input);
        }
        LinkedList opSteps = (LinkedList)this.steps.clone();
        Step step1 = (Step)opSteps.removeFirst();
        Mono result = this.runStep(step1, null).expand(lastStepResponse -> {
            if (opSteps.isEmpty() || lastStepResponse.isStop()) {
                return Mono.empty();
            }
            Step step = (Step)opSteps.pop();
            return this.runStep(step, (StepResponse)lastStepResponse);
        }).flatMap(response -> Flux.just((Object)response)).collectList();
        return result.flatMap(clientResponse -> this.handleOutput(input));
    }

    private Mono<StepResponse> runStep(Step step, StepResponse lastStepResponse) {
        StepResponse stepResponse = new StepResponse(step, null, new HashMap<String, Map<String, Object>>());
        this.stepContext.put(step.getName(), stepResponse);
        List<IComponent> components = step.getComponents();
        if (components != null && components.size() > 0) {
            StepContextPosition stepCtxPos = new StepContextPosition(step.getName());
            return ComponentExecutor.exec(components, this.stepContext, stepCtxPos, (ctx, pos) -> {
                step.beforeRun(this.stepContext, null);
                return this.createStep(step);
            }).flatMap(sr -> {
                if (sr instanceof ComponentResult) {
                    return Mono.just((Object)stepResponse);
                }
                return Mono.just((Object)((StepResponse)sr));
            });
        }
        step.beforeRun(this.stepContext, null);
        return this.createStep(step);
    }

    private Mono<AggregateResult> handleOutput(Input input) {
        long t3 = System.currentTimeMillis();
        AggregateResult aggResult = this.doInputDataMapping(input, null);
        this.stepContext.addElapsedTime(input.getName() + "\u805a\u5408\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\u6570\u636e\u8f6c\u6362", System.currentTimeMillis() - t3);
        if (this.stepContext.isDebug().booleanValue() || LOGGER.isDebugEnabled()) {
            ThreadContext.put((String)"traceId", (String)this.stepContext.getTraceId());
            String jsonString = JSON.toJSONString((Object)aggResult);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("aggResult {}", (Object)jsonString);
                LOGGER.debug("stepContext {}", (Object)JSON.toJSONString(this.stepContext));
            } else {
                LOGGER.info("aggResult {}", (Object)jsonString);
                LOGGER.info("stepContext {}", (Object)JSON.toJSONString(this.stepContext));
            }
        }
        return Mono.just((Object)aggResult);
    }

    public Mono<StepResponse> createStep(Step step) {
        long start = System.currentTimeMillis();
        List<Mono> monos = step.run();
        Mono[] monoArray = (Mono[])monos.stream().toArray(Mono[]::new);
        Mono result = Flux.merge((Publisher[])monoArray).reduce(new HashMap(), (item1, item2) -> {
            if (item2.isEmpty()) {
                return item1;
            }
            Input input = (Input)item2.get("request");
            item1.put(input.getName(), item2.get("data"));
            return item1;
        }).flatMap(item -> {
            long t1 = System.currentTimeMillis();
            StepResponse stepResponse = this.doStepDataMapping(step);
            stepResponse.setStop(step.isStop());
            long t2 = System.currentTimeMillis();
            this.stepContext.addElapsedTime(step.getName() + "\u7ed3\u679c\u6570\u636e\u8f6c\u6362", t2 - t1);
            this.stepContext.addElapsedTime(step.getName() + "\u8017\u65f6", System.currentTimeMillis() - start);
            return Mono.just((Object)stepResponse);
        });
        return result;
    }

    public void initialStepContext(Map<String, Object> clientInput, ClientInputConfig config) {
        HashMap input = new HashMap();
        HashMap<String, Object> inputRequest = new HashMap<String, Object>();
        HashMap inputResponse = new HashMap();
        input.put("request", inputRequest);
        input.put("response", inputResponse);
        if (clientInput != null) {
            inputRequest.put("path", clientInput.get("path"));
            inputRequest.put("method", clientInput.get("method"));
            inputRequest.put("headers", clientInput.get("headers"));
            inputRequest.put("params", clientInput.get("params"));
            this.stepContext.addFilePartMap((Map)clientInput.get("filePartMap"));
            if (CONTENT_TYPE_XML.equals(config.getContentType()) || StringUtils.isEmpty((Object)config.getContentType()) && this.isXmlContentType((String)clientInput.get("contentType"))) {
                String[] paths = null;
                if (!StringUtils.isEmpty((Object)config.getXmlArrPaths())) {
                    paths = config.getXmlArrPaths().split(",");
                }
                XmlToJson.Builder builder = new XmlToJson.Builder((String)clientInput.get("body"));
                if (paths != null && paths.length > 0) {
                    for (int j = 0; j < paths.length; ++j) {
                        String p = paths[j];
                        builder = builder.forceList(p);
                    }
                }
                inputRequest.put("body", builder.build().toJson().toMap());
            } else if (clientInput.get("body") instanceof Map) {
                inputRequest.put("body", clientInput.get("body"));
            } else {
                inputRequest.put("body", JSON.parse((String)((String)clientInput.get("body"))));
            }
        }
        this.stepContext.put("input", input);
    }

    private boolean isXmlContentType(String contentType) {
        if (contentType != null) {
            String[] cts = contentType.split(";");
            for (int i = 0; i < cts.length; ++i) {
                if (!CONTENT_TYPE_XML.equals(cts[i])) continue;
                return true;
            }
        }
        return false;
    }

    private StepResponse doStepDataMapping(Step step) {
        Map responseMapping;
        StepResponse stepResponse = (StepResponse)this.stepContext.get(step.getName());
        if (step.getDataMapping() != null && (responseMapping = (Map)step.getDataMapping().get("response")) != null && !StringUtils.isEmpty((Object)responseMapping)) {
            ONode ctxNode = PathMapping.toONode(this.stepContext);
            stepResponse.setResult(PathMapping.transform(ctxNode, this.stepContext, (Map)responseMapping.get("fixedBody"), (Map)responseMapping.get("body")));
            if (responseMapping.get("script") != null) {
                Map scriptCfg = (Map)responseMapping.get("script");
                try {
                    Map stepBody = ScriptHelper.execute(scriptCfg, ctxNode, this.stepContext, Map.class);
                    if (stepBody != null) {
                        stepResponse.setResult(stepBody);
                    }
                }
                catch (ScriptException e) {
                    LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                    throw new ExecuteScriptException(e, this.stepContext, (Object)scriptCfg);
                }
            }
        }
        return stepResponse;
    }

    private AggregateResult doInputDataMapping(Input input, Map<String, Object> validateResponse) {
        Object respBody;
        AggregateResult aggResult = new AggregateResult();
        HashMap<String, Map<String, Integer>> group = (HashMap<String, Map<String, Integer>>)this.stepContext.get("input");
        if (group == null) {
            group = new HashMap<String, Map<String, Integer>>();
            this.stepContext.put("input", group);
        }
        Map<String, Integer> response = null;
        if (group.get("response") == null) {
            response = new HashMap();
            group.put("response", response);
        }
        response = (Map)group.get("response");
        String respContentType = null;
        int statusCode = 200;
        if (input != null && input.getConfig() != null && input.getConfig().getDataMapping() != null) {
            Map<String, Object> responseMapping = (Map<String, Object>)input.getConfig().getDataMapping().get("response");
            if (validateResponse != null) {
                responseMapping = validateResponse;
            }
            if (!CollectionUtils.isEmpty(responseMapping)) {
                Map<String, Object> headers;
                respContentType = (String)responseMapping.get("contentType");
                ONode ctxNode = PathMapping.toONode(this.stepContext);
                if (validateResponse == null) {
                    if (responseMapping.get("httpStatus") != null) {
                        Map fcMap = (Map)responseMapping.get("httpStatus");
                        FieldConfig fc = new FieldConfig(fcMap);
                        if (ValueTypeEnum.FIXED.equals((Object)fc.getType()) && fc.getValue() != null) {
                            statusCode = Integer.valueOf(fc.getValue().toString());
                        } else if ((ValueTypeEnum.REF.equals((Object)fc.getType()) || ValueTypeEnum.FUNC.equals((Object)fc.getType())) && fc.getValue() != null) {
                            Object statusCodeObj;
                            String dataType = null;
                            if (fc.getRefDataType() != null) {
                                dataType = fc.getRefDataType().getCode();
                            }
                            statusCode = (statusCodeObj = PathMapping.getValueByPath(ctxNode, dataType, (String)fc.getValue())) == null ? statusCode : Integer.valueOf(statusCodeObj.toString());
                        }
                    }
                    response.put("httpStatus", statusCode);
                }
                if ((headers = PathMapping.transform(ctxNode, this.stepContext, MapUtil.upperCaseKey((Map)((Map)responseMapping.get("fixedHeaders"))), MapUtil.upperCaseKey((Map)((Map)responseMapping.get("headers"))), false)).containsKey("~") && headers.get("~") instanceof Map) {
                    response.put("headers", (Integer)headers.get("~"));
                } else {
                    response.put("headers", (Integer)((Object)headers));
                }
                Map<String, Object> body = PathMapping.transform(ctxNode, this.stepContext, (Map)responseMapping.get("fixedBody"), (Map)responseMapping.get("body"));
                if (body.containsKey("~")) {
                    response.put("body", (Integer)body.get("~"));
                } else {
                    if (responseMapping.get("script") != null) {
                        Map scriptCfg = (Map)responseMapping.get("script");
                        try {
                            Object respBody2 = ScriptHelper.execute(scriptCfg, ctxNode, this.stepContext);
                            if (respBody2 != null) {
                                body.putAll((Map)respBody2);
                            }
                        }
                        catch (ScriptException e) {
                            LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                            throw new ExecuteScriptException(e, this.stepContext, (Object)scriptCfg);
                        }
                    }
                    response.put("body", (Integer)((Object)body));
                }
            }
        }
        HttpHeaders httpHeaders = MapUtil.toHttpHeaders((Map)((Map)response.get("headers")));
        if (CONTENT_TYPE_XML.equals(respContentType) && !httpHeaders.containsKey((Object)"Content-Type")) {
            httpHeaders.add("Content-Type".toUpperCase(), CONTENT_TYPE_XML);
            response.put("Content-Type".toUpperCase(), (Integer)((Object)CONTENT_TYPE_XML));
        }
        if (CONTENT_TYPE_XML.equals(respContentType)) {
            respBody = response.get("body");
            response.put("jsonBody", (Integer)respBody);
            JsonToXml jsonToXml = new JsonToXml.Builder(JSON.toJSONString(respBody)).build();
            response.put("body", (Integer)((Object)jsonToXml.toString()));
        }
        respBody = response.get("body");
        if (this.stepContext.returnContext() && respBody instanceof Map) {
            Map t = (Map)respBody;
            t.put("_context", this.stepContext);
        }
        aggResult.setHttpStatus(statusCode);
        aggResult.setBody(response.get("body"));
        aggResult.setHeaders((MultiValueMap<String, String>)httpHeaders);
        return aggResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String inputValidate(Input input, Map<String, Object> clientInput) {
        try {
            InputConfig config = input.getConfig();
            if (config instanceof ClientInputConfig) {
                Map<String, Object> langDef = ((ClientInputConfig)config).getLangDef();
                this.handleLangDef(langDef);
                Pair<ValidateType, List<String>> validateTypeAndValidateErrorListPair = this.doInputValidate((ClientInputConfig)config, clientInput);
                if (validateTypeAndValidateErrorListPair == null) {
                    String string = null;
                    return string;
                }
                String string = String.format("%s: %s", ((ValidateType)((Object)validateTypeAndValidateErrorListPair.getFirst())).getTip(), StringUtils.collectionToCommaDelimitedString((Collection)((Collection)validateTypeAndValidateErrorListPair.getSecond())));
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            I18nUtils.removeContextLocale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ValidateType, List<String>> doInputValidate(ClientInputConfig config, Map<String, Object> clientInput) {
        List errorList;
        List errorList2;
        Map<String, Object> paramsDef;
        Map<String, Object> headersDef = config.getHeadersDef();
        if (!CollectionUtils.isEmpty(headersDef)) {
            List errorList3;
            PropertiesSupportUtils.setContextSupportPropertyUpperCase();
            try {
                errorList3 = JsonSchemaUtils.validateAllowValueStr((String)JSON.toJSONString(headersDef), (String)JSON.toJSONString((Object)clientInput.get("headers")));
            }
            finally {
                PropertiesSupportUtils.removeContextSupportPropertyUpperCase();
            }
            if (!CollectionUtils.isEmpty((Collection)errorList3)) {
                return Pair.of((Object)((Object)ValidateType.HEADER), (Object)errorList3);
            }
        }
        if (!CollectionUtils.isEmpty(paramsDef = config.getParamsDef()) && !CollectionUtils.isEmpty((Collection)(errorList2 = JsonSchemaUtils.validateAllowValueStr((String)JSON.toJSONString(paramsDef), (String)JSON.toJSONString((Object)clientInput.get("params")))))) {
            return Pair.of((Object)((Object)ValidateType.QUERY_PARAM), (Object)errorList2);
        }
        Map<String, Object> bodyDef = config.getBodyDef();
        if (!CollectionUtils.isEmpty(bodyDef) && !CollectionUtils.isEmpty((Collection)(errorList = JsonSchemaUtils.validate((String)JSON.toJSONString(bodyDef), (String)JSON.toJSONString((Object)clientInput.get("body")))))) {
            return Pair.of((Object)((Object)ValidateType.BODY), (Object)errorList);
        }
        Map<String, Object> scriptValidate = config.getScriptValidate();
        if (!CollectionUtils.isEmpty(scriptValidate)) {
            ONode ctxNode = PathMapping.toONode(this.stepContext);
            try {
                List errorList4 = ScriptHelper.execute(scriptValidate, ctxNode, this.stepContext, List.class);
                if (!CollectionUtils.isEmpty((Collection)errorList4)) {
                    return Pair.of((Object)((Object)ValidateType.SCRIPT), (Object)errorList4);
                }
            }
            catch (ScriptException e) {
                LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString(scriptValidate), (Object)e);
                throw new ExecuteScriptException(e, this.stepContext, scriptValidate);
            }
        }
        return null;
    }

    private void handleLangDef(Map<String, Object> langDef) {
        if (!CollectionUtils.isEmpty(langDef)) {
            Object langParamObj = langDef.get("langParam");
            String langParam = null;
            if (langParamObj instanceof String) {
                langParam = (String)langParamObj;
            }
            Object langMappingObj = langDef.get("langMapping");
            Map langMapping = null;
            if (langMappingObj instanceof Map) {
                langMapping = (Map)langMappingObj;
            }
            if (langParam != null && !CollectionUtils.isEmpty((Map)langMapping)) {
                ONode ctxNode = PathMapping.toONode(this.stepContext);
                HashMap<String, Object> langParamMap = new HashMap<String, Object>(2);
                langParamMap.put("langParam", langParam);
                Map<String, Object> transformMap = PathMapping.transform(ctxNode, this.stepContext, null, langParamMap);
                Object langParamValue = transformMap.get("langParam");
                if (langParamValue != null) {
                    Object en;
                    Object zh = langMapping.get(LANGUAGE_CHINESE);
                    if (zh != null && zh.toString().equals(langParamValue.toString())) {
                        I18nUtils.setContextLocale((Locale)new Locale(LANGUAGE_CHINESE));
                    }
                    if ((en = langMapping.get(LANGUAGE_ENGLISH)) != null && en.toString().equals(langParamValue.toString())) {
                        I18nUtils.setContextLocale((Locale)new Locale(LANGUAGE_ENGLISH));
                    }
                }
            }
        }
    }

    public void setApplicationContext(ConfigurableApplicationContext appContext) {
        this.applicationContext = appContext;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    static enum ValidateType {
        HEADER("\u8bf7\u6c42\u5934", "Header"),
        QUERY_PARAM("Query\u53c2\u6570", "Query param"),
        BODY("\u8bf7\u6c42\u4f53", "Body"),
        SCRIPT("\u811a\u672c\u6821\u9a8c", "Script");

        String tipZh;
        String tipEn;

        private ValidateType(String tipZh, String tipEn) {
            this.tipZh = tipZh;
            this.tipEn = tipEn;
        }

        public String getTip() {
            String language = I18nUtils.getContextLocale().getLanguage();
            if (Pipeline.LANGUAGE_CHINESE.equals(language)) {
                return this.tipZh;
            }
            if (Pipeline.LANGUAGE_ENGLISH.equals(language)) {
                return this.tipEn;
            }
            return this.tipZh;
        }
    }
}

