/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz;

import com.fizzgate.fizz.Pipeline;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.StepResponse;
import com.fizzgate.fizz.component.ComponentExecutor;
import com.fizzgate.fizz.component.ComponentResult;
import com.fizzgate.fizz.component.IComponent;
import com.fizzgate.fizz.component.StepContextPosition;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.fizz.input.InputConfig;
import com.fizzgate.fizz.input.InputContext;
import com.fizzgate.fizz.input.InputFactory;
import com.fizzgate.fizz.input.InputType;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.publisher.Mono;

public class Step {
    private SoftReference<Pipeline> weakPipeline;
    private String name;
    private boolean stop;
    private Map<String, Object> dataMapping;
    private Map<String, InputConfig> requestConfigs = new HashMap<String, InputConfig>();
    private List<IComponent> components;
    private StepContext<String, Object> stepContext;
    private StepResponse lastStepResponse = null;
    private Map<String, Input> inputs = new HashMap<String, Input>();

    public List<IComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<IComponent> components) {
        this.components = components;
    }

    public SoftReference<Pipeline> getWeakPipeline() {
        return this.weakPipeline;
    }

    public void setWeakPipeline(SoftReference<Pipeline> weakPipeline) {
        this.weakPipeline = weakPipeline;
    }

    public ConfigurableApplicationContext getCurrentApplicationContext() {
        return this.getWeakPipeline() != null ? this.getWeakPipeline().get().getApplicationContext() : null;
    }

    public StepContext<String, Object> getStepContext() {
        return this.stepContext;
    }

    public void beforeRun(StepContext<String, Object> stepContext2, StepResponse response) {
        this.stepContext = stepContext2;
        this.lastStepResponse = response;
        StepResponse stepResponse = (StepResponse)this.stepContext.get(this.name);
        Map<String, InputConfig> configs = this.getRequestConfigs();
        for (String configName : configs.keySet()) {
            InputConfig inputConfig = configs.get(configName);
            InputType type = inputConfig.getType();
            Input input = InputFactory.createInput(type.toString());
            input.setWeakStep(new SoftReference<Step>(this));
            input.setConfig(inputConfig);
            input.setName(configName);
            input.setStepResponse(stepResponse);
            InputContext context = new InputContext(this.stepContext, this.lastStepResponse);
            input.beforeRun(context);
            this.inputs.put(input.getName(), input);
        }
    }

    public List<Mono> run() {
        ArrayList<Mono> monos = new ArrayList<Mono>();
        for (String requestName : this.inputs.keySet()) {
            Input input = this.inputs.get(requestName);
            List<IComponent> components = input.getConfig().getComponents();
            if (components != null && components.size() > 0) {
                StepContextPosition stepCtxPos = new StepContextPosition(this.name, requestName);
                Mono result = ComponentExecutor.exec(components, this.stepContext, stepCtxPos, (ctx, pos) -> {
                    if (input.needRun((StepContext<String, Object>)ctx)) {
                        return input.run();
                    }
                    HashMap<String, Object> inputResult = new HashMap<String, Object>();
                    inputResult.put("data", new HashMap());
                    inputResult.put("request", input);
                    return Mono.just(inputResult);
                }).flatMap(r -> {
                    if (r instanceof ComponentResult) {
                        HashMap<String, Object> inputResult = new HashMap<String, Object>();
                        inputResult.put("data", new HashMap());
                        inputResult.put("request", input);
                        return Mono.just(inputResult);
                    }
                    return Mono.just((Object)r);
                });
                monos.add(result);
                continue;
            }
            if (!input.needRun(this.stepContext)) continue;
            Mono<Map> singleMono = input.run();
            monos.add(singleMono);
        }
        return monos;
    }

    public void afeterRun() {
    }

    public InputConfig addRequestConfig(String name, InputConfig requestConfig) {
        return this.requestConfigs.put(name, requestConfig);
    }

    public Map<String, InputConfig> getRequestConfigs() {
        return this.requestConfigs;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "step" + (int)(Math.random() * 100.0);
            return this.name;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public Map<String, Object> getDataMapping() {
        return this.dataMapping;
    }

    public void setDataMapping(Map<String, Object> dataMapping) {
        this.dataMapping = dataMapping;
    }

    public static class Builder {
        public Step read(Map<String, Object> config, SoftReference<Pipeline> weakPipeline) {
            Step step = new Step();
            step.setWeakPipeline(weakPipeline);
            List requests = (List)config.get("requests");
            if (CollectionUtils.isNotEmpty((Collection)requests)) {
                for (Map requestConfig : requests) {
                    InputConfig inputConfig = InputFactory.createInputConfig(requestConfig);
                    step.addRequestConfig((String)requestConfig.get("name"), inputConfig);
                }
            }
            step.setComponents(ComponentExecutor.buildComponents((List)config.get("components")));
            return step;
        }
    }
}

