/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz;

import com.alibaba.fastjson.JSON;
import com.fizzgate.fizz.StepResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.codec.multipart.FilePart;

public class StepContext<K, V>
extends ConcurrentHashMap<K, V> {
    private ConfigurableApplicationContext applicationContext;
    public static final String ELAPSED_TIMES = "elapsedTimes";
    public static final String DEBUG = "debug";
    public static final String RETURN_CONTEXT = "returnContext";
    public static final String CONTEXT_FIELD = "_context";
    public static final String EXCEPTION_MESSAGE = "exceptionMessage";
    public static final String EXCEPTION_STACKS = "exceptionStacks";
    public static final String EXCEPTION_DATA = "exceptionData";
    private Map<String, FilePart> filePartMap = new HashMap<String, FilePart>();

    public void setDebug(Boolean debug) {
        this.put(DEBUG, debug);
    }

    public String getTraceId() {
        return (String)this.get("traceId");
    }

    public void setTraceId(String traceId) {
        this.put("traceId", traceId);
    }

    public Boolean isDebug() {
        return this.get(DEBUG) == null ? false : (Boolean)this.get(DEBUG);
    }

    public boolean returnContext() {
        return Boolean.valueOf((String)this.getInputReqHeader(RETURN_CONTEXT));
    }

    public void addFilePart(String key, FilePart filePart) {
        this.filePartMap.put(key, filePart);
    }

    public void addFilePartMap(Map<String, FilePart> filePartMap) {
        if (filePartMap != null && !filePartMap.isEmpty()) {
            this.filePartMap.putAll(filePartMap);
        }
    }

    public FilePart getFilePart(String key) {
        return this.filePartMap.get(key);
    }

    public Map<String, FilePart> getFilePartMap() {
        return this.filePartMap;
    }

    public void setExceptionInfo(Throwable cause, Object exceptionData) {
        this.put(EXCEPTION_MESSAGE, cause.getMessage());
        this.put(EXCEPTION_DATA, exceptionData);
        StackTraceElement[] stacks = cause.getStackTrace();
        if (stacks != null && stacks.length > 0) {
            String[] arr = new String[stacks.length];
            for (int i = 0; i < stacks.length; ++i) {
                StackTraceElement ste = stacks[i];
                StringBuffer sb = new StringBuffer();
                sb.append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")");
                arr[i] = sb.toString();
            }
            this.put(EXCEPTION_STACKS, arr);
        }
    }

    public synchronized void addElapsedTime(String actionName, Long milliSeconds) {
        ArrayList elapsedTimes = (ArrayList)this.get(ELAPSED_TIMES);
        if (elapsedTimes == null) {
            elapsedTimes = new ArrayList();
            this.put(ELAPSED_TIMES, elapsedTimes);
        }
        HashMap<String, Long> record = new HashMap<String, Long>();
        record.put(actionName, milliSeconds);
        elapsedTimes.add(record);
    }

    public V getElapsedTimes() {
        return this.get(ELAPSED_TIMES);
    }

    private Map<String, Object> getStepRequest(String stepName, String requestName) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return null;
        }
        Map<String, Map<String, Object>> requests = stepResponse.getRequests();
        if (requests == null) {
            requests = new HashMap<String, Map<String, Object>>();
            stepResponse.setRequests(requests);
            requests.put(requestName, new HashMap());
        } else if (!requests.containsKey(requestName)) {
            requests.put(requestName, new HashMap());
        }
        return requests.get(requestName);
    }

    public void setStepReqHeader(String stepName, String requestName, String headerName, Object headerValue) {
        HashMap<String, Object> headers;
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return;
        }
        HashMap req = (HashMap)request.get("request");
        if (req == null) {
            req = new HashMap();
            request.put("request", req);
        }
        if ((headers = (HashMap<String, Object>)req.get("headers")) == null) {
            headers = new HashMap<String, Object>();
            req.put("headers", headers);
        }
        if (headerName == null || "".equals(headerName)) {
            return;
        }
        headers.put(headerName.toUpperCase(), headerValue);
    }

    public Object getStepReqHeader(String stepName, String requestName, String headerName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        Map req = (Map)request.get("request");
        if (req == null) {
            return null;
        }
        Map headers = (Map)req.get("headers");
        if (headers == null) {
            return null;
        }
        if (headerName == null || "".equals(headerName)) {
            return null;
        }
        return headers.get(headerName.toUpperCase());
    }

    public void setStepReqBody(String stepName, String requestName, String key, Object value) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return;
        }
        HashMap<String, HashMap<String, Object>> req = (HashMap<String, HashMap<String, Object>>)request.get("request");
        if (req == null) {
            req = new HashMap<String, HashMap<String, Object>>();
            request.put("request", req);
        }
        if (req.get("body") != null && !(req.get("body") instanceof Map)) {
            return;
        }
        HashMap<String, Object> body = (HashMap<String, Object>)req.get("body");
        if (body == null) {
            body = new HashMap<String, Object>();
            req.put("body", body);
        }
        body.put(key, value);
    }

    public Object getStepReqBody(String stepName, String requestName, String fieldName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        HashMap req = (HashMap)request.get("request");
        if (req == null) {
            req = new HashMap();
            request.put("request", req);
        }
        if (req.get("body") != null && !(req.get("body") instanceof Map)) {
            return null;
        }
        Map body = (Map)req.get("body");
        if (body == null) {
            return null;
        }
        return body.get(fieldName);
    }

    public Object getStepReqBody(String stepName, String requestName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        HashMap req = (HashMap)request.get("request");
        if (req == null) {
            req = new HashMap();
            request.put("request", req);
        }
        return req.get("body");
    }

    public Object getStepReqParam(String stepName, String requestName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        HashMap req = (HashMap)request.get("request");
        if (req == null) {
            req = new HashMap();
            request.put("request", req);
        }
        return req.get("params");
    }

    public Object getStepReqParam(String stepName, String requestName, String paramName) {
        Map params = (Map)this.getStepReqParam(stepName, requestName);
        return params == null ? null : params.get(paramName);
    }

    public void setStepRespHeader(String stepName, String requestName, String headerName, Object headerValue) {
        HashMap<String, Object> headers;
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return;
        }
        HashMap response = (HashMap)request.get("response");
        if (response == null) {
            response = new HashMap();
            request.put("response", response);
        }
        if ((headers = (HashMap<String, Object>)response.get("headers")) == null) {
            headers = new HashMap<String, Object>();
            response.put("headers", headers);
        }
        if (headerName == null || "".equals(headerName)) {
            return;
        }
        headers.put(headerName.toUpperCase(), headerValue);
    }

    public Object getStepRespHeader(String stepName, String requestName, String headerName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        Map response = (Map)request.get("response");
        if (response == null) {
            return null;
        }
        Map headers = (Map)response.get("headers");
        if (headers == null) {
            return null;
        }
        if (headerName == null || "".equals(headerName)) {
            return null;
        }
        return headers.get(headerName.toUpperCase());
    }

    public void setStepRespBody(String stepName, String requestName, String key, Object value) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return;
        }
        HashMap<String, HashMap<String, Object>> response = (HashMap<String, HashMap<String, Object>>)request.get("response");
        if (response == null) {
            response = new HashMap<String, HashMap<String, Object>>();
            request.put("response", response);
        }
        if (response.get("body") != null && !(response.get("body") instanceof Map)) {
            return;
        }
        HashMap<String, Object> body = (HashMap<String, Object>)response.get("body");
        if (body == null) {
            body = new HashMap<String, Object>();
            response.put("body", body);
        }
        body.put(key, value);
    }

    public Object getStepRespBody(String stepName, String requestName, String key) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        Map response = (Map)request.get("response");
        if (response == null) {
            return null;
        }
        if (response.get("body") != null && !(response.get("body") instanceof Map)) {
            return null;
        }
        Map body = (Map)response.get("body");
        if (body == null) {
            return null;
        }
        return body.get(key);
    }

    public Object getStepRespBody(String stepName, String requestName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        Map response = (Map)request.get("response");
        if (response == null) {
            return null;
        }
        return response.get("body");
    }

    public void setStepResult(String stepName, String key, Object value) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return;
        }
        HashMap<String, Object> result = stepResponse.getResult();
        if (result == null) {
            result = new HashMap<String, Object>();
            stepResponse.setResult(result);
        }
        result.put(key, value);
    }

    public Object getStepResult(String stepName, String key) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return null;
        }
        Map result = stepResponse.getResult();
        if (result == null) {
            return null;
        }
        return result.get(key);
    }

    public Object getStepResult(String stepName) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return null;
        }
        return stepResponse.getResult();
    }

    public void setInputRespHeader(String headerName, Object headerValue) {
        Map input = (Map)this.get("input");
        if (input == null) {
            return;
        }
        Map response = (Map)input.get("response");
        if (response == null) {
            return;
        }
        HashMap<String, Object> headers = (HashMap<String, Object>)response.get("headers");
        if (headers == null) {
            headers = new HashMap<String, Object>();
            response.put("headers", headers);
        }
        headers.put(headerName, headerValue);
    }

    public Object getInputRespHeader(String headerName) {
        Map input = (Map)this.get("input");
        if (input == null) {
            return null;
        }
        Map response = (Map)input.get("response");
        if (response == null) {
            return null;
        }
        Map headers = (Map)response.get("headers");
        if (headers == null) {
            return null;
        }
        return headers.get(headerName);
    }

    public Object getInputReqHeader(String headerName) {
        if (headerName == null || "".equals(headerName)) {
            return null;
        }
        Map input = (Map)this.get("input");
        if (input == null) {
            return null;
        }
        Map request = (Map)input.get("request");
        if (request == null) {
            return null;
        }
        Map headers = (Map)request.get("headers");
        if (headers == null) {
            return null;
        }
        return headers.get(headerName.toUpperCase());
    }

    public void setInputRespBody(String fieldName, Object value) {
        Map input = (Map)this.get("input");
        if (input == null) {
            return;
        }
        HashMap<String, HashMap<String, Object>> response = (HashMap<String, HashMap<String, Object>>)input.get("response");
        if (response == null) {
            response = new HashMap<String, HashMap<String, Object>>();
            input.put("response", response);
        }
        if (response.get("body") != null && !(response.get("body") instanceof Map)) {
            return;
        }
        HashMap<String, Object> body = (HashMap<String, Object>)response.get("body");
        if (body == null) {
            body = new HashMap<String, Object>();
            response.put("body", body);
        }
        body.put(fieldName, value);
    }

    public Object getInputRespBody(String fieldName) {
        Map input = (Map)this.get("input");
        if (input == null) {
            return null;
        }
        Map response = (Map)input.get("response");
        if (response == null) {
            return null;
        }
        if (response.get("body") != null && !(response.get("body") instanceof Map)) {
            return null;
        }
        Map body = (Map)response.get("body");
        if (body == null) {
            return null;
        }
        return body.get(fieldName);
    }

    public Object getInputRespBody() {
        Map input = (Map)this.get("input");
        if (input == null) {
            return null;
        }
        Map response = (Map)input.get("response");
        if (response == null) {
            return null;
        }
        return response.get("body");
    }

    public Object getInputReqBody(String fieldName) {
        Object respBody = this.getInputReqAttr("body");
        if (respBody != null && !(respBody instanceof Map)) {
            return null;
        }
        Map body = (Map)respBody;
        if (body == null) {
            return null;
        }
        return body.get(fieldName);
    }

    public Object getInputReqBody() {
        return this.getInputReqAttr("body");
    }

    public Object getInputReqParam() {
        return this.getInputReqAttr("params");
    }

    public Object getInputReqParam(String paramName) {
        Map params = (Map)this.getInputReqAttr("params");
        return params == null ? null : (paramName == null ? params : params.get(paramName));
    }

    public Object getInputReqAttr(String key) {
        Map input = (Map)this.get("input");
        if (input == null) {
            return null;
        }
        Map request = (Map)input.get("request");
        if (request == null) {
            return null;
        }
        return request.get(key);
    }

    public void setStepCircleItem(String stepName, Object item, Integer index) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return;
        }
        stepResponse.setItem(item);
        stepResponse.setIndex(index);
    }

    public void addStepCircleResult(String stepName) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return;
        }
        List<Map<String, Object>> circle = stepResponse.getCircle();
        if (circle == null) {
            circle = new ArrayList<Map<String, Object>>();
            stepResponse.setCircle(circle);
        }
        HashMap<String, Object> circleResult = new HashMap<String, Object>();
        circleResult.put("requests", this.deepCopy(stepResponse.getRequests()));
        circleResult.put("result", this.deepCopy(stepResponse.getResult()));
        circleResult.put("item", this.deepCopy(stepResponse.getItem()));
        circleResult.put("index", stepResponse.getIndex());
        circle.add(circleResult);
    }

    public Object getStepItem(String stepName) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return null;
        }
        return stepResponse.getItem();
    }

    public List<Map<String, Object>> getStepCircle(String stepName) {
        StepResponse stepResponse = (StepResponse)this.get(stepName);
        if (stepResponse == null) {
            return null;
        }
        return stepResponse.getCircle();
    }

    public void setRequestCircleItem(String stepName, String requestName, Object item, Integer index) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return;
        }
        request.put("item", item);
        request.put("index", index);
    }

    public void addRequestCircleResult(String stepName, String requestName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return;
        }
        ArrayList circle = (ArrayList)request.get("circle");
        if (circle == null) {
            circle = new ArrayList();
            request.put("circle", circle);
        }
        HashMap<String, Object> circleResult = new HashMap<String, Object>();
        circleResult.put("request", this.deepCopy(request.get("request")));
        circleResult.put("response", this.deepCopy(request.get("response")));
        circleResult.put("item", this.deepCopy(request.get("item")));
        circleResult.put("index", request.get("index"));
        circle.add(circleResult);
    }

    public void addConditionResult(String stepName, String requestName, String conditionDesc, boolean rs) {
        if (requestName == null) {
            StepResponse stepResponse = (StepResponse)this.get(stepName);
            if (stepResponse == null) {
                return;
            }
            List<Map<String, Object>> results = stepResponse.getConditionResults();
            if (results == null) {
                results = new ArrayList<Map<String, Object>>();
                stepResponse.setConditionResults(results);
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put(conditionDesc, rs);
            results.add(result);
        } else {
            Map<String, Object> request = this.getStepRequest(stepName, requestName);
            if (request == null) {
                return;
            }
            ArrayList results = (ArrayList)request.get("conditionResults");
            if (results == null) {
                results = new ArrayList();
                request.put("conditionResults", results);
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            result.put(conditionDesc, rs);
            results.add(result);
        }
    }

    public Object getRequestCircleItem(String stepName, String requestName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        return request.get("item");
    }

    public List<Map<String, Object>> getRequestCircle(String stepName, String requestName) {
        Map<String, Object> request = this.getStepRequest(stepName, requestName);
        if (request == null) {
            return null;
        }
        return (List)request.get("circle");
    }

    private Object deepCopy(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (obj.getClass().isPrimitive()) {
            return obj;
        }
        return JSON.parse((String)JSON.toJSONString((Object)obj));
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

