/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.component;

import com.alibaba.fastjson.JSON;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.component.ComponentResult;
import com.fizzgate.fizz.component.ComponentTypeEnum;
import com.fizzgate.fizz.component.IComponent;
import com.fizzgate.fizz.component.StepContextPosition;
import com.fizzgate.fizz.component.circle.Circle;
import com.fizzgate.fizz.component.condition.Condition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.noear.snack.ONode;
import reactor.core.publisher.Mono;

public class ComponentExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ONode toONode(StepContext<String, Object> stepContext) {
        ONode o = null;
        StepContext<String, Object> stepContext2 = stepContext;
        synchronized (stepContext2) {
            o = ONode.loadObj(stepContext);
        }
        return o;
    }

    public static List<IComponent> buildComponents(List<Map<String, Object>> componentConfig) {
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        if (componentConfig != null && componentConfig.size() > 0) {
            for (Map<String, Object> m : componentConfig) {
                IComponent c;
                if (ComponentTypeEnum.CONDITION.getCode().equals(m.get("type"))) {
                    c = (Condition)JSON.parseObject((String)JSON.toJSONString(m), Condition.class);
                    components.add(c);
                }
                if (!ComponentTypeEnum.CIRCLE.getCode().equals(m.get("type"))) continue;
                c = (Circle)JSON.parseObject((String)JSON.toJSONString(m), Circle.class);
                components.add(c);
            }
        }
        return components;
    }

    public static Mono<Object> exec(List<IComponent> components, StepContext<String, Object> stepContext, StepContextPosition stepCtxPos, BiFunction<StepContext, StepContextPosition, Mono> f) {
        if (components != null && components.size() > 0) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            Circle circle = null;
            for (IComponent component : components) {
                if (ComponentTypeEnum.CIRCLE == component.getType()) {
                    circle = (Circle)component;
                }
                if (circle != null || ComponentTypeEnum.CONDITION != component.getType()) continue;
                conditions.add((Condition)component);
            }
            if (conditions != null && conditions.size() > 0) {
                ONode ctxNode = ComponentExecutor.toONode(stepContext);
                for (Condition c : conditions) {
                    boolean rs = c.exec(ctxNode);
                    stepContext.addConditionResult(stepCtxPos.getStepName(), stepCtxPos.getRequestName(), c.getDesc(), rs);
                    if (rs) continue;
                    return Mono.just((Object)new ComponentResult());
                }
            }
            if (circle != null) {
                return circle.exec(stepContext, stepCtxPos, f);
            }
            return f.apply(stepContext, stepCtxPos);
        }
        return Mono.just((Object)new ComponentResult());
    }
}

