/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.component.circle;

import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.component.ComponentExecutor;
import com.fizzgate.fizz.component.ComponentResult;
import com.fizzgate.fizz.component.ComponentTypeEnum;
import com.fizzgate.fizz.component.IComponent;
import com.fizzgate.fizz.component.StepContextPosition;
import com.fizzgate.fizz.component.circle.CircleItem;
import com.fizzgate.fizz.component.condition.Condition;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.field.ValueTypeEnum;
import com.fizzgate.fizz.input.PathMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.noear.snack.ONode;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Circle
implements IComponent {
    private static final String type = ComponentTypeEnum.CIRCLE.getCode();
    private String desc;
    private ValueTypeEnum dataSourceType;
    private Object dataSource;
    private List<Condition> execConditions;
    private List<Condition> breakConditions;
    private Object currentItem;
    private Integer index;
    private Integer fixedValue;
    private Object refValue;
    private boolean refReadFlag;

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.getEnumByCode(type);
    }

    public Circle(String desc, ValueTypeEnum dataSourceType, Object dataSource, List<Condition> execConditions, List<Condition> breakConditions) {
        this.desc = desc;
        this.dataSourceType = dataSourceType;
        this.dataSource = dataSource;
        this.execConditions = execConditions;
        this.breakConditions = breakConditions;
    }

    private Integer getFixedValue(ONode ctxNode) {
        if (this.fixedValue != null) {
            return this.fixedValue;
        }
        if (this.dataSource == null) {
            return this.fixedValue;
        }
        if (this.dataSource instanceof Integer || this.dataSource instanceof Long || this.dataSource instanceof String) {
            try {
                this.fixedValue = Integer.valueOf(this.dataSource.toString());
            }
            catch (Exception e) {
                throw new FizzRuntimeException("invalid data source, fixed data source must be a positive integer");
            }
            if (this.fixedValue < 1) {
                throw new FizzRuntimeException("invalid data source, fixed data source must be a positive integer");
            }
            return this.fixedValue;
        }
        throw new FizzRuntimeException("invalid data source, fixed data source must be a positive integer");
    }

    private Object getRefValue(ONode ctxNode) {
        if (this.refReadFlag) {
            return this.refValue;
        }
        Object value = PathMapping.getValueByPath(ctxNode, (String)this.dataSource);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            this.refValue = (List)value;
            return this.refValue;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof String) {
            try {
                Integer times = Integer.valueOf(value.toString());
                if (times < 1) {
                    throw new FizzRuntimeException("invalid data source, data source must be a positive integer or an array");
                }
                this.refValue = times;
            }
            catch (FizzRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FizzRuntimeException("invalid data source, data source must be a positive integer or an array");
            }
            return this.refValue;
        }
        throw new FizzRuntimeException("invalid data source, referenced data source must be a positive integer or an array");
    }

    public CircleItem next(ONode ctxNode) {
        if (ValueTypeEnum.FIXED.equals((Object)this.dataSourceType)) {
            Integer total = this.getFixedValue(ctxNode);
            if (this.index == null) {
                this.index = 0;
                this.currentItem = this.index + 1;
                return new CircleItem(this.currentItem, this.index);
            }
            if (this.index < total - 1) {
                this.index = this.index + 1;
                this.currentItem = this.index + 1;
                return new CircleItem(this.currentItem, this.index);
            }
            return null;
        }
        if (ValueTypeEnum.REF.equals((Object)this.dataSourceType)) {
            Object refValue = this.getRefValue(ctxNode);
            if (refValue instanceof Collection) {
                List list = (List)refValue;
                if (this.index == null) {
                    this.index = 0;
                    this.currentItem = list.get(this.index);
                    return new CircleItem(this.currentItem, this.index);
                }
                if (this.index < list.size() - 1) {
                    this.index = this.index + 1;
                    this.currentItem = list.get(this.index);
                    return new CircleItem(this.currentItem, this.index);
                }
                return null;
            }
            if (refValue instanceof Integer) {
                Integer total = (Integer)refValue;
                if (this.index == null) {
                    this.index = 0;
                    this.currentItem = this.index + 1;
                    return new CircleItem(this.currentItem, this.index);
                }
                if (this.index < total - 1) {
                    this.index = this.index + 1;
                    this.currentItem = this.index + 1;
                    return new CircleItem(this.currentItem, this.index);
                }
                return null;
            }
        }
        return null;
    }

    public boolean canExec(int index, ONode ctxNode, StepContext<String, Object> stepContext, StepContextPosition stepCtxPos) {
        if (this.execConditions != null && this.execConditions.size() > 0) {
            try {
                for (Condition c : this.execConditions) {
                    boolean rs = c.exec(ctxNode);
                    stepContext.addConditionResult(stepCtxPos.getStepName(), stepCtxPos.getRequestName(), "circle[" + index + "]-execCondition:" + c.getDesc(), rs);
                    if (rs) continue;
                    return false;
                }
            }
            catch (FizzRuntimeException e) {
                throw new FizzRuntimeException(type + " " + e.getMessage(), e.getCause());
            }
        }
        return true;
    }

    public boolean breakCircle(int index, ONode ctxNode, StepContext<String, Object> stepContext, StepContextPosition stepCtxPos) {
        if (this.breakConditions != null && this.breakConditions.size() > 0) {
            try {
                for (Condition c : this.breakConditions) {
                    boolean rs = c.exec(ctxNode);
                    stepContext.addConditionResult(stepCtxPos.getStepName(), stepCtxPos.getRequestName(), "circle[" + index + "]-breakCondition:" + c.getDesc(), rs);
                    if (!rs) continue;
                    return true;
                }
            }
            catch (FizzRuntimeException e) {
                throw new FizzRuntimeException(type + " " + e.getMessage(), e.getCause());
            }
        }
        return false;
    }

    public Mono<Object> exec(StepContext<String, Object> stepContext, StepContextPosition stepCtxPos, BiFunction<StepContext, StepContextPosition, Mono> f) {
        ONode ctxNode1 = ComponentExecutor.toONode(stepContext);
        CircleItem nextItem = this.next(ctxNode1);
        if (nextItem != null) {
            return Mono.just((Object)new CircleItemResult(ctxNode1, nextItem, null)).expand(circleItemResult -> {
                CircleItem cItem = ((CircleItemResult)circleItemResult).nextItem;
                if (stepCtxPos.getRequestName() != null) {
                    stepContext.setRequestCircleItem(stepCtxPos.getStepName(), stepCtxPos.getRequestName(), cItem.getItem(), cItem.getIndex());
                } else {
                    stepContext.setStepCircleItem(stepCtxPos.getStepName(), cItem.getItem(), cItem.getIndex());
                }
                ONode ctxNode = ((CircleItemResult)circleItemResult).ctxNode;
                PathMapping.setByPath(ctxNode, stepCtxPos.getPath() + ".item", cItem.getItem(), true);
                PathMapping.setByPath(ctxNode, stepCtxPos.getPath() + ".index", cItem.getIndex(), true);
                if (!this.canExec(cItem.getIndex(), ctxNode, stepContext, stepCtxPos)) {
                    CircleItem nextItem2 = this.next(ctxNode);
                    if (nextItem2 == null) {
                        return Mono.empty();
                    }
                    return Mono.just((Object)new CircleItemResult(ctxNode, nextItem2, null));
                }
                return ((Mono)f.apply(stepContext, stepCtxPos)).flatMap(r -> {
                    if (stepCtxPos.getRequestName() != null) {
                        stepContext.addRequestCircleResult(stepCtxPos.getStepName(), stepCtxPos.getRequestName());
                    } else {
                        stepContext.addStepCircleResult(stepCtxPos.getStepName());
                    }
                    ONode ctxNode2 = ComponentExecutor.toONode(stepContext);
                    if (this.breakCircle(cItem.getIndex(), ctxNode2, stepContext, stepCtxPos)) {
                        return Mono.empty();
                    }
                    CircleItem nextItem2 = this.next(ctxNode2);
                    if (nextItem2 == null) {
                        return Mono.empty();
                    }
                    return Mono.just((Object)new CircleItemResult(ctxNode2, nextItem2, r));
                });
            }).flatMap(circleItemResult -> Flux.just((Object)circleItemResult)).collectList().flatMap(r -> {
                List list = (List)r;
                if (list != null && list.size() > 0) {
                    Collections.reverse(list);
                    for (int i = 0; i < list.size(); ++i) {
                        if (((CircleItemResult)list.get(i)).result == null) continue;
                        return Mono.just((Object)((CircleItemResult)list.get(i)).result);
                    }
                }
                return Mono.just((Object)new ComponentResult());
            });
        }
        return Mono.just((Object)new ComponentResult());
    }

    class CircleItemResult {
        private ONode ctxNode;
        private CircleItem nextItem;
        private Object result;

        public CircleItemResult(ONode ctxNode, CircleItem nextItem, Object result) {
            this.ctxNode = ctxNode;
            this.nextItem = nextItem;
            this.result = result;
        }

        public ONode getCtxNode() {
            return this.ctxNode;
        }

        public CircleItem getNextItem() {
            return this.nextItem;
        }

        public Object getResult() {
            return this.result;
        }

        public void setCtxNode(ONode ctxNode) {
            this.ctxNode = ctxNode;
        }

        public void setNextItem(CircleItem nextItem) {
            this.nextItem = nextItem;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CircleItemResult)) {
                return false;
            }
            CircleItemResult other = (CircleItemResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ONode this$ctxNode = this.getCtxNode();
            ONode other$ctxNode = other.getCtxNode();
            if (this$ctxNode == null ? other$ctxNode != null : !this$ctxNode.equals(other$ctxNode)) {
                return false;
            }
            CircleItem this$nextItem = this.getNextItem();
            CircleItem other$nextItem = other.getNextItem();
            if (this$nextItem == null ? other$nextItem != null : !((Object)this$nextItem).equals(other$nextItem)) {
                return false;
            }
            Object this$result = this.getResult();
            Object other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CircleItemResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ONode $ctxNode = this.getCtxNode();
            result = result * 59 + ($ctxNode == null ? 43 : $ctxNode.hashCode());
            CircleItem $nextItem = this.getNextItem();
            result = result * 59 + ($nextItem == null ? 43 : ((Object)$nextItem).hashCode());
            Object $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "Circle.CircleItemResult(ctxNode=" + this.getCtxNode() + ", nextItem=" + this.getNextItem() + ", result=" + this.getResult() + ")";
        }
    }
}

