/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.component.condition;

import com.alibaba.fastjson.JSON;
import com.fizzgate.fizz.component.ComponentTypeEnum;
import com.fizzgate.fizz.component.IComponent;
import com.fizzgate.fizz.component.OperatorEnum;
import com.fizzgate.fizz.component.condition.ConditionValue;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.field.RefDataTypeEnum;
import com.fizzgate.fizz.field.ValueTypeEnum;
import com.fizzgate.fizz.input.PathMapping;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class Condition
implements IComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Condition.class);
    private static final String type = ComponentTypeEnum.CONDITION.getCode();
    private String desc;
    private ConditionValue value1;
    private OperatorEnum operator;
    private ConditionValue value2;

    public Condition(String desc, ConditionValue value1, OperatorEnum operator, ConditionValue value2) {
        this.desc = desc;
        this.value1 = value1;
        this.operator = operator;
        this.value2 = value2;
    }

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.getEnumByCode(type);
    }

    public boolean exec(ONode ctxNode) {
        if (this.value1 == null || this.operator == null) {
            return false;
        }
        boolean rs = false;
        try {
            Object v1 = null;
            if (ValueTypeEnum.FIXED.equals((Object)this.value1.getType())) {
                v1 = this.value1.getValue();
            } else {
                v1 = PathMapping.getValueByPath(ctxNode, (String)this.value1.getValue());
                v1 = this.cast(this.value1.getRefDataType(), v1);
            }
            Object v2 = null;
            if (this.value2 != null && this.value2.getType() != null) {
                if (ValueTypeEnum.FIXED.equals((Object)this.value2.getType())) {
                    v2 = this.value2.getValue();
                } else {
                    v2 = PathMapping.getValueByPath(ctxNode, (String)this.value2.getValue());
                    v2 = this.cast(this.value2.getRefDataType(), v2);
                }
            }
            switch (this.operator) {
                case EQ: {
                    if (v1 == null && v2 == null) {
                        rs = true;
                        break;
                    }
                    if (v1 == null || v2 == null) break;
                    rs = this.compare(v1, v2) == 0;
                    break;
                }
                case NE: {
                    if (v1 == null && v2 == null) {
                        rs = false;
                        break;
                    }
                    if (v1 == null && v2 != null || v1 != null && v2 == null) {
                        rs = true;
                        break;
                    }
                    if (v1 == null || v2 == null) break;
                    rs = this.compare(v1, v2) != 0;
                    break;
                }
                case GT: {
                    rs = this.compare(v1, v2) > 0;
                    break;
                }
                case GE: {
                    rs = this.compare(v1, v2) >= 0;
                    break;
                }
                case LT: {
                    rs = this.compare(v1, v2) < 0;
                    break;
                }
                case LE: {
                    rs = this.compare(v1, v2) <= 0;
                    break;
                }
                case CONTAINS: {
                    if (v1 == null) {
                        rs = false;
                        break;
                    }
                    if (v1 instanceof Collection && !(v2 instanceof Collection)) {
                        Collection coll1 = (Collection)v1;
                        if (v2 instanceof Integer || v2 instanceof Long) {
                            Long el = Long.valueOf(v2.toString());
                            rs = this.containsLong(coll1, el);
                            break;
                        }
                        if (v2 instanceof Float || v2 instanceof Double) {
                            Double el = Double.valueOf(v2.toString());
                            rs = this.containsDouble(coll1, el);
                            break;
                        }
                        rs = CollectionUtils.contains(coll1.iterator(), (Object)v2);
                        break;
                    }
                    if (!(v1 instanceof Collection)) {
                        throw new FizzRuntimeException("value1 must be a collection");
                    }
                    if (!(v2 instanceof Collection)) break;
                    throw new FizzRuntimeException("value2 can not be a collection");
                }
                case NOTCONTAIN: {
                    if (v1 == null) {
                        rs = true;
                        break;
                    }
                    if (v1 instanceof Collection && !(v2 instanceof Collection)) {
                        Collection coll1 = (Collection)v1;
                        if (v2 instanceof Integer || v2 instanceof Long) {
                            Long el = Long.valueOf(v2.toString());
                            rs = !this.containsLong(coll1, el);
                            break;
                        }
                        if (v2 instanceof Float || v2 instanceof Double) {
                            Double el = Double.valueOf(v2.toString());
                            rs = !this.containsDouble(coll1, el);
                            break;
                        }
                        rs = !CollectionUtils.contains(coll1.iterator(), (Object)v2);
                        break;
                    }
                    if (!(v1 instanceof Collection)) {
                        throw new FizzRuntimeException("value1 must be a collection");
                    }
                    if (!(v2 instanceof Collection)) break;
                    throw new FizzRuntimeException("value2 can not be a collection");
                }
                case CONTAINSANY: {
                    if (v1 == null || v2 == null) {
                        rs = false;
                        break;
                    }
                    if (v1 instanceof Collection && v2 instanceof Collection) {
                        Collection coll1 = (Collection)v1;
                        Collection coll2 = (Collection)v2;
                        rs = CollectionUtils.containsAny((Collection)coll1, (Collection)coll2);
                        break;
                    }
                    if (!(v1 instanceof Collection)) {
                        throw new FizzRuntimeException("value1 must be a collection");
                    }
                    if (v2 instanceof Collection) break;
                    throw new FizzRuntimeException("value2 must be a collection");
                }
                case ISNULL: {
                    rs = v1 == null;
                    break;
                }
                case ISNOTNULL: {
                    rs = v1 != null;
                    break;
                }
                case ISBLANK: {
                    rs = v1 == null || StringUtils.isBlank((CharSequence)v1.toString());
                    break;
                }
                case ISNOTBLANK: {
                    rs = v1 != null && StringUtils.isNotBlank((CharSequence)v1.toString());
                    break;
                }
                case ISEMPTY: {
                    rs = v1 == null || v1 instanceof Collection && ((Collection)v1).isEmpty() || v1 instanceof Map && ((Map)v1).isEmpty();
                    break;
                }
                case ISNOTEMPTY: {
                    if (v1 == null) break;
                    if (v1 instanceof Collection) {
                        rs = !((Collection)v1).isEmpty();
                        break;
                    }
                    if (!(v1 instanceof Map)) break;
                    rs = !((Map)v1).isEmpty();
                    break;
                }
            }
        }
        catch (FizzRuntimeException e) {
            String message = type + ": " + e.getMessage() + ", data=" + JSON.toJSONString((Object)this);
            LOGGER.error(message, (Throwable)e);
            throw new FizzRuntimeException(message, e.getCause());
        }
        return rs;
    }

    private int compare(Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            throw new FizzRuntimeException("value1 and value2 can not be null");
        }
        if (v1 instanceof Boolean && v2 instanceof Boolean) {
            Boolean n1 = (Boolean)v1;
            Boolean n2 = (Boolean)v2;
            return n1.compareTo(n2);
        }
        if ((v1 instanceof Integer || v1 instanceof Long || v1 instanceof Float || v1 instanceof Double) && (v2 instanceof Integer || v2 instanceof Long || v2 instanceof Float || v2 instanceof Double)) {
            Double n1 = Double.valueOf(v1.toString());
            Double n2 = Double.valueOf(v2.toString());
            return n1.compareTo(n2);
        }
        if (v1 instanceof String && v2 instanceof String) {
            String s1 = v1.toString();
            String s2 = v2.toString();
            return s1.compareTo(s2);
        }
        throw new FizzRuntimeException("types of value1 and value2 are not consistent or not supported for comparision");
    }

    private Object cast(RefDataTypeEnum type, Object val) {
        if (type != null && val != null) {
            switch (type) {
                case INT: {
                    val = Integer.valueOf(val.toString());
                    break;
                }
                case LONG: {
                    val = Long.valueOf(val.toString());
                    break;
                }
                case FLOAT: {
                    val = Float.valueOf(val.toString());
                    break;
                }
                case DOUBLE: {
                    val = Double.valueOf(val.toString());
                    break;
                }
                case BOOLEAN: {
                    val = Boolean.valueOf(val.toString());
                    break;
                }
                case STRING: {
                    val = val.toString();
                }
            }
        }
        return val;
    }

    private boolean containsLong(Collection coll, Long el) {
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return false;
        }
        for (Object obj : coll) {
            Long obj2 = null;
            if (obj instanceof Integer) {
                obj2 = Long.valueOf(obj.toString());
            }
            if (!ObjectUtils.nullSafeEquals(obj2, (Object)el)) continue;
            return true;
        }
        return false;
    }

    private boolean containsDouble(Collection coll, Double el) {
        if (CollectionUtils.isEmpty((Collection)coll)) {
            return false;
        }
        for (Object obj : coll) {
            Double obj2 = null;
            if (obj instanceof Float) {
                obj2 = Double.valueOf(obj.toString());
            }
            if (!ObjectUtils.nullSafeEquals(obj2, (Object)el)) continue;
            return true;
        }
        return false;
    }

    public String getDesc() {
        return this.desc;
    }

    public ConditionValue getValue1() {
        return this.value1;
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public ConditionValue getValue2() {
        return this.value2;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setValue1(ConditionValue value1) {
        this.value1 = value1;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public void setValue2(ConditionValue value2) {
        this.value2 = value2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        ConditionValue this$value1 = this.getValue1();
        ConditionValue other$value1 = other.getValue1();
        if (this$value1 == null ? other$value1 != null : !((Object)this$value1).equals(other$value1)) {
            return false;
        }
        OperatorEnum this$operator = this.getOperator();
        OperatorEnum other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        ConditionValue this$value2 = this.getValue2();
        ConditionValue other$value2 = other.getValue2();
        return !(this$value2 == null ? other$value2 != null : !((Object)this$value2).equals(other$value2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Condition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        ConditionValue $value1 = this.getValue1();
        result = result * 59 + ($value1 == null ? 43 : ((Object)$value1).hashCode());
        OperatorEnum $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        ConditionValue $value2 = this.getValue2();
        result = result * 59 + ($value2 == null ? 43 : ((Object)$value2).hashCode());
        return result;
    }

    public String toString() {
        return "Condition(desc=" + this.getDesc() + ", value1=" + this.getValue1() + ", operator=" + (Object)((Object)this.getOperator()) + ", value2=" + this.getValue2() + ")";
    }
}

