/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.function.IFunc;
import com.fizzgate.util.DigestUtils;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecFunc
implements IFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodecFunc.class);
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String IV = "12345678";
    private static CodecFunc singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodecFunc getInstance() {
        if (singleton != null) return singleton;
        Class<CodecFunc> clazz = CodecFunc.class;
        synchronized (CodecFunc.class) {
            if (singleton != null) return singleton;
            CodecFunc instance = new CodecFunc();
            instance.init();
            singleton = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private CodecFunc() {
    }

    @Override
    public void init() {
        FuncExecutor.register("fn.codec.md5", this);
        FuncExecutor.register("fn.codec.sha1", this);
        FuncExecutor.register("fn.codec.sha256", this);
        FuncExecutor.register("fn.codec.sha384", this);
        FuncExecutor.register("fn.codec.sha512", this);
        FuncExecutor.register("fn.codec.base64Encode", this);
        FuncExecutor.register("fn.codec.base64Decode", this);
        FuncExecutor.register("fn.codec.aesEncrypt", this);
        FuncExecutor.register("fn.codec.aesDecrypt", this);
        FuncExecutor.register("fn.codec.desEncrypt", this);
        FuncExecutor.register("fn.codec.desDecrypt", this);
    }

    public String md5(String data) {
        return DigestUtils.md5Hex((String)data);
    }

    public String sha1(String data) {
        return DigestUtils.sha1Hex((String)data);
    }

    public String sha256(String data) {
        return DigestUtils.sha256Hex((String)data);
    }

    public String sha384(String data) {
        return DigestUtils.sha384Hex((String)data);
    }

    public String sha512(String data) {
        return DigestUtils.sha512Hex((String)data);
    }

    public String base64Encode(String data) throws Exception {
        try {
            return Base64.getEncoder().encodeToString(data.getBytes(CHARSET_UTF8));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Base64 encode error, data={}", (Object)data, (Object)e);
            throw e;
        }
    }

    public String base64Decode(String data) throws Exception {
        return new String(Base64.getDecoder().decode(data));
    }

    public String aesEncrypt(String data, String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)data) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(CHARSET_UTF8), "AES");
            cipher.init(1, secretKeySpec);
            byte[] result = cipher.doFinal(data.getBytes(CHARSET_UTF8));
            return Base64.getEncoder().encodeToString(result);
        }
        catch (Exception e) {
            LOGGER.error("AES encrypt error, data={}", (Object)data, (Object)e);
            throw e;
        }
    }

    public String aesDecrypt(String data, String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)data) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(CHARSET_UTF8), "AES");
            cipher.init(2, secretKeySpec);
            byte[] result = Base64.getDecoder().decode(data);
            return new String(cipher.doFinal(result));
        }
        catch (Exception e) {
            LOGGER.error("AES decrypt error, data={}", (Object)data, (Object)e);
            throw e;
        }
    }

    public String desEncrypt(String data, String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)data) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            DESKeySpec dks = new DESKeySpec(key.getBytes(CHARSET_UTF8));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(IV.getBytes(CHARSET_UTF8));
            cipher.init(1, (Key)secretKey, iv);
            byte[] bytes = cipher.doFinal(data.getBytes(CHARSET_UTF8));
            return new String(Base64.getEncoder().encode(bytes));
        }
        catch (Exception e) {
            LOGGER.error("DES eecrypt error, data={}", (Object)data, (Object)e);
            throw e;
        }
    }

    public String desDecrypt(String data, String key) throws Exception {
        if (StringUtils.isBlank((CharSequence)data) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            DESKeySpec dks = new DESKeySpec(key.getBytes(CHARSET_UTF8));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            IvParameterSpec iv = new IvParameterSpec(IV.getBytes(CHARSET_UTF8));
            cipher.init(2, (Key)secretKey, iv);
            return new String(cipher.doFinal(Base64.getDecoder().decode(data.getBytes(CHARSET_UTF8))), CHARSET_UTF8);
        }
        catch (Exception e) {
            LOGGER.error("DES decrypt error, data={}", (Object)data, (Object)e);
            throw e;
        }
    }
}

