/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.function.IFunc;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFunc
implements IFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonFunc.class);
    private static CommonFunc singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonFunc getInstance() {
        if (singleton != null) return singleton;
        Class<CommonFunc> clazz = CommonFunc.class;
        synchronized (CommonFunc.class) {
            if (singleton != null) return singleton;
            CommonFunc instance = new CommonFunc();
            instance.init();
            singleton = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private CommonFunc() {
    }

    @Override
    public void init() {
        FuncExecutor.register("fn.common.iif", this);
        FuncExecutor.register("fn.common.equals", this);
        FuncExecutor.register("fn.common.isNull", this);
        FuncExecutor.register("fn.common.isNotNull", this);
        FuncExecutor.register("fn.common.isBlank", this);
        FuncExecutor.register("fn.common.isNotBlank", this);
        FuncExecutor.register("fn.common.isEmpty", this);
        FuncExecutor.register("fn.common.isNotEmpty", this);
        FuncExecutor.register("fn.common.and", this);
        FuncExecutor.register("fn.common.or", this);
        FuncExecutor.register("fn.common.not", this);
    }

    public Object iif(boolean exprResult, Object truepart, Object falsepart) {
        return exprResult ? truepart : falsepart;
    }

    public boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public boolean isNull(Object obj) {
        return null == obj;
    }

    public boolean isNotNull(Object obj) {
        return null != obj;
    }

    public boolean isBlank(String obj) {
        return StringUtils.isBlank((CharSequence)obj);
    }

    public boolean isNotBlank(String obj) {
        return StringUtils.isNotBlank((CharSequence)obj);
    }

    public boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        return false;
    }

    public boolean isNotEmpty(Object obj) {
        return !this.isEmpty(obj);
    }

    public boolean and(Boolean ... objs) {
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] != null && objs[i].booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean or(Boolean ... objs) {
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null || !objs[i].booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean not(Boolean obj) {
        return obj == null || obj == false;
    }
}

