/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.function.IFunc;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFunc
implements IFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateFunc.class);
    public static final String DEFAULT_TIMEZONE = "GMT+08:00";
    private static DateFunc singleton;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String SHORT_TIME_FORMAT = "HH:mm";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateFunc getInstance() {
        if (singleton != null) return singleton;
        Class<DateFunc> clazz = DateFunc.class;
        synchronized (DateFunc.class) {
            if (singleton != null) return singleton;
            DateFunc instance = new DateFunc();
            instance.init();
            singleton = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private DateFunc() {
    }

    @Override
    public void init() {
        FuncExecutor.register("fn.date.timestamp", this);
        FuncExecutor.register("fn.date.getTime", this);
        FuncExecutor.register("fn.date.now", this);
        FuncExecutor.register("fn.date.add", this);
        FuncExecutor.register("fn.date.formatTs", this);
        FuncExecutor.register("fn.date.changePattern", this);
    }

    public long timestamp() {
        return System.currentTimeMillis();
    }

    public Long getTime(String date, String pattern, String ... timeZone) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        Date d = this.parse(date, pattern, timeZone);
        return d.getTime();
    }

    public String now(String pattern, String ... timeZone) {
        return this.formatDate(new Date(), pattern, timeZone);
    }

    public String add(String date, String pattern, int field, int amount, String ... timeZone) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        Date d = this.parse(date, pattern, timeZone);
        if (d != null) {
            int calField = 0;
            switch (field) {
                case 1: {
                    calField = 14;
                    break;
                }
                case 2: {
                    calField = 13;
                    break;
                }
                case 3: {
                    calField = 12;
                    break;
                }
                case 4: {
                    calField = 10;
                    break;
                }
                case 5: {
                    calField = 5;
                    break;
                }
                case 6: {
                    calField = 2;
                    break;
                }
                case 7: {
                    calField = 1;
                    break;
                }
                default: {
                    LOGGER.error("invalid field, date={} pattern={} filed={}", new Object[]{date, pattern, field});
                    throw new FizzRuntimeException("invalid field, date=" + date + "pattern=" + pattern + " filed=" + field);
                }
            }
            return this.formatDate(this.addToFiled(d, calField, amount), pattern, timeZone);
        }
        return null;
    }

    public String formatTs(Long timestamp, String pattern, String ... timeZone) {
        if (timestamp == null) {
            return null;
        }
        return this.formatDate(new Date(timestamp), pattern, timeZone);
    }

    public String changePattern(String dateStr, String sourcePattern, String targetPattern, String ... timeZone) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        return this.formatDate(this.parse(dateStr, sourcePattern, timeZone), targetPattern, timeZone);
    }

    private Date addToFiled(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    private Date parse(String dateStr, String pattern, String ... timeZone) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern == null ? DATE_TIME_FORMAT : pattern);
        if (timeZone != null && timeZone.length > 0) {
            sdf.setTimeZone(TimeZone.getTimeZone(timeZone[0]));
        } else {
            sdf.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIMEZONE));
        }
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error("Parse date error, dateStr={} pattern={}", new Object[]{dateStr, pattern, e});
            throw new FizzRuntimeException("Parse date error, dateStr=" + dateStr + " pattern=" + pattern, e);
        }
    }

    private String formatDate(Date date, String pattern, String ... timeZone) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern == null ? DATE_TIME_FORMAT : pattern);
        if (timeZone != null && timeZone.length > 0) {
            sdf.setTimeZone(TimeZone.getTimeZone(timeZone[0]));
        } else {
            sdf.setTimeZone(TimeZone.getTimeZone(DEFAULT_TIMEZONE));
        }
        return sdf.format(date);
    }
}

