/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.function.ArgsStrContainer;
import com.fizzgate.fizz.function.IFunc;
import com.fizzgate.fizz.function.RecursionContext;
import com.fizzgate.fizz.input.PathMapping;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.noear.snack.ONode;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuncExecutor.class);
    private static final Map<String, IFunc> funcMap = new HashMap<String, IFunc>();
    private static Pattern NUMBER_PATTERN = Pattern.compile("^[-\\+]?[\\d]+\\s*[,\\)]{1}|^[-\\+]?[\\d]+\\.[\\d]+\\s*[,\\)]{1}");
    private static Pattern FLOAT_PATTERN = Pattern.compile("^[-\\+]?[\\d]+\\.[\\d]+\\s*[,\\)]{1}");
    private static FuncExecutor singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FuncExecutor getInstance() {
        if (singleton != null) return singleton;
        Class<FuncExecutor> clazz = FuncExecutor.class;
        synchronized (FuncExecutor.class) {
            if (singleton != null) return singleton;
            singleton = new FuncExecutor();
            FuncExecutor.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private FuncExecutor() {
    }

    public static void init() {
        try {
            Reflections reflections = new Reflections("com.fizzgate.fizz.function", new Scanner[0]);
            Set types = reflections.getSubTypesOf(IFunc.class);
            for (Class fnType : types) {
                Method method = fnType.getMethod("getInstance", new Class[0]);
                method.invoke((Object)fnType, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register(String namespace, IFunc funcInstance) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            LOGGER.warn("namespace is required");
            return;
        }
        if (!namespace.startsWith("fn.")) {
            LOGGER.warn("namespace must start with fn.");
            return;
        }
        if (funcInstance == null) {
            LOGGER.warn("function instance is required");
            return;
        }
        funcMap.put(namespace, funcInstance);
    }

    public Object exec(ONode ctxNode, String funcExpression) {
        RecursionContext ctx = new RecursionContext();
        ctx.setFuncExpression(funcExpression);
        return this.doExec(ctxNode, ctx);
    }

    private Object doExec(ONode ctxNode, RecursionContext ctx) {
        String funcExpression = ctx.funcExpression;
        if (StringUtils.isBlank((CharSequence)funcExpression)) {
            return null;
        }
        int pos1 = (funcExpression = StringUtils.trim((String)funcExpression)).indexOf("(");
        if (pos1 == -1) {
            LOGGER.warn("func expression is invalid, expression: {}", (Object)funcExpression);
            return null;
        }
        if (!funcExpression.endsWith(")")) {
            LOGGER.warn("func expression is invalid, expression: {}", (Object)funcExpression);
            return null;
        }
        String path = funcExpression.substring(0, pos1);
        int lastDotPos = path.lastIndexOf(".");
        if (pos1 == -1) {
            LOGGER.warn("func expression is invalid, expression: {}", (Object)funcExpression);
            return null;
        }
        String namespace = path.substring(0, lastDotPos);
        String methodName = path.substring(lastDotPos + 1);
        IFunc funcInstance = funcMap.get(path);
        if (funcInstance == null) {
            String msg = String.format("function not found: %s, expression: %s", path, funcExpression);
            LOGGER.warn(msg);
            throw new FizzRuntimeException(msg);
        }
        try {
            Method method = this.findMethod(funcInstance.getClass(), methodName);
            Class[] paramTypes = method.getParameterTypes();
            ctx.funcExpression = funcExpression;
            Object[] args = this.parseArgs(ctxNode, ctx, funcExpression, paramTypes, method.isVarArgs());
            if (args == null) {
                return method.invoke((Object)funcInstance, new Object[0]);
            }
            return method.invoke((Object)funcInstance, args);
        }
        catch (FizzRuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable targetEx = e.getTargetException();
            if (targetEx instanceof FizzRuntimeException) {
                throw (FizzRuntimeException)targetEx;
            }
            String msg = targetEx.getMessage();
            if (msg == null) {
                msg = String.format("execute function error: %s", funcExpression);
            }
            LOGGER.error(msg, targetEx);
            throw new FizzRuntimeException(msg, targetEx);
        }
        catch (Exception e) {
            String msg = String.format("execute function error: %s", funcExpression);
            LOGGER.error(msg, (Throwable)e);
            throw new FizzRuntimeException(msg, e);
        }
    }

    private Method findMethod(Class funcClass, String methodName) {
        Method[] methods;
        for (Method method : methods = funcClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        String msg = String.format("method not found: %s, class: %s", methodName, funcClass);
        LOGGER.warn(msg);
        throw new FizzRuntimeException(msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] parseArgs(ONode ctxNode, RecursionContext ctx, String funcExpression, Class[] paramTypes, boolean isVarArgs) {
        int pos1 = funcExpression.indexOf("(");
        String argsStr = funcExpression.substring(pos1 + 1);
        argsStr = StringUtils.trim((String)argsStr);
        Object[] args = new Object[paramTypes.length];
        if (paramTypes.length == 0) {
            ctx.funcExpression = this.hasCloseParenthesis(argsStr, 0) ? argsStr.substring(1) : argsStr;
            return args;
        }
        if (StringUtils.isBlank((CharSequence)argsStr)) {
            if (paramTypes == null || paramTypes.length == 0) {
                ctx.funcExpression = argsStr;
                return args;
            }
            if (paramTypes.length != 1 || !isVarArgs) throw new FizzRuntimeException(String.format("missing argument, Function Expression: %s", funcExpression));
            ctx.funcExpression = argsStr;
            return args;
        }
        if (this.hasCloseParenthesis(argsStr, 0)) {
            if (paramTypes == null || paramTypes.length == 0) {
                ctx.funcExpression = argsStr.substring(1);
                return args;
            }
            if (paramTypes.length != 1 || !isVarArgs) throw new FizzRuntimeException(String.format("missing argument, Function Expression: %s", funcExpression));
            ctx.funcExpression = argsStr.substring(1);
            return args;
        }
        ArrayList<Object> varArgs = new ArrayList<Object>();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class clazz = paramTypes[i];
            if (StringUtils.isBlank((CharSequence)argsStr)) {
                if (!isVarArgs || i != paramTypes.length - 1 || args[i] != null) return args;
                args[i] = Array.newInstance(clazz.getComponentType(), 0);
                return args;
            }
            ArgsStrContainer argsStrContainer = new ArgsStrContainer(argsStr, i);
            if (argsStr.startsWith("\"")) {
                int pos = this.findStringEngPos(argsStr);
                if (pos == -1) throw new FizzRuntimeException(String.format("invalid argument: %s, Function Expression: %s", argsStr, funcExpression));
                String arg = argsStr.substring(1, pos);
                if (isVarArgs && i == paramTypes.length - 1) {
                    varArgs.add(arg);
                    args[i] = varArgs.toArray(new String[varArgs.size()]);
                } else {
                    args[i] = arg;
                }
                argsStrContainer = this.trimArgStr(argsStrContainer, pos + 1, isVarArgs, paramTypes.length, funcExpression);
                argsStr = argsStrContainer.getArgsStr();
                i = argsStrContainer.getIndex();
            } else if (argsStr.matches("^null\\s*,.*") || argsStr.matches("^null\\s*\\).*")) {
                if (isVarArgs && i == paramTypes.length - 1) {
                    varArgs.add(null);
                    Object arr = Array.newInstance(clazz.getComponentType(), varArgs.size());
                    for (int j = 0; j < varArgs.size(); ++j) {
                        Array.set(arr, j, varArgs.get(j));
                    }
                    args[i] = arr;
                } else {
                    args[i] = null;
                }
                argsStrContainer = this.trimArgStr(argsStrContainer, 4, isVarArgs, paramTypes.length, funcExpression);
                argsStr = argsStrContainer.getArgsStr();
                i = argsStrContainer.getIndex();
            } else if (argsStr.matches("^true\\s*,.*") || argsStr.matches("^true\\s*\\).*")) {
                if (isVarArgs && i == paramTypes.length - 1) {
                    varArgs.add(true);
                    args[i] = varArgs.toArray(new Boolean[varArgs.size()]);
                } else {
                    args[i] = true;
                }
                argsStrContainer = this.trimArgStr(argsStrContainer, 4, isVarArgs, paramTypes.length, funcExpression);
                argsStr = argsStrContainer.getArgsStr();
                i = argsStrContainer.getIndex();
            } else if (argsStr.matches("^false\\s*,.*") || argsStr.matches("^false\\s*\\).*")) {
                if (isVarArgs && i == paramTypes.length - 1) {
                    varArgs.add(false);
                    args[i] = varArgs.toArray(new Boolean[varArgs.size()]);
                } else {
                    args[i] = false;
                }
                argsStrContainer = this.trimArgStr(argsStrContainer, 5, isVarArgs, paramTypes.length, funcExpression);
                argsStr = argsStrContainer.getArgsStr();
                i = argsStrContainer.getIndex();
            } else if (argsStr.startsWith("{")) {
                int pos = argsStr.indexOf("}", 1);
                if (pos == -1) throw new FizzRuntimeException(String.format("invalid argument: %s, Function Expression: %s", argsStr, funcExpression));
                String refKey = argsStr.substring(1, pos);
                Object arg = PathMapping.getValueByPath(ctxNode, refKey);
                if (isVarArgs && i == paramTypes.length - 1) {
                    arg = ConvertUtils.convert((Object)arg, clazz.getComponentType());
                    varArgs.add(arg);
                    Object arr = Array.newInstance(clazz.getComponentType(), varArgs.size());
                    for (int j = 0; j < varArgs.size(); ++j) {
                        Array.set(arr, j, varArgs.get(j));
                    }
                    args[i] = arr;
                } else {
                    args[i] = arg = ConvertUtils.convert((Object)arg, (Class)clazz);
                }
                argsStrContainer = this.trimArgStr(argsStrContainer, pos + 1, isVarArgs, paramTypes.length, funcExpression);
                argsStr = argsStrContainer.getArgsStr();
                i = argsStrContainer.getIndex();
            } else {
                Matcher m = NUMBER_PATTERN.matcher(argsStr);
                boolean isNumber = m.find();
                if (isNumber) {
                    Object arg;
                    int pos = m.end();
                    String matchedStr = m.group();
                    String strNum = StringUtils.trim((String)matchedStr.substring(0, pos - 1));
                    if (isVarArgs && i == paramTypes.length - 1) {
                        arg = null;
                        arg = clazz.getComponentType().equals(Object.class) ? (FLOAT_PATTERN.matcher(argsStr).find() ? ConvertUtils.convert((String)strNum, Double.class) : ConvertUtils.convert((String)strNum, Long.class)) : ConvertUtils.convert((String)strNum, clazz.getComponentType());
                        varArgs.add(arg);
                        Object arr = Array.newInstance(clazz.getComponentType(), varArgs.size());
                        for (int j = 0; j < varArgs.size(); ++j) {
                            Array.set(arr, j, varArgs.get(j));
                        }
                        args[i] = arr;
                    } else {
                        arg = null;
                        arg = clazz.equals(Object.class) ? (FLOAT_PATTERN.matcher(argsStr).find() ? ConvertUtils.convert((String)strNum, Double.class) : ConvertUtils.convert((String)strNum, Long.class)) : ConvertUtils.convert((String)strNum, (Class)clazz);
                        args[i] = arg;
                    }
                    argsStrContainer = this.trimArgStr(argsStrContainer, pos - 1, isVarArgs, paramTypes.length, funcExpression);
                    argsStr = argsStrContainer.getArgsStr();
                    i = argsStrContainer.getIndex();
                } else {
                    Object arg;
                    ctx.funcExpression = argsStr;
                    Object rs = this.doExec(ctxNode, ctx);
                    if (isVarArgs && i == paramTypes.length - 1) {
                        arg = ConvertUtils.convert((Object)rs, clazz.getComponentType());
                        varArgs.add(arg);
                        Object arr = Array.newInstance(clazz.getComponentType(), varArgs.size());
                        for (int j = 0; j < varArgs.size(); ++j) {
                            Array.set(arr, j, varArgs.get(j));
                        }
                        args[i] = arr;
                    } else {
                        args[i] = arg = ConvertUtils.convert((Object)rs, (Class)clazz);
                    }
                    argsStr = ctx.funcExpression;
                    argsStrContainer.setArgsStr(argsStr);
                    argsStrContainer = this.trimArgStr(argsStrContainer, 0, isVarArgs, paramTypes.length, funcExpression);
                    argsStr = argsStrContainer.getArgsStr();
                    i = argsStrContainer.getIndex();
                }
            }
            ctx.funcExpression = argsStr;
        }
        return args;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArgsStrContainer trimArgStr(ArgsStrContainer argsStrContainer, int fromIndex, boolean isVarArgs, int paramTypesLen, String funcExpression) {
        int i = argsStrContainer.getIndex();
        String argsStr = argsStrContainer.getArgsStr();
        if (i == paramTypesLen - 1 || isVarArgs && i == paramTypesLen - 2) {
            boolean hasMore = this.hasMoreArg(argsStr, fromIndex);
            if (isVarArgs && hasMore) {
                argsStr = this.removeComma(argsStr, fromIndex, funcExpression);
                if (i == paramTypesLen - 1) {
                    --i;
                }
            } else {
                if (!this.hasCloseParenthesis(argsStr, fromIndex)) throw new FizzRuntimeException(String.format("invalid argument: %s, Function Expression: %s", argsStr.substring(fromIndex), funcExpression));
                argsStr = this.removeCloseParenthesis(argsStr, fromIndex, funcExpression);
                ++i;
            }
        } else {
            argsStr = this.removeComma(argsStr, fromIndex, funcExpression);
        }
        argsStrContainer.setArgsStr(argsStr);
        argsStrContainer.setIndex(i);
        return argsStrContainer;
    }

    private boolean hasMoreArg(String argsStr, int fromIndex) {
        int strLen = argsStr.length();
        if (strLen == 0) {
            return false;
        }
        for (int i = fromIndex; i < strLen; ++i) {
            if (Character.isWhitespace(argsStr.charAt(i))) continue;
            return ",".equals(String.valueOf(argsStr.charAt(i)));
        }
        return false;
    }

    private boolean hasCloseParenthesis(String argsStr, int fromIndex) {
        int strLen = argsStr.length();
        if (strLen == 0) {
            return false;
        }
        for (int i = fromIndex; i < strLen; ++i) {
            if (Character.isWhitespace(argsStr.charAt(i))) continue;
            return ")".equals(String.valueOf(argsStr.charAt(i)));
        }
        return false;
    }

    private String removeComma(String argsStr, int fromIndex, String funcExpression) {
        int strLen = argsStr.length();
        if (strLen == 0) {
            return argsStr;
        }
        for (int i = fromIndex; i < strLen; ++i) {
            if (Character.isWhitespace(argsStr.charAt(i)) || !",".equals(String.valueOf(argsStr.charAt(i)))) continue;
            return StringUtils.trim((String)argsStr.substring(i + 1));
        }
        throw new FizzRuntimeException(String.format("missing comma after argument: %s, Function Expression: %s", argsStr.substring(fromIndex), funcExpression));
    }

    private String removeCloseParenthesis(String argsStr, int fromIndex, String funcExpression) {
        int strLen = argsStr.length();
        if (strLen == 0 || strLen < fromIndex) {
            return argsStr;
        }
        for (int i = fromIndex; i < strLen; ++i) {
            if (Character.isWhitespace(argsStr.charAt(i)) || !")".equals(String.valueOf(argsStr.charAt(i)))) continue;
            return StringUtils.trim((String)argsStr.substring(i + 1));
        }
        throw new FizzRuntimeException(String.format("missing close parenthesis after argument: %s, Function Expression: %s", argsStr.substring(fromIndex), funcExpression));
    }

    private int findStringEngPos(String ep) {
        int pos = ep.indexOf("\"", 1);
        while (pos != -1) {
            String prevChar = ep.substring(pos - 1, pos);
            if (!"\\".equals(prevChar)) {
                return pos;
            }
            pos = ep.indexOf("\"", pos + 1);
        }
        return -1;
    }
}

