/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.function.IFunc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFunc
implements IFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListFunc.class);
    private static ListFunc singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ListFunc getInstance() {
        if (singleton != null) return singleton;
        Class<ListFunc> clazz = ListFunc.class;
        synchronized (ListFunc.class) {
            if (singleton != null) return singleton;
            ListFunc instance = new ListFunc();
            instance.init();
            singleton = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private ListFunc() {
    }

    @Override
    public void init() {
        FuncExecutor.register("fn.list.expand", this);
        FuncExecutor.register("fn.list.merge", this);
        FuncExecutor.register("fn.list.extract", this);
        FuncExecutor.register("fn.list.join", this);
        FuncExecutor.register("fn.list.rename", this);
        FuncExecutor.register("fn.list.removeFields", this);
    }

    public List<Object> expand(List<List<Object>> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (data == null || data.size() == 0) {
            return result;
        }
        for (List<Object> list : data) {
            result.addAll(list);
        }
        return result;
    }

    public List<Object> merge(List<Object> ... data) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (data == null || data.length == 0) {
            return result;
        }
        for (List<Object> list : data) {
            if (list == null || list.size() == 0) continue;
            result.addAll(list);
        }
        return result;
    }

    public List<Map<String, Object>> extract(List<Map<String, Object>> data, String ... fields) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (data == null || data.size() == 0) {
            return result;
        }
        if (fields == null || fields.length == 0) {
            return data;
        }
        for (Map<String, Object> m : data) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            for (String field : fields) {
                r.put(field, m.get(field));
            }
            result.add(r);
        }
        return result;
    }

    public List<Map<String, Object>> join(List<Map<String, Object>> dest, List<Map<String, Object>> src, String joinField, String ... fields) {
        if (dest == null || dest.size() == 0 || src == null || src.size() == 0) {
            return dest;
        }
        String[] joinFields = joinField.split(":");
        if (joinFields.length == 1) {
            joinFields = new String[]{joinField, joinField};
        }
        HashMap<String, Map<String, Object>> index = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> item : src) {
            if (item.get(joinFields[1]) == null) continue;
            index.putIfAbsent(item.get(joinFields[1]).toString(), item);
        }
        for (Map<String, Object> m : dest) {
            Object srcJoinFieldVal = m.get(joinFields[0]);
            if (srcJoinFieldVal == null || !index.containsKey(srcJoinFieldVal.toString())) continue;
            Map record = (Map)index.get(srcJoinFieldVal.toString());
            if (fields == null || fields.length == 0) {
                m.putAll(record);
                continue;
            }
            for (String field : fields) {
                m.put(field, record.get(field));
            }
        }
        return dest;
    }

    public List<Map<String, Object>> rename(List<Map<String, Object>> data, String ... fieldPairs) {
        if (data == null || data.size() == 0) {
            return data;
        }
        if (fieldPairs == null || fieldPairs.length == 0) {
            return data;
        }
        for (Map<String, Object> m : data) {
            for (String fieldPair : fieldPairs) {
                String[] parts = fieldPair.split(":");
                if (parts == null || parts.length != 2) {
                    LOGGER.warn("invalid fieldPair: {} , field pair pattern is: oldFieldName:newFieldName", (Object)fieldPair);
                    throw new FizzRuntimeException("invalid fieldPair: " + fieldPair + " , field pair pattern is: oldFieldName:newFieldName");
                }
                if (!m.containsKey(parts[0])) continue;
                m.put(parts[1], m.get(parts[0]));
                m.remove(parts[0]);
            }
        }
        return data;
    }

    public List<Map<String, Object>> removeFields(List<Map<String, Object>> data, String ... fields) {
        if (data == null || data.size() == 0) {
            return data;
        }
        if (fields == null || fields.length == 0) {
            return data;
        }
        for (Map<String, Object> m : data) {
            for (String field : fields) {
                m.remove(field);
            }
        }
        return data;
    }
}

