/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.function.IFunc;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathFunc
implements IFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(MathFunc.class);
    private static MathFunc singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MathFunc getInstance() {
        if (singleton != null) return singleton;
        Class<MathFunc> clazz = MathFunc.class;
        synchronized (MathFunc.class) {
            if (singleton != null) return singleton;
            MathFunc instance = new MathFunc();
            instance.init();
            singleton = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private MathFunc() {
    }

    @Override
    public void init() {
        FuncExecutor.register("fn.math.absExact", this);
        FuncExecutor.register("fn.math.negateExact", this);
        FuncExecutor.register("fn.math.addExact", this);
        FuncExecutor.register("fn.math.subtractExact", this);
        FuncExecutor.register("fn.math.multiplyExact", this);
        FuncExecutor.register("fn.math.maxExact", this);
        FuncExecutor.register("fn.math.minExact", this);
        FuncExecutor.register("fn.math.mod", this);
        FuncExecutor.register("fn.math.pow", this);
        FuncExecutor.register("fn.math.sqrt", this);
        FuncExecutor.register("fn.math.random", this);
        FuncExecutor.register("fn.math.absDecimal", this);
        FuncExecutor.register("fn.math.negateDecimal", this);
        FuncExecutor.register("fn.math.addDecimal", this);
        FuncExecutor.register("fn.math.subtractDecimal", this);
        FuncExecutor.register("fn.math.multiplyDecimal", this);
        FuncExecutor.register("fn.math.divideDecimal", this);
        FuncExecutor.register("fn.math.maxDecimal", this);
        FuncExecutor.register("fn.math.minDecimal", this);
        FuncExecutor.register("fn.math.scaleDecimal", this);
        FuncExecutor.register("fn.math.compare", this);
        FuncExecutor.register("fn.math.equals", this);
        FuncExecutor.register("fn.math.lt", this);
        FuncExecutor.register("fn.math.le", this);
        FuncExecutor.register("fn.math.gt", this);
        FuncExecutor.register("fn.math.ge", this);
    }

    public long absExact(long a) {
        return Math.abs(a);
    }

    public long negateExact(long a) {
        return Math.negateExact(a);
    }

    public long addExact(long x, long y) {
        return Math.addExact(x, y);
    }

    public long subtractExact(long x, long y) {
        return Math.subtractExact(x, y);
    }

    public long multiplyExact(long x, long y) {
        return Math.multiplyExact(x, y);
    }

    public long maxExact(long x, long y) {
        return Math.max(x, y);
    }

    public long minExact(long x, long y) {
        return Math.min(x, y);
    }

    public long mod(long x, long y) {
        return Math.floorMod(x, y);
    }

    public double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public double sqrt(double a) {
        return Math.sqrt(a);
    }

    public double random() {
        return Math.random();
    }

    public double absDecimal(double a) {
        return BigDecimal.valueOf(a).abs().doubleValue();
    }

    public double negateDecimal(double a) {
        return BigDecimal.valueOf(a).negate().doubleValue();
    }

    public double addDecimal(double x, double y) {
        return BigDecimal.valueOf(x).add(BigDecimal.valueOf(y)).doubleValue();
    }

    public double subtractDecimal(double x, double y) {
        return BigDecimal.valueOf(x).subtract(BigDecimal.valueOf(y)).doubleValue();
    }

    public double multiplyDecimal(double x, double y) {
        return BigDecimal.valueOf(x).multiply(BigDecimal.valueOf(y)).doubleValue();
    }

    public double divideDecimal(double x, double y) {
        return BigDecimal.valueOf(x).divide(BigDecimal.valueOf(y)).doubleValue();
    }

    public double maxDecimal(double x, double y) {
        return BigDecimal.valueOf(x).max(BigDecimal.valueOf(y)).doubleValue();
    }

    public double minDecimal(double x, double y) {
        return BigDecimal.valueOf(x).min(BigDecimal.valueOf(y)).doubleValue();
    }

    public double scaleDecimal(double a, int scale) {
        return BigDecimal.valueOf(a).setScale(scale, 4).doubleValue();
    }

    public int compare(double x, double y) {
        return BigDecimal.valueOf(x).compareTo(BigDecimal.valueOf(y));
    }

    public boolean equals(double x, double y) {
        return BigDecimal.valueOf(x).equals(BigDecimal.valueOf(y));
    }

    public boolean lt(double x, double y) {
        return BigDecimal.valueOf(x).compareTo(BigDecimal.valueOf(y)) == -1;
    }

    public boolean le(double x, double y) {
        return BigDecimal.valueOf(x).compareTo(BigDecimal.valueOf(y)) <= 0;
    }

    public boolean gt(double x, double y) {
        return BigDecimal.valueOf(x).compareTo(BigDecimal.valueOf(y)) == 1;
    }

    public boolean ge(double x, double y) {
        return BigDecimal.valueOf(x).compareTo(BigDecimal.valueOf(y)) >= 0;
    }
}

