/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.function;

import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.function.IFunc;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFunc
implements IFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringFunc.class);
    private static StringFunc singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringFunc getInstance() {
        if (singleton != null) return singleton;
        Class<StringFunc> clazz = StringFunc.class;
        synchronized (StringFunc.class) {
            if (singleton != null) return singleton;
            StringFunc instance = new StringFunc();
            instance.init();
            singleton = instance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private StringFunc() {
    }

    @Override
    public void init() {
        FuncExecutor.register("fn.string.equals", this);
        FuncExecutor.register("fn.string.equalsIgnoreCase", this);
        FuncExecutor.register("fn.string.compare", this);
        FuncExecutor.register("fn.string.concat", this);
        FuncExecutor.register("fn.string.concatws", this);
        FuncExecutor.register("fn.string.substring", this);
        FuncExecutor.register("fn.string.indexOf", this);
        FuncExecutor.register("fn.string.startsWith", this);
        FuncExecutor.register("fn.string.endsWith", this);
        FuncExecutor.register("fn.string.toUpperCase", this);
        FuncExecutor.register("fn.string.toLowerCase", this);
        FuncExecutor.register("fn.string.uuid", this);
        FuncExecutor.register("fn.string.toString", this);
        FuncExecutor.register("fn.string.replace", this);
        FuncExecutor.register("fn.string.replaceAll", this);
        FuncExecutor.register("fn.string.replaceFirst", this);
    }

    public boolean equals(String str1, String str2) {
        return StringUtils.equals((CharSequence)str1, (CharSequence)str2);
    }

    public boolean equalsIgnoreCase(String str1, String str2) {
        return StringUtils.equalsIgnoreCase((CharSequence)str1, (CharSequence)str2);
    }

    public int compare(String str1, String str2) {
        int n = StringUtils.compare((String)str1, (String)str2);
        return n == 0 ? 0 : (n > 0 ? 1 : -1);
    }

    public String concat(String ... strs) {
        return StringUtils.join((Object[])strs);
    }

    public String concatws(String separator, String ... strs) {
        return StringUtils.join((Object[])strs, (String)separator);
    }

    public String substring(String str, int beginIndex, int ... endIndex) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (endIndex != null && endIndex.length > 0) {
            if (endIndex.length > 1) {
                LOGGER.error("invalid argument: endIndex");
                throw new FizzRuntimeException("invalid argument: endIndex");
            }
            return str.substring(beginIndex, endIndex[0]);
        }
        return str.substring(beginIndex);
    }

    public int indexOf(String str, String substr) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return -1;
        }
        return str.indexOf(substr);
    }

    public boolean startsWith(String str, String prefix) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return str.startsWith(prefix);
    }

    public boolean endsWith(String str, String suffix) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return str.endsWith(suffix);
    }

    public String toUpperCase(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.toUpperCase();
    }

    public String toLowerCase(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        return str.toLowerCase();
    }

    public String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public String replace(String str, String target, String replacement) {
        return str.replace(target, replacement);
    }

    public String replaceAll(String str, String regex, String replacement) {
        return str.replaceAll(regex, replacement);
    }

    public String replaceFirst(String str, String regex, String replacement) {
        return str.replaceFirst(regex, replacement);
    }
}

