/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input;

import com.fizzgate.fizz.component.ComponentExecutor;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.fizz.input.InputConfig;
import com.fizzgate.fizz.input.InputType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputFactory.class);
    public static Map<InputType, Class> inputClasses = new HashMap<InputType, Class>();

    public static void registerInput(InputType type, Class inputClass) {
        inputClasses.put(type, inputClass);
    }

    public static void unregisterInput(InputType type) {
        inputClasses.remove(type);
    }

    public static InputConfig createInputConfig(Map config) {
        String type = (String)config.get("type");
        InputType typeEnum = InputType.valueOf(type.toUpperCase());
        InputConfig inputConfig = null;
        if (inputClasses.containsKey(typeEnum)) {
            Class InputClass = inputClasses.get(typeEnum);
            try {
                Method inputConfigClassMethod = InputClass.getMethod("inputConfigClass", new Class[0]);
                Class InputConfigClass = (Class)inputConfigClassMethod.invoke(null, new Object[0]);
                Constructor constructor = null;
                constructor = InputConfigClass.getDeclaredConstructor(Map.class);
                constructor.setAccessible(true);
                inputConfig = (InputConfig)constructor.newInstance(config);
            }
            catch (Exception e) {
                LOGGER.error("failed to create input config, error: {}", (Object)e.getMessage(), (Object)e);
                throw new FizzRuntimeException("failed to create input config, message: " + e.getMessage(), e);
            }
            inputConfig.setType(typeEnum);
            inputConfig.setDataMapping((Map)config.get("dataMapping"));
            inputConfig.setComponents(ComponentExecutor.buildComponents((List)config.get("components")));
            inputConfig.parse();
            return inputConfig;
        }
        throw new FizzRuntimeException("can't find input config type:" + type);
    }

    public static Input createInput(String type) {
        InputType typeEnum = InputType.valueOf(type.toUpperCase());
        Input input = null;
        if (inputClasses.containsKey(typeEnum)) {
            Class InputClass = inputClasses.get(typeEnum);
            Constructor constructor = null;
            try {
                constructor = InputClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                input = (Input)constructor.newInstance(new Object[0]);
                return input;
            }
            catch (Exception e) {
                LOGGER.error("failed to create input config, error: {}", (Object)e.getMessage(), (Object)e);
                throw new FizzRuntimeException("failed to create input config, message: " + e.getMessage(), e);
            }
        }
        throw new FizzRuntimeException("can't find input type:" + type);
    }

    public static void loadInputClasses() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Reflections reflections = new Reflections("com.fizzgate.fizz.input", new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Input.class);
        for (Class inputType : subTypes) {
            Method initializeMethod = inputType.getMethod("initialize", Class.class);
            initializeMethod.invoke(null, inputType);
        }
    }
}

