/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input;

import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.function.FuncExecutor;
import com.fizzgate.fizz.input.ScriptHelper;
import com.fizzgate.global_resource.GlobalResourceService;
import com.fizzgate.util.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.noear.snack.ONode;

public class PathMapping {
    private static final String GLOBAL_RESOURCE_PREFIX = "g.";
    private static List<String> typeList = Arrays.asList("Integer", "int", "Boolean", "boolean", "Float", "float", "Double", "double", "String", "string", "Long", "long", "Number", "number");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ONode toONode(Object obj) {
        ONode o = null;
        Object object = obj;
        synchronized (object) {
            o = ONode.loadObj((Object)obj);
        }
        return o;
    }

    public static void setByPath(ONode target, String path, Object obj, boolean supportMultiLevels) {
        if ("*".equals(path)) {
            if (obj instanceof ONode) {
                ONode node = (ONode)obj;
                if (node.isObject()) {
                    target.setAll(node);
                }
            } else if (obj instanceof Map) {
                target.setAll((Map)obj);
            }
        } else {
            String[] keys = path.split("\\.");
            if (!supportMultiLevels) {
                keys = new String[]{path};
            }
            ONode cur = target;
            for (int i = 0; i < keys.length - 1; ++i) {
                cur = cur.getOrNew(keys[i]);
            }
            if (obj instanceof ONode && ((ONode)obj).isArray() || obj instanceof Collection || obj instanceof ONode && ((ONode)obj).isObject() || obj instanceof Map) {
                ONode subNode = cur.getOrNew(keys[keys.length - 1]);
                if (obj instanceof ONode && ((ONode)obj).isArray() || obj instanceof Collection) {
                    if (subNode.isArray()) {
                        if (obj instanceof ONode) {
                            subNode.addAll((ONode)obj);
                        } else if (obj instanceof Collection) {
                            subNode.addAll((Collection)obj);
                        }
                    } else {
                        subNode.fill(obj);
                    }
                } else if (subNode.isObject()) {
                    if (obj instanceof ONode) {
                        ONode node = (ONode)obj;
                        if (node.isObject()) {
                            subNode.setAll(node);
                        }
                    } else if (obj instanceof Map) {
                        subNode.setAll((Map)obj);
                    }
                } else {
                    subNode.fill(obj);
                }
            } else {
                cur.set(keys[keys.length - 1], obj);
            }
        }
    }

    public static Map<String, Object> transformToMap(ONode ctxNode, Map<String, Object> rules, boolean supportMultiLevels) {
        ONode target = PathMapping.transform(ctxNode, rules, supportMultiLevels);
        return (Map)target.toObject(Map.class);
    }

    public static ONode transform(ONode ctxNode, Map<String, Object> rules, boolean supportMultiLevels) {
        ONode target = ONode.load(new HashMap());
        if (rules.isEmpty()) {
            return target;
        }
        HashMap<String, Object> rs = new HashMap<String, Object>();
        HashMap<String, Object> types = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rules.entrySet()) {
            if (entry.getValue() instanceof String) {
                String val = (String)entry.getValue();
                Optional<String> optType = typeList.stream().filter(s -> val.startsWith(s + " ")).findFirst();
                if (optType.isPresent()) {
                    rs.put(entry.getKey(), val.substring(optType.get().length() + 1));
                    types.put(entry.getKey(), optType.get());
                    continue;
                }
                rs.put(entry.getKey(), val);
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            List values = (List)entry.getValue();
            ArrayList<String> vList = new ArrayList<String>();
            ArrayList<String> tList = new ArrayList<String>();
            for (Object v : values) {
                if (!(v instanceof String)) continue;
                String val = (String)v;
                Optional<String> optType = typeList.stream().filter(s -> val.startsWith(s + " ")).findFirst();
                if (optType.isPresent()) {
                    vList.add(val.substring(optType.get().length() + 1));
                    tList.add(optType.get());
                    continue;
                }
                vList.add(val);
                tList.add(null);
            }
            rs.put(entry.getKey(), vList);
            types.put(entry.getKey(), tList);
        }
        if (rs.isEmpty()) {
            return target;
        }
        Object starValObj = null;
        String starEntryKey = null;
        for (Map.Entry entry : rs.entrySet()) {
            if (entry.getValue() instanceof String) {
                String path = (String)entry.getValue();
                String type = (String)types.get(entry.getKey());
                Object obj = PathMapping.getRefValue(ctxNode, type, path);
                if ("*".equals(entry.getKey())) {
                    starValObj = obj;
                    starEntryKey = (String)entry.getKey();
                    continue;
                }
                PathMapping.setByPath(target, (String)entry.getKey(), obj, supportMultiLevels);
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            List refs = (List)entry.getValue();
            List tList = (List)types.get(entry.getKey());
            ArrayList<Object> refValList = new ArrayList<Object>();
            for (int i = 0; i < refs.size(); ++i) {
                String path = (String)refs.get(i);
                String type = (String)tList.get(i);
                Object obj = PathMapping.getRefValue(ctxNode, type, path);
                if (obj instanceof List) {
                    refValList.addAll((List)obj);
                    continue;
                }
                refValList.add(obj);
            }
            PathMapping.setByPath(target, (String)entry.getKey(), refValList, supportMultiLevels);
        }
        if (starEntryKey != null) {
            PathMapping.setByPath(target, starEntryKey, starValObj, supportMultiLevels);
        }
        return target;
    }

    private static Object getRefValue(ONode ctxNode, String type, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        Object obj = null;
        if (path.startsWith("fn.")) {
            obj = FuncExecutor.getInstance().exec(ctxNode, path);
            if (obj != null && type != null) {
                obj = PathMapping.cast(obj, type, path);
            }
        } else {
            try {
                String p = path;
                String defaultValue = null;
                if (path.indexOf("|") != -1) {
                    p = path.substring(0, path.indexOf("|"));
                    defaultValue = path.substring(path.indexOf("|") + 1);
                }
                ONode val = null;
                val = p.startsWith(GLOBAL_RESOURCE_PREFIX) ? PathMapping.select(GlobalResourceService.resNode, p.substring(GLOBAL_RESOURCE_PREFIX.length())) : PathMapping.select(ctxNode, PathMapping.handlePath(p));
                obj = val != null && !val.isNull() ? val : defaultValue;
                if (obj != null && type != null) {
                    obj = PathMapping.cast(obj, type, path);
                }
            }
            catch (Exception e) {
                throw new FizzRuntimeException(String.format("path mapping errer: %s , path mapping data: %s %s", e.getMessage(), type, path), e);
            }
        }
        return obj;
    }

    private static Object cast(Object obj, String type, String path) {
        try {
            switch (type) {
                case "Integer": 
                case "int": {
                    if (obj instanceof ONode) {
                        obj = ((ONode)obj).val().getInt();
                        break;
                    }
                    obj = Integer.valueOf(obj.toString());
                    break;
                }
                case "Boolean": 
                case "boolean": {
                    if (obj instanceof ONode) {
                        obj = ((ONode)obj).val().getBoolean();
                        break;
                    }
                    obj = Boolean.valueOf(obj.toString());
                    break;
                }
                case "Float": 
                case "float": {
                    if (obj instanceof ONode) {
                        obj = Float.valueOf(((ONode)obj).val().getFloat());
                        break;
                    }
                    obj = Float.valueOf(obj.toString());
                    break;
                }
                case "Double": 
                case "double": {
                    if (obj instanceof ONode) {
                        obj = ((ONode)obj).val().getDouble();
                        break;
                    }
                    obj = Double.valueOf(obj.toString());
                    break;
                }
                case "String": 
                case "string": {
                    if (obj instanceof ONode) {
                        obj = ((ONode)obj).val().getString();
                        break;
                    }
                    obj = String.valueOf(obj.toString());
                    break;
                }
                case "Long": 
                case "long": {
                    obj = obj instanceof ONode ? Long.valueOf(((ONode)obj).val().getLong()) : Long.valueOf(obj.toString());
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new FizzRuntimeException(String.format("failed to cast %s to %s, JSON path expression: %s, error: %s", obj, type, path, e.getMessage()), e);
        }
    }

    public static ONode select(ONode ctxNode, String path) {
        ONode v;
        ONode val = ctxNode.select("$." + path);
        if (val != null && !val.isNull()) {
            return val;
        }
        String[] arr = path.split("\\.");
        if (arr.length == 6 && "headers".equals(arr[4]) && arr[5].endsWith("[0]") && !(v = ctxNode.select("$." + path.substring(0, path.length() - 3))).isArray()) {
            return v;
        }
        if (arr.length == 4 && "headers".equals(arr[2]) && arr[3].endsWith("[0]") && !(v = ctxNode.select("$." + path.substring(0, path.length() - 3))).isArray()) {
            return v;
        }
        return val;
    }

    public static Object getValueByPath(ONode ctxNode, String path) {
        return PathMapping.getValueByPath(ctxNode, null, path);
    }

    public static Object getValueByPath(ONode ctxNode, String type, String path) {
        Object val = PathMapping.getRefValue(ctxNode, type, path);
        if (val != null && val instanceof ONode) {
            ONode oval = (ONode)val;
            if (!oval.isNull()) {
                return oval.toData();
            }
            return val;
        }
        return val;
    }

    public static Map<String, Object> getScriptRules(Map<String, Object> rules) {
        if (rules.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> rs = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : rules.entrySet()) {
            if (entry.getValue() instanceof List) {
                List values = (List)entry.getValue();
                for (Object v : values) {
                    if (v instanceof String) continue;
                    rs.put(entry.getKey(), v);
                }
                continue;
            }
            if (entry.getValue() instanceof String || !(entry.getValue() instanceof Map)) continue;
            rs.put(entry.getKey(), entry.getValue());
        }
        return rs;
    }

    public static String handlePath(String path) {
        if (path.startsWith("step")) {
            String[] arr = path.split("\\.");
            List list = Arrays.stream(arr).collect(Collectors.toList());
            if (list.size() >= 2 && !"requests".equals(list.get(1)) && !"result".equals(list.get(1))) {
                list.add(1, "requests");
            }
            if (list.size() >= 4) {
                String s;
                switch (s = (String)list.get(3)) {
                    case "requestHeaders": {
                        list.set(3, "headers");
                        list.add(3, "request");
                        break;
                    }
                    case "requestParams": {
                        list.set(3, "params");
                        list.add(3, "request");
                        break;
                    }
                    case "requestBody": {
                        list.set(3, "body");
                        list.add(3, "request");
                        break;
                    }
                    case "responseHeaders": {
                        list.set(3, "headers");
                        list.add(3, "response");
                        break;
                    }
                    case "responseBody": {
                        list.set(3, "body");
                        list.add(3, "response");
                    }
                }
            }
            if (list.size() > 5 && "headers".equals(list.get(4))) {
                String headerName = ((String)list.get(5)).toUpperCase();
                list.set(5, headerName);
            }
            return String.join((CharSequence)".", list);
        }
        if (path.startsWith("input")) {
            String[] arr = path.split("\\.");
            List list = Arrays.stream(arr).collect(Collectors.toList());
            if (list.size() >= 2) {
                String s;
                switch (s = (String)list.get(1)) {
                    case "requestHeaders": {
                        list.set(1, "headers");
                        list.add(1, "request");
                        break;
                    }
                    case "requestParams": {
                        list.set(1, "params");
                        list.add(1, "request");
                        break;
                    }
                    case "requestBody": {
                        list.set(1, "body");
                        list.add(1, "request");
                        break;
                    }
                    case "responseHeaders": {
                        list.set(1, "headers");
                        list.add(1, "response");
                        break;
                    }
                    case "responseBody": {
                        list.set(1, "body");
                        list.add(1, "response");
                    }
                }
            }
            if (list.size() > 3 && "headers".equals(list.get(2))) {
                String headerName = ((String)list.get(3)).toUpperCase();
                list.set(3, headerName);
            }
            return String.join((CharSequence)".", list);
        }
        return path;
    }

    public static Map<String, Object> transform(ONode ctxNode, StepContext<String, Object> stepContext, Map<String, Object> fixed, Map<String, Object> mappingRules) {
        return PathMapping.transform(ctxNode, stepContext, fixed, mappingRules, true);
    }

    public static Map<String, Object> transform(ONode ctxNode, StepContext<String, Object> stepContext, Map<String, Object> fixed, Map<String, Object> mappingRules, boolean supportMultiLevels) {
        try {
            Map<String, Object> scriptRules;
            ONode target;
            Map<String, Object> scriptResult;
            Object val;
            if (fixed != null && fixed.containsKey("~")) {
                val = fixed.get("~");
                fixed = new HashMap<String, Object>();
                fixed.put("~", val);
            }
            if (mappingRules != null && mappingRules.containsKey("~")) {
                val = mappingRules.get("~");
                mappingRules = new HashMap<String, Object>();
                mappingRules.put("~", val);
            }
            Map<String, Object> result = new HashMap<String, Object>();
            if (fixed != null) {
                result.putAll(PathMapping.convertPath(fixed, supportMultiLevels));
            }
            if (mappingRules != null && (scriptResult = ScriptHelper.executeScripts(target = PathMapping.transform(ctxNode, mappingRules, supportMultiLevels), scriptRules = PathMapping.getScriptRules(mappingRules), ctxNode, stepContext, supportMultiLevels)) != null && !scriptResult.isEmpty()) {
                result = MapUtil.merge(result, scriptResult);
            }
            return result;
        }
        catch (FizzRuntimeException e) {
            throw new FizzRuntimeException(e.getMessage(), e, stepContext);
        }
    }

    public static Map<String, Object> convertPath(Map<String, Object> fixed, boolean supportMultiLevels) {
        ONode target = ONode.load(new HashMap());
        if (fixed.isEmpty()) {
            return (Map)target.toObject(Map.class);
        }
        Object starValObj = null;
        String starEntryKey = null;
        for (Map.Entry<String, Object> entry : fixed.entrySet()) {
            if ("*".equals(entry.getKey())) {
                starValObj = entry.getValue();
                starEntryKey = entry.getKey();
                continue;
            }
            PathMapping.setByPath(target, entry.getKey(), entry.getValue(), supportMultiLevels);
        }
        if (starEntryKey != null) {
            PathMapping.setByPath(target, starEntryKey, starValObj, supportMultiLevels);
        }
        return (Map)target.toObject(Map.class);
    }
}

