/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input;

import com.fizzgate.exception.ExecuteScriptException;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.input.Input;
import com.fizzgate.fizz.input.InputConfig;
import com.fizzgate.fizz.input.InputContext;
import com.fizzgate.fizz.input.PathMapping;
import com.fizzgate.fizz.input.RPCResponse;
import com.fizzgate.fizz.input.ScriptHelper;
import com.fizzgate.util.JacksonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptException;
import org.apache.logging.log4j.ThreadContext;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public class RPCInput
extends Input {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)RPCInput.class.getName());
    protected static final String FALLBACK_MODE_STOP = "stop";
    protected static final String FALLBACK_MODE_CONTINUE = "continue";
    protected Map<String, Object> request = new ConcurrentHashMap<String, Object>();
    protected Map<String, Object> response = new ConcurrentHashMap<String, Object>();
    protected String prefix;

    protected void doRequestMapping(InputConfig aConfig, InputContext inputContext) {
    }

    protected void doOnResponseSuccess(RPCResponse cr, long elapsedMillis) {
    }

    protected Mono<Object> bodyToMono(RPCResponse cr) {
        return cr.getBodyMono();
    }

    protected void doOnBodyError(Throwable ex, long elapsedMillis) {
    }

    protected void doOnBodySuccess(Object resp, long elapsedMillis) {
    }

    protected void doResponseMapping(InputConfig aConfig, InputContext inputContext, Object responseBody) {
    }

    @Override
    public boolean needRun(StepContext<String, Object> stepContext) {
        Map<String, Object> condition = this.config.getCondition();
        if (CollectionUtils.isEmpty(condition)) {
            return Boolean.TRUE;
        }
        ONode ctxNode = PathMapping.toONode(stepContext);
        try {
            Boolean needRun = ScriptHelper.execute(condition, ctxNode, stepContext, Boolean.class);
            return needRun != null ? needRun : Boolean.TRUE;
        }
        catch (ScriptException e) {
            ThreadContext.put((String)"traceId", (String)this.inputContext.getStepContext().getTraceId());
            LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString(condition), (Object)e);
            throw new ExecuteScriptException(e, stepContext, condition);
        }
    }

    @Override
    public Mono<Map> run() {
        long t1 = System.currentTimeMillis();
        this.doRequestMapping(this.config, this.inputContext);
        this.inputContext.getStepContext().addElapsedTime(this.stepResponse.getStepName() + "-" + this.name + "-RequestMapping", System.currentTimeMillis() - t1);
        this.prefix = this.stepResponse.getStepName() + "-\u8c03\u7528\u63a5\u53e3";
        long start = System.currentTimeMillis();
        Mono<RPCResponse> rpcResponse = this.getClientSpecFromContext(this.config, this.inputContext);
        Mono body = rpcResponse.flatMap(cr -> Mono.just((Object)cr).doOnError(throwable -> this.cleanup((RPCResponse)cr))).doOnSuccess(cr -> {
            long elapsedMillis = System.currentTimeMillis() - start;
            this.doOnResponseSuccess((RPCResponse)cr, elapsedMillis);
        }).flatMap(cr -> this.bodyToMono((RPCResponse)cr)).doOnSuccess(resp -> {
            long elapsedMillis = System.currentTimeMillis() - start;
            this.doOnBodySuccess(resp, elapsedMillis);
        }).doOnError(ex -> {
            long elapsedMillis = System.currentTimeMillis() - start;
            this.doOnBodyError((Throwable)ex, elapsedMillis);
        });
        InputConfig reqConfig = this.config;
        if (reqConfig.getFallback() != null) {
            Map<String, String> fallback = reqConfig.getFallback();
            String mode = fallback.get("mode");
            body = FALLBACK_MODE_STOP.equals(mode) ? body.onErrorStop() : (FALLBACK_MODE_CONTINUE.equals(mode) ? body.onErrorResume(ex -> Mono.just(fallback.get("defaultResult"))) : body.onErrorStop());
        }
        return body.flatMap(item -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("data", item);
            result.put("request", this);
            long t3 = System.currentTimeMillis();
            this.doResponseMapping(this.config, this.inputContext, item);
            this.inputContext.getStepContext().addElapsedTime(this.stepResponse.getStepName() + "-" + this.name + "-ResponseMapping", System.currentTimeMillis() - t3);
            return Mono.just(result);
        });
    }

    private void cleanup(RPCResponse clientResponse) {
    }

    protected Mono<RPCResponse> getClientSpecFromContext(InputConfig aConfig, InputContext inputContext) {
        return null;
    }
}

