/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input;

import com.alibaba.fastjson.JSON;
import com.fizzgate.exception.ExecuteScriptException;
import com.fizzgate.exception.RedirectException;
import com.fizzgate.exception.StopAndResponseException;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.input.PathMapping;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Script;
import com.fizzgate.util.ScriptUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ScriptHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptHelper.class);

    public static Object execute(Map<String, Object> scriptCfg, ONode ctxNode, StepContext<String, Object> stepContext) throws ScriptException {
        return ScriptHelper.execute(scriptCfg, ctxNode, stepContext, Object.class);
    }

    public static <T> T execute(Map<String, Object> scriptCfg, ONode ctxNode, StepContext<String, Object> stepContext, Class<T> clazz) throws ScriptException {
        Script script = new Script();
        script.setType((String)scriptCfg.get("type"));
        script.setSource((String)scriptCfg.get("source"));
        if (!StringUtils.hasText((String)script.getType()) || !StringUtils.hasText((String)script.getSource())) {
            return null;
        }
        HashMap<String, StepContext<String, Object>> ctx = new HashMap<String, StepContext<String, Object>>();
        ctx.put("context", stepContext);
        Object rs = ScriptUtils.execute((Script)script, ctx);
        if ("groovy".equals(script.getType())) {
            return (T)ScriptHelper.handleStopResponse(stepContext, rs);
        }
        if ("javascript".equals(script.getType())) {
            if (rs != null) {
                if (rs instanceof Collection || rs instanceof Map) {
                    return (T)rs;
                }
                String json = rs.toString();
                if (json.startsWith("[") && json.endsWith("]")) {
                    return (T)JSON.parseArray((String)json).toJavaObject(clazz);
                }
                if (json.startsWith("{") && json.endsWith("}")) {
                    if (clazz.isAssignableFrom(Map.class)) {
                        return (T)ScriptHelper.handleStopResponse(stepContext, JSON.parseObject((String)json).toJavaObject(clazz));
                    }
                    ScriptHelper.handleStopResponse(stepContext, JSON.parseObject((String)json).toJavaObject(Map.class));
                    return (T)JSON.parseObject((String)json).toJavaObject(clazz);
                }
                return (T)rs;
            }
            return null;
        }
        return (T)rs;
    }

    public static Map<String, Object> executeScripts(ONode target, Map<String, Object> scriptRules, ONode ctxNode, StepContext<String, Object> stepContext, boolean supportMultiLevels) {
        return ScriptHelper.executeScripts(target, scriptRules, ctxNode, stepContext, Object.class, supportMultiLevels);
    }

    public static <T> Map<String, T> executeScripts(ONode target, Map<String, Object> scriptRules, ONode ctxNode, StepContext<String, Object> stepContext, Class<T> clazz, boolean supportMultiLevels) {
        if (target == null) {
            target = ONode.load(new HashMap());
        }
        if (scriptRules != null && !scriptRules.isEmpty()) {
            Object starValObj = null;
            String starEntryKey = null;
            for (Map.Entry<String, Object> entry : scriptRules.entrySet()) {
                Map scriptCfg = (Map)entry.getValue();
                try {
                    if ("*".equals(entry.getKey())) {
                        starValObj = ScriptHelper.execute(scriptCfg, ctxNode, stepContext, clazz);
                        starEntryKey = entry.getKey();
                        continue;
                    }
                    PathMapping.setByPath(target, entry.getKey(), ScriptHelper.execute(scriptCfg, ctxNode, stepContext, clazz), supportMultiLevels);
                }
                catch (ScriptException e) {
                    LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                    throw new ExecuteScriptException(e, stepContext, (Object)scriptCfg);
                }
            }
            if (starEntryKey != null) {
                PathMapping.setByPath(target, starEntryKey, starValObj, supportMultiLevels);
            }
        }
        return (Map)target.toObject(Map.class);
    }

    public static Object handleStopResponse(StepContext<String, Object> stepContext, Object result) {
        Map rs;
        if (result instanceof Map && (rs = (Map)result).containsKey("_stopAndResponse")) {
            if (rs.get("_stopAndResponse") != null && rs.get("_stopAndResponse") instanceof Boolean && ((Boolean)rs.get("_stopAndResponse")).booleanValue()) {
                rs.remove("_stopAndResponse");
                if (rs.get("_redirectUrl") != null) {
                    throw new RedirectException("stop and redirect", String.valueOf(rs.get("_redirectUrl")));
                }
                if (stepContext.returnContext()) {
                    rs.put("_context", stepContext);
                }
                throw new StopAndResponseException("stop and response", JSON.toJSONString((Object)rs));
            }
            rs.remove("_stopAndResponse");
        }
        return result;
    }
}

