/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input.extension.dubbo;

import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.input.InputConfig;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DubboInputConfig
extends InputConfig {
    private String serviceName;
    private String version;
    private String group;
    private String method;
    private String paramTypes;
    private int timeout;
    private long numRetries;
    private long retryInterval;

    public DubboInputConfig(Map configMap) {
        super(configMap);
    }

    @Override
    public void parse() {
        String method;
        String group;
        String serviceName = (String)this.configMap.get("serviceName");
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new FizzRuntimeException("service name can not be blank");
        }
        this.setServiceName(serviceName);
        String version = (String)this.configMap.get("version");
        if (!StringUtils.isBlank((CharSequence)version)) {
            this.setVersion(version);
        }
        if (!StringUtils.isBlank((CharSequence)(group = (String)this.configMap.get("group")))) {
            this.setGroup(group);
        }
        if (StringUtils.isBlank((CharSequence)(method = (String)this.configMap.get("method")))) {
            throw new FizzRuntimeException("method can not be blank");
        }
        this.setMethod(method);
        String paramTypes = (String)this.configMap.get("paramTypes");
        if (!StringUtils.isBlank((CharSequence)paramTypes)) {
            this.setParamTypes(paramTypes);
        }
        if (this.configMap.get("timeout") != null && StringUtils.isNotBlank((CharSequence)this.configMap.get("timeout").toString())) {
            try {
                this.setTimeout(Integer.valueOf(this.configMap.get("timeout").toString()));
            }
            catch (Exception e) {
                throw new RuntimeException("invalid timeout: " + this.configMap.get("timeout").toString() + " " + e.getMessage(), e);
            }
        }
        if (this.configMap.get("numRetries") != null && StringUtils.isNotBlank((CharSequence)this.configMap.get("numRetries").toString())) {
            try {
                this.numRetries = Long.valueOf(this.configMap.get("numRetries").toString());
            }
            catch (Exception e) {
                throw new RuntimeException("invalid numRetries: " + this.configMap.get("numRetries").toString() + " " + e.getMessage(), e);
            }
        }
        if (this.configMap.get("retryInterval") != null && StringUtils.isNotBlank((CharSequence)this.configMap.get("retryInterval").toString())) {
            try {
                this.retryInterval = Long.valueOf(this.configMap.get("retryInterval").toString());
            }
            catch (Exception e) {
                throw new RuntimeException("invalid retryInterval: " + this.configMap.get("retryInterval").toString() + " " + e.getMessage(), e);
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(String paramTypes) {
        this.paramTypes = paramTypes;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMethod() {
        return this.method;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public long getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(long numRetries) {
        this.numRetries = numRetries;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }
}

