/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input.extension.grpc;

import com.alibaba.fastjson.JSON;
import com.fizzgate.FizzAppContext;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.exception.ExecuteScriptException;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.fizz.input.IInput;
import com.fizzgate.fizz.input.InputConfig;
import com.fizzgate.fizz.input.InputContext;
import com.fizzgate.fizz.input.InputType;
import com.fizzgate.fizz.input.PathMapping;
import com.fizzgate.fizz.input.RPCInput;
import com.fizzgate.fizz.input.RPCResponse;
import com.fizzgate.fizz.input.ScriptHelper;
import com.fizzgate.fizz.input.extension.grpc.GRPCResponse;
import com.fizzgate.fizz.input.extension.grpc.GrpcInputConfig;
import com.fizzgate.proxy.grpc.GrpcGenericService;
import com.fizzgate.proxy.grpc.GrpcInstanceService;
import com.fizzgate.proxy.grpc.GrpcInterfaceDeclaration;
import com.fizzgate.util.JacksonUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.logging.log4j.ThreadContext;
import org.noear.snack.ONode;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public class GrpcInput
extends RPCInput
implements IInput {
    public static InputType TYPE = new InputType("GRPC");

    @Override
    protected Mono<RPCResponse> getClientSpecFromContext(InputConfig aConfig, InputContext inputContext) {
        GrpcInputConfig config = (GrpcInputConfig)aConfig;
        int timeout = config.getTimeout() < 1 ? 10000 : (config.getTimeout() > 30000 ? 30000 : config.getTimeout());
        long numRetries = config.getNumRetries() > 0L ? config.getNumRetries() : 0L;
        long retryInterval = config.getRetryInterval() > 0L ? config.getRetryInterval() : 0L;
        Map attachments = (Map)this.request.get("attachments");
        ConfigurableApplicationContext applicationContext = this.getCurrentApplicationContext();
        Map body = (Map)this.request.get("body");
        String endpoint = (String)this.request.get("endpoint");
        GrpcGenericService proxy = (GrpcGenericService)applicationContext.getBean(GrpcGenericService.class);
        GrpcInterfaceDeclaration declaration = new GrpcInterfaceDeclaration();
        declaration.setEndpoint(endpoint);
        declaration.setServiceName(config.getServiceName());
        declaration.setMethod(config.getMethod());
        declaration.setTimeout(timeout);
        HashMap<String, String> contextAttachment = null;
        contextAttachment = attachments == null ? new HashMap<String, String>() : new HashMap(attachments);
        if (inputContext.getStepContext() != null && inputContext.getStepContext().getTraceId() != null) {
            if (FizzAppContext.appContext == null) {
                contextAttachment.put("X-TRACE-ID", inputContext.getStepContext().getTraceId());
            } else {
                SystemConfig systemConfig = (SystemConfig)FizzAppContext.appContext.getBean(SystemConfig.class);
                contextAttachment.put(systemConfig.fizzTraceIdHeader(), inputContext.getStepContext().getTraceId());
            }
        }
        HashMap<String, String> contextAttachment2 = contextAttachment;
        Mono proxyResponse = Mono.just((Object)"").flatMap(s -> proxy.send(JSON.toJSONString((Object)body), declaration, contextAttachment2));
        return proxyResponse.retryWhen((Retry)Retry.fixedDelay((long)numRetries, (Duration)Duration.ofMillis(retryInterval)).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
            throw new FizzRuntimeException("External gRPC Service failed to process after max retries");
        })).flatMap(cr -> {
            GRPCResponse response = new GRPCResponse();
            response.setBodyMono((Mono<Object>)Mono.just((Object)cr));
            return Mono.just((Object)response);
        });
    }

    @Override
    protected void doRequestMapping(InputConfig aConfig, InputContext inputContext) {
        GrpcInputConfig config = (GrpcInputConfig)aConfig;
        HashMap<String, Object> group = new HashMap<String, Object>();
        group.put("request", this.request);
        group.put("response", this.response);
        this.stepResponse.addRequest(this.name, group);
        this.request.put("serviceName", config.getServiceName());
        this.request.put("method", config.getMethod());
        GrpcInstanceService grpcInstanceService = (GrpcInstanceService)this.getCurrentApplicationContext().getBean(GrpcInstanceService.class);
        this.request.put("endpoint", grpcInstanceService.getInstance(config.getServiceName()));
        if (inputContext != null && inputContext.getStepContext() != null) {
            Map requestMapping;
            StepContext<String, Object> stepContext = inputContext.getStepContext();
            Map<String, Object> dataMapping = this.getConfig().getDataMapping();
            if (dataMapping != null && !CollectionUtils.isEmpty((Map)(requestMapping = (Map)dataMapping.get("request")))) {
                ONode ctxNode = PathMapping.toONode(stepContext);
                Map<String, Object> attachments = PathMapping.transform(ctxNode, stepContext, (Map)requestMapping.get("fixedHeaders"), (Map)requestMapping.get("headers"));
                if (attachments.containsKey("~") && attachments.get("~") instanceof Map) {
                    this.request.put("attachments", attachments.get("~"));
                } else {
                    this.request.put("attachments", attachments);
                }
                Map<String, Object> body = PathMapping.transform(ctxNode, stepContext, (Map)requestMapping.get("fixedBody"), (Map)requestMapping.get("body"));
                if (body.containsKey("~")) {
                    this.request.put("body", body.get("~"));
                } else {
                    if (requestMapping.get("script") != null) {
                        Map scriptCfg = (Map)requestMapping.get("script");
                        try {
                            Object reqBody = ScriptHelper.execute(scriptCfg, ctxNode, stepContext);
                            if (reqBody != null) {
                                body.putAll((Map)reqBody);
                            }
                        }
                        catch (ScriptException e) {
                            ThreadContext.put((String)"traceId", (String)inputContext.getStepContext().getTraceId());
                            LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                            throw new ExecuteScriptException(e, stepContext, (Object)scriptCfg);
                        }
                    }
                    this.request.put("body", body);
                }
            }
        }
    }

    @Override
    protected void doOnResponseSuccess(RPCResponse cr, long elapsedMillis) {
        this.inputContext.getStepContext().addElapsedTime(this.getApiName(), elapsedMillis);
    }

    @Override
    protected Mono<Object> bodyToMono(RPCResponse cr) {
        return cr.getBodyMono();
    }

    @Override
    protected void doOnBodyError(Throwable ex, long elapsedMillis) {
        ThreadContext.put((String)"traceId", (String)this.inputContext.getStepContext().getTraceId());
        LOGGER.warn("failed to call {}", (Object)this.getApiName(), (Object)ex);
        this.inputContext.getStepContext().addElapsedTime(this.getApiName() + " failed ", elapsedMillis);
    }

    @Override
    protected void doOnBodySuccess(Object resp, long elapsedMillis) {
    }

    @Override
    protected void doResponseMapping(InputConfig aConfig, InputContext inputContext, Object responseBody) {
        this.response.put("body", responseBody);
        if (inputContext != null && inputContext.getStepContext() != null) {
            StepContext<String, Object> stepContext = inputContext.getStepContext();
            Map<String, Object> dataMapping = this.getConfig().getDataMapping();
            if (dataMapping != null) {
                Map responseMapping = (Map)dataMapping.get("response");
                if (!CollectionUtils.isEmpty((Map)responseMapping)) {
                    ONode ctxNode = PathMapping.toONode(stepContext);
                    Map fixedBody = (Map)responseMapping.get("fixedBody");
                    Map bodyMapping = (Map)responseMapping.get("body");
                    Map scriptCfg = (Map)responseMapping.get("script");
                    if (fixedBody != null && !fixedBody.isEmpty() || bodyMapping != null && !bodyMapping.isEmpty() || scriptCfg != null && scriptCfg.get("type") != null && scriptCfg.get("source") != null) {
                        HashMap<String, Object> body = new HashMap<String, Object>();
                        body.putAll(PathMapping.transform(ctxNode, stepContext, fixedBody, bodyMapping));
                        if (body.containsKey("~")) {
                            this.response.put("body", body.get("~"));
                        } else {
                            if (scriptCfg != null && scriptCfg.get("type") != null && scriptCfg.get("source") != null) {
                                try {
                                    Object respBody = ScriptHelper.execute(scriptCfg, ctxNode, stepContext);
                                    if (respBody != null) {
                                        body.putAll((Map)respBody);
                                    }
                                }
                                catch (ScriptException e) {
                                    ThreadContext.put((String)"traceId", (String)inputContext.getStepContext().getTraceId());
                                    LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                                    throw new ExecuteScriptException(e, stepContext, (Object)scriptCfg);
                                }
                            }
                            this.response.put("body", body);
                        }
                    }
                }
            } else {
                this.response.put("body", responseBody);
            }
        }
    }

    private String getApiName() {
        return this.prefix + " - " + this.request.get("serviceName") + " - " + this.request.get("method");
    }

    public static Class inputConfigClass() {
        return GrpcInputConfig.class;
    }
}

