/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input.extension.request;

import com.alibaba.fastjson.JSON;
import com.fizzgate.config.SystemConfig;
import com.fizzgate.exception.ExecuteScriptException;
import com.fizzgate.fizz.StepContext;
import com.fizzgate.fizz.StepResponse;
import com.fizzgate.fizz.input.IInput;
import com.fizzgate.fizz.input.InputConfig;
import com.fizzgate.fizz.input.InputContext;
import com.fizzgate.fizz.input.InputType;
import com.fizzgate.fizz.input.PathMapping;
import com.fizzgate.fizz.input.RPCInput;
import com.fizzgate.fizz.input.RPCResponse;
import com.fizzgate.fizz.input.ScriptHelper;
import com.fizzgate.fizz.input.extension.request.RequestInputConfig;
import com.fizzgate.fizz.input.extension.request.RequestRPCResponse;
import com.fizzgate.proxy.FizzWebClient;
import com.fizzgate.proxy.http.HttpInstanceService;
import com.fizzgate.service_registry.RegistryCenterService;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.MapUtil;
import com.fizzgate.util.TypeUtils;
import com.fizzgate.xml.JsonToXml;
import com.fizzgate.xml.XmlToJson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RequestInput
extends RPCInput
implements IInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestInput.class);
    public static InputType TYPE = new InputType("REQUEST");
    private InputType type;
    protected Map<String, Object> dataMapping;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_XML = "application/xml";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private static final String CONTENT_TYPE_JS = "application/javascript";
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_TEXT = "text/plain";
    private static final String CONTENT_TYPE_AUTO = "auto";
    private static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String CONTENT_TYPE = "content-type";
    private static final Integer SERVICE_TYPE_DISCOVERY = 1;
    private static final Integer SERVICE_TYPE_HTTP = 2;
    private String respContentType;
    private String reqContentType;
    private String[] xmlArrPaths;
    private static Pattern PATH_VAR_PATTERN = Pattern.compile("(\\{)([^/]*)(\\})");

    public InputType getType() {
        return this.type;
    }

    public void setType(InputType typeEnum) {
        this.type = typeEnum;
    }

    public Map<String, Object> getDataMapping() {
        return this.dataMapping;
    }

    public void setDataMapping(Map<String, Object> dataMapping) {
        this.dataMapping = dataMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRequestMapping(InputConfig aConfig, InputContext inputContext) {
        Object method;
        RequestInputConfig config = (RequestInputConfig)aConfig;
        HashMap<String, Object> params = new HashMap<String, Object>();
        StepContext<String, Object> stepContext = inputContext.getStepContext();
        synchronized (stepContext) {
            HashMap<String, Object> group = new HashMap<String, Object>();
            group.put("request", this.request);
            group.put("response", this.response);
            this.stepResponse.addRequest(this.name, group);
            method = HttpMethod.valueOf((String)config.getMethod().toUpperCase());
            this.request.put("method", method);
            params.putAll(MapUtil.toHashMap(config.getQueryParams()));
            this.request.put("params", params);
        }
        ONode ctxNode = null;
        if (inputContext != null && inputContext.getStepContext() != null) {
            StepContext<String, Object> stepContext2 = inputContext.getStepContext();
            ctxNode = PathMapping.toONode(stepContext2);
            method = stepContext2;
            synchronized (method) {
                Map requestMapping;
                Map<String, Object> dataMapping = this.getConfig().getDataMapping();
                if (dataMapping != null && !CollectionUtils.isEmpty((Map)(requestMapping = (Map)dataMapping.get("request")))) {
                    Map<String, Object> body;
                    this.reqContentType = (String)requestMapping.get("contentType");
                    Map<String, Object> headers = PathMapping.transform(ctxNode, stepContext2, MapUtil.upperCaseKey((Map)MapUtil.list2Map(requestMapping.get("fixedHeaders"))), MapUtil.upperCaseKey((Map)MapUtil.list2Map(requestMapping.get("headers"))), false);
                    if (headers.containsKey("~") && headers.get("~") instanceof Map) {
                        this.request.put("headers", headers.get("~"));
                    } else {
                        this.request.put("headers", headers);
                    }
                    params.putAll(PathMapping.transform(ctxNode, stepContext2, MapUtil.list2Map(requestMapping.get("fixedParams")), MapUtil.list2Map(requestMapping.get("params")), false));
                    if (params.containsKey("~") && params.get("~") instanceof Map) {
                        this.request.put("params", params.get("~"));
                    } else {
                        this.request.put("params", params);
                    }
                    boolean supportMultiLevels = true;
                    if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(this.reqContentType) || CONTENT_TYPE_FORM_URLENCODED.equals(this.reqContentType)) {
                        supportMultiLevels = false;
                    }
                    if ((body = PathMapping.transform(ctxNode, stepContext2, MapUtil.list2Map(requestMapping.get("fixedBody")), MapUtil.list2Map(requestMapping.get("body")), supportMultiLevels)).containsKey("~")) {
                        this.request.put("body", body.get("~"));
                    } else {
                        if (requestMapping.get("script") != null) {
                            Map scriptCfg = (Map)requestMapping.get("script");
                            try {
                                Object reqBody = ScriptHelper.execute(scriptCfg, ctxNode, stepContext2);
                                if (reqBody != null) {
                                    body.putAll((Map)reqBody);
                                }
                            }
                            catch (ScriptException e) {
                                ThreadContext.put((String)"traceId", (String)inputContext.getStepContext().getTraceId());
                                LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                                throw new ExecuteScriptException(e, stepContext2, (Object)scriptCfg);
                            }
                        }
                        this.request.put("body", body);
                    }
                }
            }
        }
        if (config.isNewVersion()) {
            String host = config.getServiceName();
            if (SERVICE_TYPE_HTTP.equals((int)config.getServiceType())) {
                HttpInstanceService httpInstanceService = (HttpInstanceService)this.getCurrentApplicationContext().getBean(HttpInstanceService.class);
                String instance = httpInstanceService.getInstance(config.getServiceName());
                if (instance != null) {
                    host = instance;
                }
            } else if (SERVICE_TYPE_DISCOVERY.equals(config.getServiceType()) && StringUtils.isNotBlank((CharSequence)config.getRegistryName())) {
                host = RegistryCenterService.getServiceNameSpace(config.getRegistryName(), host);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(config.getProtocol()).append("://").append(host).append(config.getPath().startsWith("/") ? "" : "/").append(this.setPathVariable(ctxNode, config.getPath()));
            UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)sb.toString()).queryParams(MapUtil.toMultiValueMap(params)).build();
            StepContext<String, Object> stepContext3 = inputContext.getStepContext();
            synchronized (stepContext3) {
                this.request.put("url", uriComponents.toUriString());
            }
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)(config.getBaseUrl() + this.setPathVariable(ctxNode, config.getPath()))).queryParams(MapUtil.toMultiValueMap(params)).build();
        StepContext<String, Object> stepContext4 = inputContext.getStepContext();
        synchronized (stepContext4) {
            this.request.put("url", uriComponents.toUriString());
        }
    }

    private String setPathVariable(ONode ctxNode, String path) {
        if (ctxNode == null || StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        CharSequence[] paths = path.split("/");
        for (int i = 0; i < paths.length; ++i) {
            String jsonPath;
            Object val;
            Matcher matcher = PATH_VAR_PATTERN.matcher(paths[i]);
            if (!matcher.find() || (val = PathMapping.getValueByPath(ctxNode, jsonPath = matcher.group(2))) == null || val instanceof Map || val instanceof List) continue;
            paths[i] = matcher.replaceAll(String.valueOf(val));
        }
        return String.join((CharSequence)"/", paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doResponseMapping(InputConfig aConfig, InputContext inputContext, Object responseBody) {
        RequestInputConfig config = (RequestInputConfig)aConfig;
        String cfgContentType = null;
        Map<String, Object> dataMapping = config.getDataMapping();
        Map responseMapping = null;
        if (dataMapping != null && !CollectionUtils.isEmpty((Map)(responseMapping = (Map)dataMapping.get("response")))) {
            cfgContentType = (String)responseMapping.get("contentType");
            String paths = (String)responseMapping.get("xmlArrPaths");
            if (StringUtils.isNotBlank((CharSequence)paths)) {
                this.xmlArrPaths = paths.split(",");
            }
        }
        String ct = null;
        ct = cfgContentType == null || CONTENT_TYPE_AUTO.equals(cfgContentType) ? this.respContentType : cfgContentType;
        if (StringUtils.isBlank((CharSequence)ct)) {
            ct = CONTENT_TYPE_JSON;
        }
        StepContext<String, Object> stepContext = inputContext.getStepContext();
        synchronized (stepContext) {
            this.response.put("body", this.parseBody(ct, (String)responseBody));
        }
        if (inputContext != null && inputContext.getStepContext() != null) {
            StepContext<String, Object> stepContext2 = inputContext.getStepContext();
            if (!CollectionUtils.isEmpty((Map)responseMapping)) {
                ONode ctxNode = PathMapping.toONode(stepContext2);
                StepContext<String, Object> stepContext3 = stepContext2;
                synchronized (stepContext3) {
                    Map fixedHeaders = MapUtil.upperCaseKey((Map)((Map)responseMapping.get("fixedHeaders")));
                    Map headerMapping = MapUtil.upperCaseKey((Map)((Map)responseMapping.get("headers")));
                    if (fixedHeaders != null && !fixedHeaders.isEmpty() || headerMapping != null && !headerMapping.isEmpty()) {
                        HashMap<String, Object> headers = new HashMap<String, Object>();
                        headers.putAll(PathMapping.transform(ctxNode, stepContext2, fixedHeaders, headerMapping, false));
                        if (headers.containsKey("~") && headers.get("~") instanceof Map) {
                            this.response.put("headers", headers.get("~"));
                        } else {
                            this.response.put("headers", headers);
                        }
                    }
                    Map fixedBody = (Map)responseMapping.get("fixedBody");
                    Map bodyMapping = (Map)responseMapping.get("body");
                    Map scriptCfg = (Map)responseMapping.get("script");
                    if (fixedBody != null && !fixedBody.isEmpty() || bodyMapping != null && !bodyMapping.isEmpty() || scriptCfg != null && scriptCfg.get("type") != null && scriptCfg.get("source") != null) {
                        HashMap<String, Object> body = new HashMap<String, Object>();
                        body.putAll(PathMapping.transform(ctxNode, stepContext2, fixedBody, bodyMapping));
                        if (body.containsKey("~")) {
                            this.response.put("body", body.get("~"));
                        } else {
                            if (scriptCfg != null && scriptCfg.get("type") != null && scriptCfg.get("source") != null) {
                                try {
                                    Object respBody = ScriptHelper.execute(scriptCfg, ctxNode, stepContext2);
                                    if (respBody != null) {
                                        body.putAll((Map)respBody);
                                    }
                                }
                                catch (ScriptException e) {
                                    ThreadContext.put((String)"traceId", (String)inputContext.getStepContext().getTraceId());
                                    LOGGER.warn("execute script failed, {}", (Object)JacksonUtils.writeValueAsString((Object)scriptCfg), (Object)e);
                                    throw new ExecuteScriptException(e, stepContext2, (Object)scriptCfg);
                                }
                            }
                            this.response.put("body", body);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected Mono<RPCResponse> getClientSpecFromContext(InputConfig aConfig, InputContext inputContext) {
        HttpHeaders headers;
        RequestInputConfig config = (RequestInputConfig)aConfig;
        int timeout = config.getTimeout() < 1 ? 10000 : (config.getTimeout() > 30000 ? 30000 : config.getTimeout());
        long numRetries = config.getNumRetries() > 0L ? config.getNumRetries() : 0L;
        long retryInterval = config.getRetryInterval() > 0L ? config.getRetryInterval() : 0L;
        HttpMethod method = HttpMethod.valueOf((String)config.getMethod());
        String url = (String)this.request.get("url");
        HashMap hds = (HashMap)this.request.get("headers");
        if (hds == null) {
            hds = new HashMap();
        }
        if (!(headers = MapUtil.toHttpHeaders((Map)hds)).containsKey((Object)"Content-Type")) {
            if (CONTENT_TYPE_XML.equals(this.reqContentType) || CONTENT_TYPE_TEXT_XML.equals(this.reqContentType)) {
                headers.add("Content-Type", CONTENT_TYPE_XML);
            } else if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(this.reqContentType)) {
                headers.add("Content-Type", CONTENT_TYPE_MULTIPART_FORM_DATA);
            } else if (CONTENT_TYPE_FORM_URLENCODED.equals(this.reqContentType)) {
                headers.add("Content-Type", CONTENT_TYPE_FORM_URLENCODED);
            } else {
                headers.add("Content-Type", "application/json; charset=UTF-8");
            }
        }
        SystemConfig systemConfig = (SystemConfig)this.getCurrentApplicationContext().getBean(SystemConfig.class);
        for (String string : systemConfig.getProxySetHeaders()) {
            if (inputContext.getStepContext().getInputReqHeader(string) == null || headers.containsKey((Object)string)) continue;
            Object o = inputContext.getStepContext().getInputReqHeader(string);
            if (o instanceof String) {
                headers.add(string, (String)o);
                continue;
            }
            if (!(o instanceof List)) continue;
            List list = (List)o;
            ArrayList<String> vals = new ArrayList<String>();
            for (Object item : list) {
                if (item == null) continue;
                vals.add(item.toString());
            }
            headers.addAll(string, vals);
        }
        headers.remove((Object)"Content-Length");
        headers.add(systemConfig.fizzTraceIdHeader(), inputContext.getStepContext().getTraceId());
        StepContext<String, Object> stepContext = inputContext.getStepContext();
        synchronized (stepContext) {
            this.request.put("headers", MapUtil.headerToHashMap((HttpHeaders)headers));
        }
        Object body = null;
        if (CONTENT_TYPE_XML.equals(this.reqContentType) || CONTENT_TYPE_TEXT_XML.equals(this.reqContentType)) {
            Object jsonToXml;
            void var15_18;
            StepContext<String, Object> stepContext2 = inputContext.getStepContext();
            synchronized (stepContext2) {
                this.request.put("jsonBody", this.request.get("body"));
            }
            Object var15_15 = null;
            if (TypeUtils.isBasicType(this.request.get("body"))) {
                String string = this.request.get("body").toString();
            } else {
                String string = JSON.toJSONString(this.request.get("body"));
            }
            LOGGER.info("jsonBody={}", (Object)var15_18);
            if (var15_18.startsWith("{") || var15_18.startsWith("[")) {
                jsonToXml = new JsonToXml.Builder((String)var15_18).build();
                body = jsonToXml.toString();
            } else {
                body = var15_18;
            }
            jsonToXml = inputContext.getStepContext();
            synchronized (jsonToXml) {
                this.request.put("body", body);
            }
            LOGGER.info("body={}", body);
            LOGGER.info("headers={}", (Object)JSON.toJSONString((Object)headers));
        } else if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(this.reqContentType)) {
            MultiValueMap multiValueMap = MapUtil.toMultipartDataMap((Map)((Map)this.request.get("body")));
            MapUtil.replaceWithFilePart((MultiValueMap)multiValueMap, (String)"__fizz_file__", inputContext.getStepContext().getFilePartMap());
            body = BodyInserters.fromMultipartData((MultiValueMap)multiValueMap);
        } else {
            body = CONTENT_TYPE_FORM_URLENCODED.equals(this.reqContentType) ? BodyInserters.fromFormData((MultiValueMap)MapUtil.toMultiValueMap((Map)((Map)this.request.get("body")))) : (TypeUtils.isBasicType(this.request.get("body")) ? this.request.get("body").toString() : JSON.toJSONString(this.request.get("body")));
        }
        HttpMethod httpMethod = HttpMethod.valueOf((String)inputContext.getStepContext().getInputReqAttr("method").toString());
        String aggrPath = (String)inputContext.getStepContext().getInputReqAttr("path");
        String aggrService = aggrPath.split("\\/")[2];
        FizzWebClient client = (FizzWebClient)this.getCurrentApplicationContext().getBean(FizzWebClient.class);
        Mono<ClientResponse> clientResponse = client.send(inputContext.getStepContext().getTraceId(), method, url, headers, body, timeout, numRetries, retryInterval);
        return clientResponse.flatMap(cr -> {
            RequestRPCResponse response = new RequestRPCResponse();
            response.setHeaders((MultiValueMap)cr.headers().asHttpHeaders());
            response.setBodyMono((Mono<Object>)cr.bodyToMono(String.class));
            response.setStatus(cr.statusCode());
            return Mono.just((Object)response);
        });
    }

    private Map<String, Object> getResponses(Map<String, StepResponse> stepContext2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnResponseSuccess(RPCResponse cr, long elapsedMillis) {
        HttpHeaders httpHeaders = (HttpHeaders)cr.getHeaders();
        HashMap<String, String> headers = new HashMap<String, String>();
        httpHeaders.forEach((key, value) -> {
            if (value.size() > 1) {
                headers.put(key.toUpperCase(), (String)value);
            } else {
                headers.put(key.toUpperCase(), httpHeaders.getFirst(key));
            }
        });
        headers.put("ELAPSEDTIME", elapsedMillis + "ms");
        RequestRPCResponse reqCr = (RequestRPCResponse)cr;
        StepContext<String, Object> stepContext = this.inputContext.getStepContext();
        synchronized (stepContext) {
            if (reqCr.getStatusCode() != null) {
                this.response.put("httpStatus", reqCr.getStatusCode().value());
            }
            this.response.put("headers", headers);
            this.respContentType = httpHeaders.getFirst(CONTENT_TYPE);
            this.inputContext.getStepContext().addElapsedTime(this.prefix + this.request.get("url"), elapsedMillis);
        }
    }

    protected Mono<Object> bodyToMono(ClientResponse cr) {
        return cr.bodyToMono(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnBodyError(Throwable ex, long elapsedMillis) {
        ThreadContext.put((String)"traceId", (String)this.inputContext.getStepContext().getTraceId());
        LOGGER.warn("failed to call {}", this.request.get("url"), (Object)ex);
        StepContext<String, Object> stepContext = this.inputContext.getStepContext();
        synchronized (stepContext) {
            this.inputContext.getStepContext().addElapsedTime(this.stepResponse.getStepName() + "-\u8c03\u7528\u63a5\u53e3 failed " + this.request.get("url"), elapsedMillis);
        }
    }

    public Object parseBody(String contentType, String responseBody) {
        String[] cts = contentType.split(";");
        Object body = null;
        for (int i = 0; i < cts.length; ++i) {
            String ct;
            switch (ct = cts[i].toLowerCase()) {
                case "application/json": {
                    body = JSON.parse((String)responseBody);
                    break;
                }
                case "text/plain": {
                    if (responseBody.startsWith("{") && responseBody.endsWith("}") || responseBody.startsWith("[") && responseBody.endsWith("]")) {
                        try {
                            body = JSON.parse((String)responseBody);
                        }
                        catch (Exception e) {
                            body = responseBody;
                        }
                        break;
                    }
                    body = responseBody;
                    break;
                }
                case "application/xml": 
                case "text/xml": {
                    XmlToJson.Builder builder = new XmlToJson.Builder(responseBody);
                    if (this.xmlArrPaths != null && this.xmlArrPaths.length > 0) {
                        for (int j = 0; j < this.xmlArrPaths.length; ++j) {
                            String p = this.xmlArrPaths[j];
                            builder = builder.forceList(p);
                        }
                    }
                    body = builder.build().toJson().toMap();
                    break;
                }
                case "text/html": {
                    body = responseBody;
                    break;
                }
                case "application/javascript": {
                    body = responseBody;
                }
            }
            if (body != null) break;
        }
        if (body == null) {
            body = responseBody;
        }
        return body;
    }

    @Override
    protected void doOnBodySuccess(Object resp, long elapsedMillis) {
        if (this.inputContext.getStepContext().isDebug().booleanValue()) {
            ThreadContext.put((String)"traceId", (String)this.inputContext.getStepContext().getTraceId());
            LOGGER.info("{} \u8017\u65f6:{}ms URL={}, reqHeader={} req={} resp={}", new Object[]{this.prefix, elapsedMillis, this.request.get("url"), JSON.toJSONString(this.request.get("headers")), JSON.toJSONString(this.request.get("body")), resp});
        }
    }

    private void cleanup(ClientResponse clientResponse) {
        if (clientResponse != null) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }

    public static Class inputConfigClass() {
        return RequestInputConfig.class;
    }
}

