/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.fizz.input.extension.request;

import com.fizzgate.fizz.input.InputConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class RequestInputConfig
extends InputConfig {
    private URL url;
    private String method;
    private int timeout;
    private String protocol;
    private Integer serviceType;
    private String serviceName;
    private String path;
    private long numRetries;
    private long retryInterval;
    private String registryName;

    public RequestInputConfig(Map configBody) {
        super(configBody);
        if (configBody.get("serviceType") != null && StringUtils.isNotBlank((CharSequence)((String)configBody.get("protocol"))) && StringUtils.isNotBlank((CharSequence)((String)configBody.get("serviceName"))) && StringUtils.isNotBlank((CharSequence)((String)configBody.get("path")))) {
            this.serviceType = Integer.valueOf(configBody.get("serviceType").toString());
            this.protocol = ((String)configBody.get("protocol")).toLowerCase();
            this.serviceName = (String)configBody.get("serviceName");
            this.registryName = (String)configBody.get("registryName");
            this.path = (String)configBody.get("path");
        } else {
            String url = (String)configBody.get("url");
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new RuntimeException("Request URL can not be blank");
            }
            this.setUrl(url);
        }
        if (configBody.get("method") != null) {
            this.setMethod(((String)configBody.get("method")).toUpperCase());
        } else {
            this.setMethod("GET");
        }
        if (configBody.get("timeout") != null && StringUtils.isNotBlank((CharSequence)configBody.get("timeout").toString())) {
            try {
                this.timeout = Integer.valueOf(configBody.get("timeout").toString());
            }
            catch (Exception e) {
                throw new RuntimeException("invalid timeout: " + configBody.get("timeout").toString() + " " + e.getMessage(), e);
            }
        }
        if (configBody.get("numRetries") != null && StringUtils.isNotBlank((CharSequence)configBody.get("numRetries").toString())) {
            try {
                this.numRetries = Long.valueOf(configBody.get("numRetries").toString());
            }
            catch (Exception e) {
                throw new RuntimeException("invalid numRetries: " + configBody.get("numRetries").toString() + " " + e.getMessage(), e);
            }
        }
        if (configBody.get("retryInterval") != null && StringUtils.isNotBlank((CharSequence)configBody.get("retryInterval").toString())) {
            try {
                this.retryInterval = Long.valueOf(configBody.get("retryInterval").toString());
            }
            catch (Exception e) {
                throw new RuntimeException("invalid retryInterval: " + configBody.get("retryInterval").toString() + " " + e.getMessage(), e);
            }
        }
        if (configBody.get("fallback") != null) {
            Map fallback = (Map)configBody.get("fallback");
            this.setFallback(fallback);
        }
        if (configBody.get("condition") != null) {
            this.setCondition((Map)configBody.get("condition"));
        }
    }

    public boolean isNewVersion() {
        return this.serviceType != null && StringUtils.isNotBlank((CharSequence)this.protocol) && StringUtils.isNotBlank((CharSequence)this.serviceName) && StringUtils.isNotBlank((CharSequence)this.path);
    }

    public String getQueryStr() {
        return this.url.getQuery();
    }

    public MultiValueMap<String, String> getQueryParams() {
        if (this.isNewVersion()) {
            return null;
        }
        MultiValueMap parameters = UriComponentsBuilder.fromUriString((String)this.url.toString()).build().getQueryParams();
        return parameters;
    }

    public String getBaseUrl() {
        return this.url.getProtocol() + "://" + this.url.getHost() + (this.url.getPort() == -1 ? "" : ":" + this.url.getPort());
    }

    public String getPath() {
        if (this.isNewVersion()) {
            return this.path;
        }
        return this.url.getPath();
    }

    public void setUrl(String string) {
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public RequestInputConfig() {
        super(null);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Integer getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(long numRetries) {
        this.numRetries = numRetries;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }
}

