/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.global_resource;

import com.fizzgate.fizz.input.PathMapping;
import com.fizzgate.global_resource.GlobalResource;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.noear.snack.ONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class GlobalResourceService {
    private static final Logger log = LoggerFactory.getLogger(GlobalResourceService.class);
    public static ONode resNode;
    private Map<String, GlobalResource> resourceMap = new HashMap<String, GlobalResource>(64);
    private Map<String, Object> objectMap = new HashMap<String, Object>(64);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;

    @PostConstruct
    public void init() throws Throwable {
        Result<?> result = this.initGlobalResource();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        result = this.lsnGlobalResourceChange();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        this.updateResNode();
    }

    private void updateResNode() {
        resNode = PathMapping.toONode(this.objectMap);
        log.info("global resource node is updated, new keys: {}", this.objectMap.keySet());
    }

    private Result<?> initGlobalResource() {
        Result result = Result.succ();
        Flux resources = this.rt.opsForHash().entries((Object)"fizz_global_resource");
        resources.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        GlobalResource r = (GlobalResource)JacksonUtils.readValue((String)json, GlobalResource.class);
                        this.resourceMap.put(r.key, r);
                        this.objectMap.put(r.key, r.originalVal);
                        log.info("init global resource {}", (Object)r.key);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init global resource error, json: " + json;
                    result.t = t;
                }
            } else {
                log.info("no global resource");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init global resource error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        return result;
    }

    private Result<?> lsnGlobalResourceChange() {
        Result result = Result.succ();
        String channel = "fizz_global_resource_channel";
        this.rt.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: " + channel;
            result.t = t;
            log.error("lsn channel {} error", (Object)channel, t);
        }).doOnSubscribe(s -> log.info("success to lsn on {}", (Object)channel)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                GlobalResource r = (GlobalResource)JacksonUtils.readValue((String)message, GlobalResource.class);
                if (r.isDeleted) {
                    this.resourceMap.remove(r.key);
                    this.objectMap.remove(r.key);
                    log.info("remove global resource {}", (Object)r.key);
                } else {
                    this.resourceMap.put(r.key, r);
                    this.objectMap.put(r.key, r.originalVal);
                    log.info("update global resource {}", (Object)r.key);
                }
                this.updateResNode();
            }
            catch (Throwable t) {
                log.error("update global resource error, {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }

    public Map<String, GlobalResource> getResourceMap() {
        return this.resourceMap;
    }

    public GlobalResource get(String key) {
        return this.resourceMap.get(key);
    }
}

