/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fizzgate.fizz.ConfigLoader;
import java.net.InetAddress;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.ReactiveRedisMessageListenerContainer;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Component
public class AggregateChannelListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateChannelListener.class);
    private static final String AGGREGATE_CHANNEL = "fizz_aggregate_channel";
    private ReactiveRedisMessageListenerContainer reactiveRedisMessageListenerContainer;
    private ConfigLoader configLoader;
    private Disposable disposable;
    private static final String TYPE_PUBLISH = "publish ";
    private static final String TYPE_ROLLBACK = "rollback ";
    private static final String TYPE_TEST = "test ";
    private static final String TYPE_DELETE = "delete ";
    private static final String TYPE_REFRESH = "refresh ";
    private static final TypeReference<List<String>> STRING_LIST_TYPE_REFERENCE = new TypeReference<List<String>>(){};
    private static final String REGX_IP = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
    private static final String REGX_IPB = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\-((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
    private static final String LOCAL_IP = AggregateChannelListener.getLocalIp();

    public AggregateChannelListener(@Qualifier(value="aggregateReactiveRedisMessageListenerContainer") ReactiveRedisMessageListenerContainer reactiveRedisMessageListenerContainer, ConfigLoader configLoader) {
        this.reactiveRedisMessageListenerContainer = reactiveRedisMessageListenerContainer;
        this.configLoader = configLoader;
    }

    @PostConstruct
    public void init() {
        Flux aggregateMessageFlux = this.reactiveRedisMessageListenerContainer.receive(new ChannelTopic[]{ChannelTopic.of((String)AGGREGATE_CHANNEL)});
        this.disposable = aggregateMessageFlux.parallel().runOn(Schedulers.parallel()).subscribe(message -> {
            String messageBody = (String)message.getMessage();
            LOGGER.info("\u83b7\u53d6\u5230[{}]\u6d88\u606f[{}]", (Object)AGGREGATE_CHANNEL, (Object)messageBody);
            try {
                this.handleAggregateMessage(messageBody);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("\u5904\u7406\u805a\u5408\u63a8\u9001\u6570\u636e\u5f02\u5e38[%s]", message), (Throwable)e);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
    }

    private void handleAggregateMessage(String message) throws Exception {
        String data;
        String type;
        if (!StringUtils.hasText((String)message)) {
            return;
        }
        if (message.startsWith(TYPE_PUBLISH)) {
            type = TYPE_PUBLISH;
            data = message.replace(TYPE_PUBLISH, "");
        } else if (message.startsWith(TYPE_ROLLBACK)) {
            type = TYPE_ROLLBACK;
            data = message.replace(TYPE_ROLLBACK, "");
        } else if (message.startsWith(TYPE_TEST)) {
            type = TYPE_TEST;
            data = message.replace(TYPE_TEST, "");
        } else if (message.startsWith(TYPE_DELETE)) {
            type = TYPE_DELETE;
            data = message.replace(TYPE_DELETE, "");
        } else if (message.startsWith(TYPE_REFRESH)) {
            type = TYPE_REFRESH;
            data = message.replace(TYPE_REFRESH, "");
        } else {
            LOGGER.warn(String.format("\u672a\u77e5\u7684\u805a\u5408\u63a8\u9001\u6570\u636e[%s]", message));
            return;
        }
        switch (type) {
            case "publish ": 
            case "rollback ": 
            case "test ": {
                this.configLoader.addConfig(data);
                break;
            }
            case "delete ": {
                this.configLoader.deleteConfig(data);
                break;
            }
            case "refresh ": {
                this.refreshConfig(data);
                break;
            }
        }
    }

    private void refreshConfig(String allowIps) throws Exception {
        if (!this.checkIp(LOCAL_IP, allowIps)) {
            LOGGER.info("\u672c\u673aIP\u5730\u5740[{}]\u4e0d\u5728\u5237\u65b0IP\u5217\u8868[{}]\u4e2d", (Object)LOCAL_IP, (Object)allowIps);
            return;
        }
        this.configLoader.init();
    }

    private boolean checkIp(String clientIp, String allowIps) {
        if (!StringUtils.hasText((String)allowIps)) {
            return true;
        }
        List allowIpList = (List)JSON.parseObject((String)allowIps, STRING_LIST_TYPE_REFERENCE, (Feature[])new Feature[0]);
        for (String allowIp : allowIpList) {
            boolean allow = "*".equals(allowIp) || allowIp.equals(clientIp) || allowIp.contains("-") && AggregateChannelListener.ipIsValid(allowIp, clientIp);
            if (!allow) continue;
            return true;
        }
        return false;
    }

    private static boolean ipIsValid(String allowIp, String clientIp) {
        if (allowIp == null) {
            return false;
        }
        if (clientIp == null) {
            return false;
        }
        allowIp = allowIp.trim();
        clientIp = clientIp.trim();
        if (!allowIp.matches(REGX_IPB) || !clientIp.matches(REGX_IP)) {
            return false;
        }
        int idx = allowIp.indexOf(45);
        String[] sips = allowIp.substring(0, idx).split("\\.");
        String[] sipe = allowIp.substring(idx + 1).split("\\.");
        String[] sipt = clientIp.split("\\.");
        long ips = 0L;
        long ipe = 0L;
        long ipt = 0L;
        for (int i = 0; i < 4; ++i) {
            ips = ips << 8 | (long)Integer.parseInt(sips[i]);
            ipe = ipe << 8 | (long)Integer.parseInt(sipe[i]);
            ipt = ipt << 8 | (long)Integer.parseInt(sipt[i]);
        }
        if (ips > ipe) {
            long t = ips;
            ips = ipe;
            ipe = t;
        }
        return ips <= ipt && ipt <= ipe;
    }

    private static String getLocalIp() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (Exception e) {
            LOGGER.warn("\u83b7\u53d6\u672c\u5730IP\u5730\u5740\u5f02\u5e38", (Throwable)e);
            return "unknown";
        }
    }
}

