/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.log;

import com.alibaba.fastjson.JSON;
import com.fizzgate.config.AggregateRedisConfig;
import com.fizzgate.config.AggregateRedisConfigProperties;
import com.fizzgate.log.LogSend;
import com.fizzgate.log.LogSendService;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;

public class RedisLogSendServiceImpl
implements LogSendService {
    private AggregateRedisConfigProperties aggregateRedisConfigProperties;
    private AggregateRedisConfig aggregateRedisConfig;
    private ReactiveStringRedisTemplate reactiveStringRedisTemplate;

    public RedisLogSendServiceImpl(AggregateRedisConfigProperties aggregateRedisConfigProperties, AggregateRedisConfig aggregateRedisConfig, ReactiveStringRedisTemplate reactiveStringRedisTemplate) {
        this.aggregateRedisConfigProperties = aggregateRedisConfigProperties;
        this.aggregateRedisConfig = aggregateRedisConfig;
        this.reactiveStringRedisTemplate = reactiveStringRedisTemplate;
    }

    @Override
    public void send(LogSend logSend) {
        if (this.aggregateRedisConfigProperties.isSendLogOpen()) {
            this.reactiveStringRedisTemplate.convertAndSend(this.aggregateRedisConfigProperties.getSendLogChannel(), (Object)JSON.toJSONString((Object)logSend)).subscribe();
        }
    }
}

