/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.monitor;

import com.fizzgate.config.SchedConfig;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ThreadContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class FizzMonitorService
extends SchedConfig {
    private static final Logger MONITOR_LOGGER = LoggerFactory.getLogger((String)"monitor");
    private static final Logger LOGGER = LoggerFactory.getLogger(FizzMonitorService.class);
    public static final byte ERROR_ALARM = 1;
    public static final byte TIMEOUT_ALARM = 2;
    public static final byte RATE_LIMIT_ALARM = 3;
    public static final byte CIRCUIT_BREAK_ALARM = 4;
    @Value(value="${fizz.monitor.alarm.enable:true}")
    private boolean alarmEnable;
    @Value(value="${fizz.monitor.alarm.dest:redis}")
    private String dest;
    @Value(value="${fizz.monitor.alarm.queue:fizz_alarm_channel_new}")
    private String queue;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    private Map<Long, Map<Long, Map<String, Alarm>>> threadTimeWinAlarmMap = new HashMap<Long, Map<Long, Map<String, Alarm>>>();

    public void alarm(String service, String path, byte type, String desc) {
        if (this.alarmEnable) {
            String key;
            long currentTimeWinStart;
            Map alarmMap;
            Alarm alarm;
            long tid = Thread.currentThread().getId();
            LinkedHashMap<Long, Map<String, Alarm>> timeWinAlarmMap = this.threadTimeWinAlarmMap.get(tid);
            if (timeWinAlarmMap == null) {
                timeWinAlarmMap = new LinkedHashMap<Long, Map<String, Alarm>>(4, 1.0f){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry eldest) {
                        return this.size() > 2;
                    }
                };
                this.threadTimeWinAlarmMap.put(tid, (Map<Long, Map<String, Alarm>>)timeWinAlarmMap);
            }
            if ((alarm = (Alarm)(alarmMap = timeWinAlarmMap.computeIfAbsent(currentTimeWinStart = DateTimeUtils.get10sTimeWinStart((int)1), k -> new HashMap(128))).get(key = ThreadContext.getStringBuilder().append(service).append(path).append(type).toString())) == null) {
                alarm = new Alarm();
                alarm.service = service;
                alarm.path = path;
                alarm.type = type;
                alarmMap.put(key, alarm);
            }
            alarm.desc = desc;
            alarm.timestamp = System.currentTimeMillis();
            ++alarm.reqs;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update alarm: {} at {}", (Object)alarm, (Object)DateTimeUtils.convert((long)alarm.timestamp, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
    }

    @Scheduled(cron="${fizz.monitor.alarm.sched.cron:2/10 * * * * ?}")
    public void sched() {
        long prevTimeWinStart = DateTimeUtils.get10sTimeWinStart((int)2);
        HashMap alarmMap = ThreadContext.getHashMap();
        this.threadTimeWinAlarmMap.forEach((t, timeWinAlarmMap) -> {
            Map alarmMap0 = (Map)timeWinAlarmMap.get(prevTimeWinStart);
            if (alarmMap0 != null) {
                alarmMap0.forEach((spt, alarm) -> {
                    Alarm a = (Alarm)alarmMap.get(spt);
                    if (a == null) {
                        alarm.start = prevTimeWinStart;
                        alarmMap.put(spt, alarm);
                    } else {
                        a.reqs += alarm.reqs;
                        if (alarm.timestamp > a.timestamp) {
                            a.timestamp = alarm.timestamp;
                            a.desc = alarm.desc;
                        }
                    }
                });
            }
        });
        if (alarmMap.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no alarm in {} window", (Object)DateTimeUtils.convert((long)prevTimeWinStart, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        } else {
            alarmMap.forEach((spt, alarm) -> {
                String msg = alarm.toString();
                if ("kafka".equals(this.dest)) {
                    MONITOR_LOGGER.info(msg);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("send alarm {} which belong to {} window to topic", (Object)msg, (Object)DateTimeUtils.convert((long)alarm.start, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                } else {
                    this.rt.convertAndSend(this.queue, (Object)msg).subscribe();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("send alarm {} which belong to {} window to channel {}", new Object[]{msg, DateTimeUtils.convert((long)alarm.start, (String)"yyyy-MM-dd HH:mm:ss"), this.queue});
                    }
                }
            });
        }
    }

    private static class Alarm {
        public String service;
        public String path;
        public int type;
        public String desc;
        public long timestamp;
        public int reqs = 0;
        public long start;

        private Alarm() {
        }

        public String toString() {
            return JacksonUtils.writeValueAsString((Object)this);
        }
    }
}

