/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fizzgate.plugin.PluginConfig;
import com.fizzgate.plugin.auth.CallbackConfig;
import com.fizzgate.proxy.Route;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.UrlTransformUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class ApiConfig {
    public static final String ALL_METHOD = "AM";
    private static final String match_all = "/**";
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public int id;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public boolean isDeleted = false;
    public Set<String> gatewayGroups = Stream.of("default").collect(Collectors.toCollection(LinkedHashSet::new));
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public String firstGatewayGroup = "default";
    public String service;
    public String registryCenter;
    public String backendService;
    public Object fizzMethod = "AM";
    public String path = "/**";
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public boolean exactMatch = false;
    public String backendPath;
    public boolean dedicatedLine = false;
    @JsonProperty(value="proxyMode")
    public byte type = (byte)2;
    private int counter = 0;
    public List<String> httpHostPorts;
    public boolean allowAccess = true;
    public List<PluginConfig> pluginConfigs = Collections.emptyList();
    public boolean checkApp = false;
    public CallbackConfig callbackConfig;
    public String rpcMethod;
    public String rpcParamTypes;
    public String rpcVersion;
    public String rpcGroup;
    public long timeout = 20000L;
    public int retryCount = 0;
    public long retryInterval = 0L;

    public void setDeleted(int v) {
        if (v == 1) {
            this.isDeleted = true;
        }
    }

    public void setAccess(char c) {
        if (c != 'a') {
            this.allowAccess = false;
        }
    }

    public void setGatewayGroup(String ggs) {
        this.gatewayGroups.remove("default");
        if (StringUtils.isBlank((CharSequence)ggs)) {
            this.gatewayGroups.add("*");
        } else {
            Arrays.stream(StringUtils.split((String)ggs, (char)',')).forEach(gg -> this.gatewayGroups.add(gg.trim()));
        }
        this.firstGatewayGroup = this.gatewayGroups.iterator().next();
    }

    @JsonProperty(value="registryName")
    public void setRegistryCenter(String rc) {
        if (StringUtils.isNotBlank((CharSequence)rc)) {
            this.registryCenter = rc.equals("default") ? "default" : rc;
        }
    }

    public void setPath(String p) {
        if (StringUtils.isNotBlank((CharSequence)p)) {
            if ("/".equals(p)) {
                this.path = match_all;
            } else {
                this.path = p.trim();
                if (!UrlTransformUtils.isAntPathPattern((String)this.path)) {
                    this.exactMatch = true;
                }
            }
        } else {
            this.path = match_all;
        }
    }

    public void setMethod(String m) {
        this.fizzMethod = HttpMethod.resolve((String)m);
        if (this.fizzMethod == null) {
            this.fizzMethod = ALL_METHOD;
        }
    }

    public void setAppEnable(int v) {
        if (v == 1) {
            this.checkApp = true;
        }
    }

    public void setDedicatedLine(int v) {
        if (v == 1) {
            this.dedicatedLine = true;
        }
    }

    @JsonIgnore
    public String getNextHttpHostPort() {
        int i;
        if ((i = this.counter++) < 0) {
            i = Math.abs(i);
        }
        return this.httpHostPorts.get(i % this.httpHostPorts.size());
    }

    public String transform(String reqPath) {
        if (this.exactMatch) {
            return this.backendPath;
        }
        return UrlTransformUtils.transform((String)this.path, (String)this.backendPath, (String)reqPath);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o instanceof ApiConfig) {
            ApiConfig that = (ApiConfig)o;
            return this.id == that.id;
        }
        return false;
    }

    public Route getRoute(ServerWebExchange exchange, @Nullable List<PluginConfig> gatewayGroupPluginConfigs) {
        ServerHttpRequest request = exchange.getRequest();
        Route r = new Route().dedicatedLine(this.dedicatedLine).type(this.type).method(request.getMethod()).path(this.path).registryCenter(this.registryCenter).backendService(this.backendService).backendPath(this.backendPath).rpcMethod(this.rpcMethod).rpcParamTypes(this.rpcParamTypes).rpcGroup(this.rpcGroup).rpcVersion(this.rpcVersion).timeout(this.timeout).retryCount(this.retryCount).retryInterval(this.retryInterval);
        if (gatewayGroupPluginConfigs == null || gatewayGroupPluginConfigs.isEmpty()) {
            r.pluginConfigs = this.pluginConfigs;
        } else {
            ArrayList<PluginConfig> pcs = new ArrayList<PluginConfig>(gatewayGroupPluginConfigs.size() + this.pluginConfigs.size());
            pcs.addAll(gatewayGroupPluginConfigs);
            pcs.addAll(this.pluginConfigs);
            pcs.sort(null);
            r.pluginConfigs = pcs;
        }
        if (this.type == 3) {
            r = r.nextHttpHostPort(this.getNextHttpHostPort());
        }
        return r;
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }

    public static interface Type {
        public static final byte UNDEFINED = 0;
        public static final byte SERVICE_AGGREGATE = 1;
        public static final byte SERVICE_DISCOVERY = 2;
        public static final byte REVERSE_PROXY = 3;
        public static final byte CALLBACK = 4;
        public static final byte DUBBO = 5;
        public static final byte DIRECT_RESPONSE = 6;
    }
}

