/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fizzgate.plugin.auth.ApiConfig2apps;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReactorUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ApiConfig2appsService {
    private static final Logger log = LoggerFactory.getLogger(ApiConfig2appsService.class);
    private static final String fizzApiConfigAppSetSize = "fizz_api_config_app_set_size";
    private static final String fizzApiConfigAppKeyPrefix = "fizz_api_config_app:";
    private static final String fizzApiConfigAppChannel = "fizz_api_config_app_channel";
    private Map<Integer, Set<String>> apiConfig2appsMap = new HashMap<Integer, Set<String>>(128);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;

    @PostConstruct
    public void init() throws Throwable {
        this.init(this::lsnChannel);
    }

    public void refreshLocalCache() throws Throwable {
        this.init(null);
    }

    private void init(Runnable doAfterLoadCache) throws Throwable {
        HashMap apiConfig2appsMapTmp = new HashMap(128);
        this.rt.opsForHash().entries((Object)fizzApiConfigAppSetSize).collectList().map(es -> {
            this.log((List<Map.Entry<Object, Object>>)es);
            Mono initiateFlux = ReactorUtils.getInitiateMono();
            for (Map.Entry e : es) {
                Integer apiConfigId = Integer.parseInt((String)e.getKey());
                int appSetCount = Integer.parseInt((String)e.getValue());
                int i = 0;
                while (i < appSetCount) {
                    int iFinal = i++;
                    initiateFlux = initiateFlux.flatMap(o -> this.rt.opsForSet().members((Object)(fizzApiConfigAppKeyPrefix + apiConfigId + '_' + iFinal)).collectList().map(as -> {
                        this.save(apiConfigId, (List<String>)as, apiConfig2appsMapTmp);
                        return ReactorUtils.NULL;
                    }));
                }
            }
            return initiateFlux;
        }).subscribe(m -> m.subscribe(e -> {
            this.apiConfig2appsMap = apiConfig2appsMapTmp;
            if (doAfterLoadCache != null) {
                doAfterLoadCache.run();
            }
        }));
    }

    private void log(List<Map.Entry<Object, Object>> es) {
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        b.append(fizzApiConfigAppSetSize).append('\n');
        for (Map.Entry<Object, Object> e : es) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            b.append(key).append(":").append(value).append(' ');
        }
        log.info(b.toString());
    }

    private void save(Integer apiConfigId, List<String> as, Map<Integer, Set<String>> apiConfig2appsMap) {
        Set appSet = apiConfig2appsMap.computeIfAbsent(apiConfigId, k -> new HashSet());
        appSet.addAll(as);
        this.log(apiConfigId, as);
    }

    private void log(Integer apiConfigId, List<String> apps) {
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        b.append(apiConfigId).append(" add: ");
        for (String a : apps) {
            b.append(a).append(' ');
        }
        log.info(b.toString());
    }

    private void lsnChannel() {
        this.rt.listenToChannel(new String[]{fizzApiConfigAppChannel}).doOnError(t -> log.error("lsn api config 2 apps channel", t)).doOnComplete(() -> log.info("success to lsn on api config 2 apps channel")).doOnNext(msg -> {
            String json = (String)msg.getMessage();
            ThreadContext.put((String)"traceId", (String)("ac2as" + System.currentTimeMillis()));
            log.info("apiConfig2apps: " + json);
            try {
                ApiConfig2apps data = (ApiConfig2apps)JacksonUtils.readValue((String)json, ApiConfig2apps.class);
                this.updateApiConfig2appsMap(data);
            }
            catch (Throwable t) {
                log.error("", t);
            }
        }).subscribe();
    }

    private void updateApiConfig2appsMap(ApiConfig2apps data) {
        Set<String> apps = this.apiConfig2appsMap.get(data.id);
        if (data.isDeleted) {
            if (apps != null) {
                data.apps.forEach(apps::remove);
                log.info("remove " + data);
            }
        } else {
            if (apps == null) {
                apps = new HashSet<String>(32);
                this.apiConfig2appsMap.put(data.id, apps);
            }
            apps.addAll(data.apps);
            log.info("add " + data);
        }
    }

    public boolean contains(int api, String app) {
        Set<String> apps = this.apiConfig2appsMap.get(api);
        if (apps == null) {
            return false;
        }
        return apps.contains(app);
    }

    public Set<String> remove(int id) {
        return this.apiConfig2appsMap.remove(id);
    }

    public Map<Integer, Set<String>> getApiConfig2appsMap() {
        return this.apiConfig2appsMap;
    }
}

