/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.plugin.FizzPluginFilter;
import com.fizzgate.plugin.auth.AbstractCustomAuth;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.plugin.auth.ApiConfig2appsService;
import com.fizzgate.plugin.auth.ApiConfigServiceProperties;
import com.fizzgate.plugin.auth.App;
import com.fizzgate.plugin.auth.AppService;
import com.fizzgate.plugin.auth.CustomAuth;
import com.fizzgate.plugin.auth.GatewayGroupService;
import com.fizzgate.plugin.auth.ServiceConfig;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.DigestUtils;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReactorUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.WebUtils;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ApiConfigService
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApiConfigService.class);
    public Map<String, ServiceConfig> serviceConfigMap = new HashMap<String, ServiceConfig>(128);
    private Map<Integer, ApiConfig> apiConfigMap = new HashMap<Integer, ApiConfig>(128);
    private Map<String, String> pluginConfigMap = new HashMap<String, String>(32);
    @Resource
    private ReactiveWebServerApplicationContext applicationContext;
    @Resource
    private ApiConfigServiceProperties apiConfigServiceProperties;
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Resource
    private AppService appService;
    @Resource
    private ApiConfig2appsService apiConfig2AppsService;
    @Resource
    private GatewayGroupService gatewayGroupService;
    @Resource
    private SystemConfig systemConfig;
    @Autowired(required=false)
    private CustomAuth customAuth;

    @PostConstruct
    public void init() throws Throwable {
        this.init(this::lsnApiConfigChange);
    }

    public void refreshLocalCache() throws Throwable {
        this.init(null);
        this.initPlugin();
    }

    private void init(Supplier<Mono<Throwable>> doAfterLoadCache) throws Throwable {
        HashMap<Integer, ApiConfig> apiConfigMapTmp = new HashMap<Integer, ApiConfig>(128);
        HashMap<String, ServiceConfig> serviceConfigMapTmp = new HashMap<String, ServiceConfig>(128);
        Throwable[] throwable = new Throwable[1];
        Throwable error = (Throwable)Mono.just((Object)Objects.requireNonNull(this.rt.opsForHash().entries((Object)this.apiConfigServiceProperties.getFizzApiConfig()).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(t -> log.info(null, t)).concatMap(e -> {
            Object k = e.getKey();
            if (k == ReactorUtils.OBJ) {
                return Flux.just((Object)e);
            }
            String json = (String)e.getValue();
            ThreadContext.put((String)"traceId", (String)k.toString());
            log.info("init api config: {}", (Object)json);
            try {
                ApiConfig ac = (ApiConfig)JacksonUtils.readValue((String)json, ApiConfig.class);
                apiConfigMapTmp.put(ac.id, ac);
                this.updateServiceConfigMap(ac, serviceConfigMapTmp);
                return Flux.just((Object)e);
            }
            catch (Throwable t) {
                throwable[0] = t;
                log.error("deser {}", (Object)json, (Object)t);
                return Flux.error((Throwable)t);
            }
        }).blockLast())).flatMap(e -> {
            if (throwable[0] != null) {
                return Mono.error((Throwable)throwable[0]);
            }
            if (doAfterLoadCache != null) {
                return (Mono)doAfterLoadCache.get();
            }
            return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
        }).block();
        if (error != ReactorUtils.EMPTY_THROWABLE) {
            throw error;
        }
        this.apiConfigMap = apiConfigMapTmp;
        this.serviceConfigMap = serviceConfigMapTmp;
    }

    private Mono<Throwable> lsnApiConfigChange() {
        Throwable[] throwable = new Throwable[1];
        boolean[] b = new boolean[]{false};
        String ch = this.apiConfigServiceProperties.getFizzApiConfigChannel();
        this.rt.listenToChannel(new String[]{ch}).doOnError(t -> {
            throwable[0] = t;
            b[0] = false;
            log.error("lsn {}", (Object)ch, t);
        }).doOnSubscribe(s -> {
            b[0] = true;
            log.info("success to lsn on {}", (Object)ch);
        }).doOnNext(msg -> {
            String json = (String)msg.getMessage();
            ThreadContext.put((String)"traceId", (String)("acc" + System.currentTimeMillis()));
            log.info("api config change: {}", (Object)json);
            try {
                ApiConfig ac = (ApiConfig)JacksonUtils.readValue((String)json, ApiConfig.class);
                ApiConfig r = this.apiConfigMap.remove(ac.id);
                if (!ac.isDeleted && r != null) {
                    r.isDeleted = true;
                    this.updateServiceConfigMap(r, this.serviceConfigMap);
                }
                this.updateServiceConfigMap(ac, this.serviceConfigMap);
                if (!ac.isDeleted) {
                    this.apiConfigMap.put(ac.id, ac);
                } else {
                    this.apiConfig2AppsService.remove(ac.id);
                }
            }
            catch (Throwable t) {
                log.error("deser {}", (Object)json, (Object)t);
            }
        }).subscribe();
        Throwable t2 = throwable[0];
        while (!b[0]) {
            if (t2 != null) {
                return Mono.error((Throwable)t2);
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
    }

    private Result<?> initPlugin() {
        Result result = Result.succ();
        String key = this.apiConfigServiceProperties.getFizzPluginConfig();
        Flux plugins = this.rt.opsForHash().entries((Object)key);
        plugins.collectList().defaultIfEmpty(Collections.emptyList()).flatMap(es -> {
            if (!es.isEmpty()) {
                String json = null;
                try {
                    for (Map.Entry e : es) {
                        json = (String)e.getValue();
                        HashMap map = (HashMap)JacksonUtils.readValue((String)json, HashMap.class);
                        String plugin = (String)map.get("plugin");
                        String pluginConfig = (String)map.get("fixedConfig");
                        String currentPluginConfig = this.pluginConfigMap.get(plugin);
                        if (currentPluginConfig != null && currentPluginConfig.equals(pluginConfig)) continue;
                        if (this.applicationContext.containsBean(plugin)) {
                            FizzPluginFilter pluginFilter = (FizzPluginFilter)this.applicationContext.getBean(plugin);
                            pluginFilter.init(pluginConfig);
                            this.pluginConfigMap.put(plugin, pluginConfig);
                            log.info("init plugin {} with {}", (Object)plugin, (Object)pluginConfig);
                            continue;
                        }
                        log.warn("no {} bean", (Object)plugin);
                    }
                }
                catch (Throwable t) {
                    result.code = 0;
                    result.msg = "init plugin error, config: " + json;
                    result.t = t;
                }
            } else {
                log.info("no plugin init");
            }
            return Mono.empty();
        }).onErrorReturn(throwable -> {
            result.code = 0;
            result.msg = "init plugin error";
            result.t = throwable;
            return true;
        }, (Object)result).block();
        return result;
    }

    private Result<?> lsnPluginConfigChange() {
        Result result = Result.succ();
        String channel = this.apiConfigServiceProperties.getFizzPluginConfigChannel();
        this.rt.listenToChannel(new String[]{channel}).doOnError(t -> {
            result.code = 0;
            result.msg = "lsn error, channel: " + channel;
            result.t = t;
            log.error("lsn channel {} error", (Object)channel, t);
        }).doOnSubscribe(s -> log.info("success to lsn on {}", (Object)channel)).doOnNext(msg -> {
            String message = (String)msg.getMessage();
            try {
                HashMap map = (HashMap)JacksonUtils.readValue((String)message, HashMap.class);
                String plugin = (String)map.get("plugin");
                String pluginConfig = (String)map.get("fixedConfig");
                String currentPluginConfig = this.pluginConfigMap.get(plugin);
                if (currentPluginConfig == null || !currentPluginConfig.equals(pluginConfig)) {
                    if (this.applicationContext.containsBean(plugin)) {
                        FizzPluginFilter pluginFilter = (FizzPluginFilter)this.applicationContext.getBean(plugin);
                        pluginFilter.init(pluginConfig);
                        this.pluginConfigMap.put(plugin, pluginConfig);
                        log.info("init {} with {} again", (Object)plugin, (Object)pluginConfig);
                    } else {
                        log.warn("no {} bean", (Object)plugin);
                    }
                }
            }
            catch (Throwable t) {
                log.error("message: {}", (Object)message, (Object)t);
            }
        }).subscribe();
        return result;
    }

    public void updateServiceConfigMap(ApiConfig ac, Map<String, ServiceConfig> serviceConfigMap) {
        ServiceConfig sc = serviceConfigMap.get(ac.service);
        if (ac.isDeleted) {
            if (sc != null) {
                sc.remove(ac);
                if (sc.apiConfigMap.isEmpty()) {
                    serviceConfigMap.remove(ac.service);
                }
            }
        } else if (sc == null) {
            sc = new ServiceConfig(ac.service);
            serviceConfigMap.put(ac.service, sc);
            sc.add(ac);
        } else {
            sc.update(ac);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Result<?> result = this.initPlugin();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
        result = this.lsnPluginConfigChange();
        if (result.code == 0) {
            throw new RuntimeException(result.msg, result.t);
        }
    }

    public Map<Integer, ApiConfig> getApiConfigMap() {
        return this.apiConfigMap;
    }

    public ApiConfig getApiConfig(String app, String service, HttpMethod method, String path) {
        Result<ApiConfig> result = this.get(false, null, app, service, method, path);
        if (result.code == 1) {
            return (ApiConfig)result.data;
        }
        return null;
    }

    public Result<ApiConfig> get(boolean dedicatedLineRequest, String app, String service, HttpMethod method, String path) {
        return this.get(dedicatedLineRequest, null, app, service, method, path);
    }

    public ApiConfig getApiConfig(Set<String> gatewayGroups, String app, String service, HttpMethod method, String path) {
        Result<ApiConfig> result = this.get(false, null, app, service, method, path);
        if (result.code == 1) {
            return (ApiConfig)result.data;
        }
        return null;
    }

    public Result<ApiConfig> get(boolean dedicatedLineRequest, Set<String> gatewayGroups, String app, String service, HttpMethod method, String path) {
        List<ApiConfig> apiConfigs;
        ServiceConfig sc = this.serviceConfigMap.get(service);
        if (sc == null) {
            return Result.fail((String)("no " + service + " service api config"));
        }
        if (CollectionUtils.isEmpty(gatewayGroups)) {
            gatewayGroups = this.gatewayGroupService.currentGatewayGroupSet;
        }
        if ((apiConfigs = sc.getApiConfigs(dedicatedLineRequest, gatewayGroups, method, path)).isEmpty()) {
            StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
            b.append(service).append(" don't have api config matching ").append(gatewayGroups).append(" group ").append(method).append(" method ").append(path).append(" path");
            return Result.fail((String)b.toString());
        }
        ArrayList clientCanAccess = com.fizzgate.util.ThreadContext.getArrayList();
        for (int i = 0; i < apiConfigs.size(); ++i) {
            ApiConfig ac = apiConfigs.get(i);
            if (!dedicatedLineRequest && ac.checkApp) {
                if (!StringUtils.isNotBlank((CharSequence)app) || !this.apiConfig2AppsService.contains(ac.id, app)) continue;
                clientCanAccess.add(ac);
                continue;
            }
            clientCanAccess.add(ac);
        }
        if (clientCanAccess.isEmpty()) {
            StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
            b.append("app ").append(app).append(" can't access matching routes");
            return Result.fail((String)b.toString());
        }
        ApiConfig bestOne = (ApiConfig)clientCanAccess.get(0);
        if (clientCanAccess.size() != 1) {
            ApiConfig ac0;
            clientCanAccess.sort(new ApiConfigPathPatternComparator(path));
            bestOne = ac0 = (ApiConfig)clientCanAccess.get(0);
            ApiConfig ac1 = (ApiConfig)clientCanAccess.get(1);
            if (ac0.path.equals(ac1.path)) {
                if (ac0.fizzMethod == ac1.fizzMethod) {
                    if (StringUtils.isNotBlank((CharSequence)app) && !ac0.checkApp) {
                        bestOne = ac1;
                    }
                } else if (ac0.fizzMethod == "AM") {
                    bestOne = ac1;
                }
            }
        }
        if (bestOne.allowAccess) {
            return Result.succ((Object)bestOne);
        }
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        b.append("app ").append(app).append(" can't access matching route");
        return Result.fail((String)b.toString());
    }

    public Mono<Result<ApiConfig>> auth(ServerWebExchange exchange) {
        ServerHttpRequest req = exchange.getRequest();
        ThreadContext.put((String)"traceId", (String)WebUtils.getTraceId(exchange));
        boolean dedicatedLineRequest = WebUtils.isDedicatedLineRequest(exchange);
        return this.auth(exchange, dedicatedLineRequest, WebUtils.getAppId(exchange), WebUtils.getOriginIp(exchange), WebUtils.getTimestamp(exchange), WebUtils.getSign(exchange), WebUtils.getClientService(exchange), req.getMethod(), WebUtils.getClientReqPath(exchange));
    }

    private Mono<Result<ApiConfig>> auth(ServerWebExchange exchange, boolean dedicatedLineRequest, String app, String ip, String timestamp, String sign, String service, HttpMethod method, String path) {
        if (!this.systemConfig.isAggregateTestAuth() && "/_proxytest/".equals(WebUtils.getClientReqPathPrefix(exchange))) {
            return Mono.just((Object)Result.succ());
        }
        Result<ApiConfig> r = this.get(dedicatedLineRequest, app, service, method, path);
        if (r.code == 0) {
            if (this.apiConfigServiceProperties.isNeedAuth()) {
                return Mono.just(r);
            }
            return Mono.just((Object)Result.succ());
        }
        ApiConfig ac = (ApiConfig)r.data;
        if (!dedicatedLineRequest && ac.checkApp) {
            App a = this.appService.getApp(app);
            if (a.useWhiteList && !a.allow(ip)) {
                r.code = 0;
                r.msg = ip + " not in " + app + " app white list";
                return Mono.just(r);
            }
            if (a.useAuth) {
                if (a.authType == 1) {
                    return this.authSign(a, timestamp, sign, r);
                }
                if (a.authType == 3) {
                    return this.authSecretKey(a, sign, r);
                }
                if (this.customAuth == null) {
                    r.code = 0;
                    r.msg = "no custom auth bean for " + app;
                    return Mono.just(r);
                }
                if (this.customAuth instanceof AbstractCustomAuth) {
                    AbstractCustomAuth abstractCustomAuth = (AbstractCustomAuth)this.customAuth;
                    return abstractCustomAuth.auth(app, ip, timestamp, sign, a, exchange).flatMap(res -> {
                        if (res.code == 0) {
                            r.code = res.code;
                            r.msg = res.msg;
                        }
                        return Mono.just((Object)r);
                    });
                }
                return this.customAuth.auth(exchange, app, ip, timestamp, sign, a).flatMap(v -> {
                    if (v == Access.YES) {
                        return Mono.just((Object)r);
                    }
                    r.code = 0;
                    r.msg = v.getReason();
                    return Mono.just((Object)r);
                });
            }
        }
        return Mono.just(r);
    }

    private Mono<Result<ApiConfig>> authSign(App a, String timestamp, String sign, Result<ApiConfig> r) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{timestamp, sign})) {
            r.code = 0;
            r.msg = a.app + " not present timestamp " + timestamp + " or sign " + sign;
        } else {
            long ts = Long.parseLong(timestamp);
            LocalDateTime now = LocalDateTime.now();
            long timeliness = this.systemConfig.fizzMD5signTimestampTimeliness();
            long start = DateTimeUtils.toMillis((LocalDateTime)now.minusSeconds(timeliness));
            long end = DateTimeUtils.toMillis((LocalDateTime)now.plusSeconds(timeliness));
            if (start <= ts && ts <= end) {
                StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
                b.append(a.app).append('_').append(timestamp).append('_').append(a.secretkey);
                if (!sign.equalsIgnoreCase(DigestUtils.md532((String)b.toString()))) {
                    r.code = 0;
                    r.msg = a.app + " sign " + sign + " invalid";
                }
            } else {
                r.code = 0;
                r.msg = a.app + " timestamp " + timestamp + " invalid";
            }
        }
        return Mono.just(r);
    }

    private Mono<Result<ApiConfig>> authSecretKey(App a, String sign, Result<ApiConfig> r) {
        if (StringUtils.isBlank((CharSequence)sign)) {
            r.code = 0;
            r.msg = a.app + " not present secret key " + sign;
        } else if (!a.secretkey.equals(sign)) {
            r.code = 0;
            r.msg = a.app + " secret key " + sign + " invalid";
        }
        return Mono.just(r);
    }

    private static class ApiConfigPathPatternComparator
    implements Comparator<ApiConfig> {
        private final String path;

        public ApiConfigPathPatternComparator(String path) {
            this.path = path;
        }

        @Override
        public int compare(ApiConfig ac1, ApiConfig ac2) {
            String pattern1 = ac1.path;
            String pattern2 = ac2.path;
            PatternInfo info1 = new PatternInfo(pattern1);
            PatternInfo info2 = new PatternInfo(pattern2);
            if (info1.isLeastSpecific() && info2.isLeastSpecific()) {
                return 0;
            }
            if (info1.isLeastSpecific()) {
                return 1;
            }
            if (info2.isLeastSpecific()) {
                return -1;
            }
            boolean pattern1EqualsPath = pattern1.equals(this.path);
            boolean pattern2EqualsPath = pattern2.equals(this.path);
            if (pattern1EqualsPath && pattern2EqualsPath) {
                return 0;
            }
            if (pattern1EqualsPath) {
                return -1;
            }
            if (pattern2EqualsPath) {
                return 1;
            }
            if (info1.isPrefixPattern() && info2.isPrefixPattern()) {
                return info2.getLength() - info1.getLength();
            }
            if (info1.isPrefixPattern() && info2.getDoubleWildcards() == 0) {
                return 1;
            }
            if (info2.isPrefixPattern() && info1.getDoubleWildcards() == 0) {
                return -1;
            }
            if (info1.getTotalCount() != info2.getTotalCount()) {
                return info1.getTotalCount() - info2.getTotalCount();
            }
            if (info1.getLength() != info2.getLength()) {
                return info2.getLength() - info1.getLength();
            }
            if (info1.getSingleWildcards() < info2.getSingleWildcards()) {
                return -1;
            }
            if (info2.getSingleWildcards() < info1.getSingleWildcards()) {
                return 1;
            }
            if (info1.getUriVars() < info2.getUriVars()) {
                return -1;
            }
            if (info2.getUriVars() < info1.getUriVars()) {
                return 1;
            }
            return 0;
        }

        private static class PatternInfo {
            private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?}");
            @Nullable
            private final String pattern;
            private int uriVars;
            private int singleWildcards;
            private int doubleWildcards;
            private boolean catchAllPattern;
            private boolean prefixPattern;
            @Nullable
            private Integer length;

            public PatternInfo(@Nullable String pattern) {
                this.pattern = pattern;
                if (this.pattern != null) {
                    this.initCounters();
                    this.catchAllPattern = this.pattern.equals("/**");
                    boolean bl = this.prefixPattern = !this.catchAllPattern && this.pattern.endsWith("/**");
                }
                if (this.uriVars == 0) {
                    this.length = this.pattern != null ? this.pattern.length() : 0;
                }
            }

            protected void initCounters() {
                int pos = 0;
                if (this.pattern != null) {
                    while (pos < this.pattern.length()) {
                        if (this.pattern.charAt(pos) == '{') {
                            ++this.uriVars;
                            ++pos;
                            continue;
                        }
                        if (this.pattern.charAt(pos) == '*') {
                            if (pos + 1 < this.pattern.length() && this.pattern.charAt(pos + 1) == '*') {
                                ++this.doubleWildcards;
                                pos += 2;
                                continue;
                            }
                            if (pos > 0 && !this.pattern.substring(pos - 1).equals(".*")) {
                                ++this.singleWildcards;
                                ++pos;
                                continue;
                            }
                            ++pos;
                            continue;
                        }
                        ++pos;
                    }
                }
            }

            public int getUriVars() {
                return this.uriVars;
            }

            public int getSingleWildcards() {
                return this.singleWildcards;
            }

            public int getDoubleWildcards() {
                return this.doubleWildcards;
            }

            public boolean isLeastSpecific() {
                return this.pattern == null || this.catchAllPattern;
            }

            public boolean isPrefixPattern() {
                return this.prefixPattern;
            }

            public int getTotalCount() {
                return this.uriVars + this.singleWildcards + 2 * this.doubleWildcards;
            }

            public int getLength() {
                if (this.length == null) {
                    this.length = this.pattern != null ? VARIABLE_PATTERN.matcher(this.pattern).replaceAll("#").length() : 0;
                }
                return this.length;
            }
        }
    }

    @Deprecated
    public static enum Access {
        YES(null),
        IP_NOT_IN_WHITE_LIST("ip not in white list"),
        NO_TIMESTAMP_OR_SIGN("no timestamp or sign"),
        NO_SECRETKEY("no secretkey"),
        SIGN_INVALID("sign invalid"),
        SECRETKEY_INVALID("secretkey invalid"),
        NO_CUSTOM_AUTH("no custom auth"),
        CUSTOM_AUTH_REJECT("custom auth reject");

        private String reason;

        private Access(String r) {
            this.reason = r;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

