/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fizzgate.util.JacksonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class App {
    public static final String ALL_APP = "*";
    public boolean isDeleted = false;
    public int id;
    public String app;
    public String name;
    public boolean useAuth = false;
    public int authType;
    public String secretkey;
    public boolean useWhiteList = false;
    public String config;
    public Map<String, List<String[]>> ips = new HashMap<String, List<String[]>>();

    public void setDeleted(int v) {
        if (v == 1) {
            this.isDeleted = true;
        }
    }

    public void setUseAuth(int i) {
        if (i == 1 || i == 3 || i == 2) {
            this.useAuth = true;
        }
    }

    public void setUseWhiteList(int i) {
        if (i == 1) {
            this.useWhiteList = true;
        }
    }

    public void setIps(String ips) {
        if (StringUtils.isNotBlank((CharSequence)ips)) {
            Arrays.stream(StringUtils.split((String)ips, (char)',')).forEach(ip -> {
                ip = ip.trim();
                int i = ip.lastIndexOf(46);
                String subnet = ip.substring(0, i).trim();
                String addrSeg = ip.substring(i + 1).trim();
                if (ALL_APP.equals(addrSeg)) {
                    List segs = this.ips.computeIfAbsent(subnet, k -> new ArrayList());
                    segs.add(new String[]{"1", "255"});
                } else if (addrSeg.indexOf(45) > 0) {
                    String[] a = StringUtils.split((String)addrSeg, (char)'-');
                    String beg = a[0].trim();
                    String end = a[1].trim();
                    List lst = this.ips.computeIfAbsent(subnet, k -> new ArrayList());
                    lst.add(new String[]{beg, end});
                } else {
                    this.ips.put((String)ip, (List<String[]>)null);
                }
            });
        }
    }

    public boolean allow(String ip) {
        if (this.ips.containsKey(ip)) {
            return true;
        }
        int originSubnetLen = ip.lastIndexOf(46);
        for (Map.Entry<String, List<String[]>> e : this.ips.entrySet()) {
            int i;
            String subnet = e.getKey();
            int subnetLen = subnet.length();
            if (subnetLen != originSubnetLen) continue;
            for (i = 0; i < subnetLen && subnet.charAt(i) == ip.charAt(i); i = (int)((byte)(i + 1))) {
            }
            if (i != subnetLen) continue;
            int originAddrLen = ip.length() - originSubnetLen - 1;
            boolean in = false;
            for (String[] addrSeg : e.getValue()) {
                in = this.inAddrSeg(ip, originSubnetLen, originAddrLen, addrSeg);
                if (!in) continue;
                return in;
            }
            return in;
        }
        return false;
    }

    private boolean inAddrSeg(String ip, int originSubnetLen, int originAddrLen, String[] addrSeg) {
        int j;
        String addrSegBeg = addrSeg[0];
        String addrSegEnd = addrSeg[1];
        if (originAddrLen < addrSegBeg.length() || addrSegEnd.length() < originAddrLen) {
            return false;
        }
        boolean b = true;
        if (originAddrLen == addrSegBeg.length()) {
            for (j = 0; j < addrSegBeg.length(); j = (int)((byte)(j + 1))) {
                char a;
                char o = ip.charAt(originSubnetLen + 1 + j);
                if (o < (a = addrSegBeg.charAt(j))) {
                    b = false;
                    break;
                }
                if (o > a) break;
            }
        }
        if (b && originAddrLen == addrSegEnd.length()) {
            for (j = 0; j < addrSegEnd.length(); j = (int)((byte)(j + 1))) {
                char o;
                char a = addrSegEnd.charAt(j);
                if (a < (o = ip.charAt(originSubnetLen + 1 + j))) {
                    b = false;
                    break;
                }
                if (a > o) break;
            }
        }
        return b;
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }

    static interface AUTH_TYPE {
        public static final int SIGN = 1;
        public static final int CUSTOM = 2;
        public static final int SECRET_KEY = 3;
    }
}

