/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fizzgate.plugin.auth.App;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.ReactorUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AppService {
    private static final Logger log = LoggerFactory.getLogger(AppService.class);
    private static final String fizzApp = "fizz_app";
    private static final String fizzAppChannel = "fizz_app_channel";
    private Map<String, App> appMap = new HashMap<String, App>(32);
    private Map<Integer, App> oldAppMap = new HashMap<Integer, App>(32);
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;

    @PostConstruct
    public void init() throws Throwable {
        this.init(this::lsnAppChange);
    }

    public void refreshLocalCache() throws Throwable {
        this.init(null);
    }

    private void init(Supplier<Mono<Throwable>> doAfterLoadCache) throws Throwable {
        HashMap<String, App> appMapTmp = new HashMap<String, App>(32);
        HashMap<Integer, App> oldAppMapTmp = new HashMap<Integer, App>(32);
        Throwable[] throwable = new Throwable[1];
        Throwable error = (Throwable)Mono.just((Object)Objects.requireNonNull(this.rt.opsForHash().entries((Object)fizzApp).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(t -> log.info(null, t)).concatMap(e -> {
            Object k = e.getKey();
            if (k == ReactorUtils.OBJ) {
                return Flux.just((Object)e);
            }
            String json = (String)e.getValue();
            ThreadContext.put((String)"traceId", (String)k.toString());
            log.info("init app: {}", (Object)json);
            try {
                App app = (App)JacksonUtils.readValue((String)json, App.class);
                oldAppMapTmp.put(app.id, app);
                this.updateAppMap(app, appMapTmp);
                return Flux.just((Object)e);
            }
            catch (Throwable t) {
                log.warn(json, t);
                return Flux.just((Object)e);
            }
        }).blockLast())).flatMap(e -> {
            if (throwable[0] != null) {
                return Mono.error((Throwable)throwable[0]);
            }
            if (doAfterLoadCache != null) {
                return (Mono)doAfterLoadCache.get();
            }
            return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
        }).block();
        if (error != ReactorUtils.EMPTY_THROWABLE) {
            log.error("", error);
        }
        this.appMap = appMapTmp;
        this.oldAppMap = oldAppMapTmp;
    }

    private Mono<Throwable> lsnAppChange() {
        Throwable[] throwable = new Throwable[1];
        boolean[] b = new boolean[]{false};
        this.rt.listenToChannel(new String[]{fizzAppChannel}).doOnError(t -> {
            throwable[0] = t;
            b[0] = false;
            log.error("lsn fizz_app_channel", t);
        }).doOnSubscribe(s -> {
            b[0] = true;
            log.info("success to lsn on fizz_app_channel");
        }).doOnNext(msg -> {
            String json = (String)msg.getMessage();
            ThreadContext.put((String)"traceId", (String)("ac" + System.currentTimeMillis()));
            log.info("app change: " + json);
            try {
                App app = (App)JacksonUtils.readValue((String)json, App.class);
                App r = this.oldAppMap.remove(app.id);
                if (!app.isDeleted && r != null) {
                    this.appMap.remove(r.app);
                }
                this.updateAppMap(app, this.appMap);
                if (!app.isDeleted) {
                    this.oldAppMap.put(app.id, app);
                }
            }
            catch (Throwable t) {
                log.info(json, t);
            }
        }).subscribe();
        Throwable t2 = throwable[0];
        while (!b[0]) {
            if (t2 != null) {
                return Mono.error((Throwable)t2);
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
    }

    private void updateAppMap(App app, Map<String, App> appMap) {
        if (app.isDeleted) {
            App removedApp = appMap.remove(app.app);
            log.info("remove " + removedApp);
        } else {
            App existApp = appMap.get(app.app);
            appMap.put(app.app, app);
            if (existApp == null) {
                log.info("add " + app);
            } else {
                log.info("update " + existApp + " with " + app);
            }
        }
    }

    public App getApp(String app) {
        return this.appMap.get(app);
    }

    public Map<String, App> getAppMap() {
        return this.appMap;
    }
}

