/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fizzgate.plugin.PluginFilter;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.util.Result;
import com.fizzgate.util.WebUtils;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component(value="authPlugin")
public class AuthPluginFilter
extends PluginFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthPluginFilter.class);
    public static final String AUTH_PLUGIN_FILTER = "authPlugin";
    public static final String RESULT = "result";
    @Resource
    private ApiConfigService apiConfigService;

    @Override
    public Mono<Void> doFilter(ServerWebExchange exchange, Map<String, Object> config, String pluginConfig) {
        return this.apiConfigService.auth(exchange).flatMap(r -> {
            if (log.isDebugEnabled()) {
                String traceId = WebUtils.getTraceId(exchange);
                ThreadContext.put((String)"traceId", (String)traceId);
                log.debug("{} req auth: {}", (Object)traceId, r);
            }
            Map<String, Result> data = Collections.singletonMap(RESULT, r);
            return WebUtils.transmitSuccessFilterResultAndEmptyMono(exchange, AUTH_PLUGIN_FILTER, data);
        });
    }
}

