/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fizzgate.plugin.auth.GatewayGroup;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.NetworkUtils;
import com.fizzgate.util.ReactorUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class GatewayGroupService {
    private static final Logger log = LoggerFactory.getLogger(GatewayGroupService.class);
    private static final String fizzGatewayGroup = "fizz_gateway_group";
    private static final String fizzGatewayGroupChannel = "fizz_gateway_group_channel";
    public Map<String, GatewayGroup> gatewayGroupMap = new HashMap<String, GatewayGroup>(8);
    private Map<Integer, GatewayGroup> oldGatewayGroupMap = new HashMap<Integer, GatewayGroup>(8);
    public Set<String> currentGatewayGroupSet = Stream.of("default").collect(Collectors.toSet());
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Resource
    private Environment environment;

    @PostConstruct
    public void init() throws Throwable {
        this.init(this::lsnGatewayGroupChange);
    }

    public void refreshLocalCache() throws Throwable {
        this.init(null);
    }

    private void init(Supplier<Mono<Throwable>> doAfterLoadCache) throws Throwable {
        HashMap<String, GatewayGroup> gatewayGroupMapTmp = new HashMap<String, GatewayGroup>(8);
        HashMap<Integer, GatewayGroup> oldGatewayGroupMapTmp = new HashMap<Integer, GatewayGroup>(8);
        Set currentGatewayGroupSetTmp = Stream.of("default").collect(Collectors.toSet());
        Throwable[] throwable = new Throwable[1];
        Throwable error = (Throwable)Mono.just((Object)Objects.requireNonNull(this.rt.opsForHash().entries((Object)fizzGatewayGroup).defaultIfEmpty(new AbstractMap.SimpleEntry<Object, Object>(ReactorUtils.OBJ, ReactorUtils.OBJ)).onErrorStop().doOnError(t -> log.info(null, t)).concatMap(e -> {
            Object k = e.getKey();
            if (k == ReactorUtils.OBJ) {
                return Flux.just((Object)e);
            }
            String json = (String)e.getValue();
            ThreadContext.put((String)"traceId", (String)k.toString());
            log.info(json);
            try {
                GatewayGroup gg = (GatewayGroup)JacksonUtils.readValue((String)json, GatewayGroup.class);
                oldGatewayGroupMapTmp.put(gg.id, gg);
                this.updateGatewayGroupMap(gg, gatewayGroupMapTmp, currentGatewayGroupSetTmp);
                return Flux.just((Object)e);
            }
            catch (Throwable t) {
                throwable[0] = t;
                log.info(json, t);
                return Flux.error((Throwable)t);
            }
        }).blockLast())).flatMap(e -> {
            if (throwable[0] != null) {
                return Mono.error((Throwable)throwable[0]);
            }
            if (doAfterLoadCache != null) {
                return (Mono)doAfterLoadCache.get();
            }
            return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
        }).block();
        if (error != ReactorUtils.EMPTY_THROWABLE) {
            throw error;
        }
        this.gatewayGroupMap = gatewayGroupMapTmp;
        this.oldGatewayGroupMap = oldGatewayGroupMapTmp;
        this.currentGatewayGroupSet = currentGatewayGroupSetTmp;
    }

    private Mono<Throwable> lsnGatewayGroupChange() {
        Throwable[] throwable = new Throwable[1];
        boolean[] b = new boolean[]{false};
        this.rt.listenToChannel(new String[]{fizzGatewayGroupChannel}).doOnError(t -> {
            throwable[0] = t;
            b[0] = false;
            log.error("lsn fizz_gateway_group_channel", t);
        }).doOnSubscribe(s -> {
            b[0] = true;
            log.info("success to lsn on fizz_gateway_group_channel");
        }).doOnNext(msg -> {
            String json = (String)msg.getMessage();
            ThreadContext.put((String)"traceId", (String)("gg" + System.currentTimeMillis()));
            log.info(json);
            try {
                GatewayGroup gg = (GatewayGroup)JacksonUtils.readValue((String)json, GatewayGroup.class);
                GatewayGroup r = this.oldGatewayGroupMap.remove(gg.id);
                if (!gg.isDeleted && r != null) {
                    this.gatewayGroupMap.remove(r.group);
                }
                this.updateGatewayGroupMap(gg, this.gatewayGroupMap, this.currentGatewayGroupSet);
                if (!gg.isDeleted) {
                    this.oldGatewayGroupMap.put(gg.id, gg);
                }
            }
            catch (Throwable t) {
                log.info(json, t);
            }
        }).subscribe();
        Throwable t2 = throwable[0];
        while (!b[0]) {
            if (t2 != null) {
                return Mono.error((Throwable)t2);
            }
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                return Mono.error((Throwable)e);
            }
        }
        return Mono.just((Object)ReactorUtils.EMPTY_THROWABLE);
    }

    private void updateGatewayGroupMap(GatewayGroup gg, Map<String, GatewayGroup> gatewayGroupMap, Set<String> currentGatewayGroupSet) {
        if (gg.isDeleted) {
            GatewayGroup r = gatewayGroupMap.remove(gg.group);
            log.info("remove " + r);
        } else {
            GatewayGroup existGatewayGroup = gatewayGroupMap.get(gg.group);
            gatewayGroupMap.put(gg.group, gg);
            if (existGatewayGroup == null) {
                log.info("add " + gg);
            } else {
                log.info("update " + existGatewayGroup + " with " + gg);
            }
        }
        this.updateCurrentGatewayGroupSet(currentGatewayGroupSet, gatewayGroupMap);
    }

    private void updateCurrentGatewayGroupSet(Set<String> currentGatewayGroupSet, Map<String, GatewayGroup> gatewayGroupMap) {
        Set ips = NetworkUtils.getServerIps();
        String applicationName = this.environment.getProperty("spring.application.name");
        currentGatewayGroupSet.clear();
        gatewayGroupMap.forEach((k, gg) -> {
            HashSet set = new HashSet(ips);
            set.retainAll(gg.gateways);
            if (!set.isEmpty() || gg.gateways.contains(applicationName)) {
                currentGatewayGroupSet.add(gg.group);
            }
        });
        if (currentGatewayGroupSet.isEmpty()) {
            currentGatewayGroupSet.add("default");
        }
    }

    public GatewayGroup get(String gg) {
        return this.gatewayGroupMap.get(gg);
    }
}

