/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.util.ThreadContext;
import com.fizzgate.util.UrlTransformUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class ServiceConfig {
    private static final Logger log = LoggerFactory.getLogger(ServiceConfig.class);
    private String id;
    public Map<String, Map<Object, Map<String, Set<ApiConfig>>>> apiConfigMap = new HashMap<String, Map<Object, Map<String, Set<ApiConfig>>>>();

    public ServiceConfig(String id) {
        this.id = id;
    }

    public void add(ApiConfig ac) {
        for (String gatewayGroup : ac.gatewayGroups) {
            Map method2pathPattenMap = this.apiConfigMap.computeIfAbsent(gatewayGroup, k -> new HashMap());
            Map pathPattern2apiConfigsMap = method2pathPattenMap.computeIfAbsent(ac.fizzMethod, k -> new HashMap());
            Set apiConfigs = pathPattern2apiConfigsMap.computeIfAbsent(ac.path, k -> new HashSet());
            apiConfigs.add(ac);
        }
        log.info("{} service add api config: {}", (Object)this.id, (Object)ac);
    }

    public void remove(ApiConfig ac) {
        for (String gatewayGroup : ac.gatewayGroups) {
            Set<ApiConfig> apiConfigs;
            Map<String, Set<ApiConfig>> pathPattern2apiConfigsMap;
            Map<Object, Map<String, Set<ApiConfig>>> method2pathPattenMap = this.apiConfigMap.get(gatewayGroup);
            if (method2pathPattenMap == null || (pathPattern2apiConfigsMap = method2pathPattenMap.get(ac.fizzMethod)) == null || (apiConfigs = pathPattern2apiConfigsMap.get(ac.path)) == null) continue;
            apiConfigs.remove(ac);
            if (!apiConfigs.isEmpty()) continue;
            pathPattern2apiConfigsMap.remove(ac.path);
            if (!pathPattern2apiConfigsMap.isEmpty()) continue;
            method2pathPattenMap.remove(ac.fizzMethod);
            if (!method2pathPattenMap.isEmpty()) continue;
            this.apiConfigMap.remove(gatewayGroup);
        }
        log.info("{} service remove api config: {}", (Object)this.id, (Object)ac);
    }

    public void update(ApiConfig ac) {
        for (String gatewayGroup : ac.gatewayGroups) {
            Map method2pathPattenMap = this.apiConfigMap.computeIfAbsent(gatewayGroup, k -> new HashMap());
            Map pathPattern2apiConfigsMap = method2pathPattenMap.computeIfAbsent(ac.fizzMethod, k -> new HashMap());
            Set apiConfigs = pathPattern2apiConfigsMap.computeIfAbsent(ac.path, k -> new HashSet());
            apiConfigs.remove(ac);
            apiConfigs.add(ac);
        }
        log.info("{} service update api config: {}", (Object)this.id, (Object)ac);
    }

    @JsonIgnore
    public List<ApiConfig> getApiConfigs(boolean dedicatedLineRequest, Set<String> gatewayGroups, HttpMethod method, String path) {
        ArrayList result = ThreadContext.getArrayList((String)"arlst0T");
        for (String gatewayGroup : gatewayGroups) {
            List<ApiConfig> apiConfigs = this.getApiConfigs(dedicatedLineRequest, gatewayGroup, method, path);
            result.addAll(apiConfigs);
        }
        return result;
    }

    @JsonIgnore
    public List<ApiConfig> getApiConfigs(boolean dedicatedLineRequest, String gatewayGroup, HttpMethod method, String path) {
        Map<Object, Map<String, Set<ApiConfig>>> method2pathPattenMap = this.apiConfigMap.get(gatewayGroup);
        if (method2pathPattenMap == null) {
            return Collections.emptyList();
        }
        ArrayList result = ThreadContext.getArrayList();
        Map<String, Set<ApiConfig>> pathPattern2apiConfigsMap = method2pathPattenMap.get(method);
        if (pathPattern2apiConfigsMap != null) {
            this.checkPathPattern(pathPattern2apiConfigsMap, dedicatedLineRequest, path, result);
        }
        if ((pathPattern2apiConfigsMap = method2pathPattenMap.get("AM")) != null) {
            this.checkPathPattern(pathPattern2apiConfigsMap, dedicatedLineRequest, path, result);
        }
        return result;
    }

    private void checkPathPattern(Map<String, Set<ApiConfig>> pathPattern2apiConfigMap, boolean dedicatedLineRequest, String path, ArrayList<ApiConfig> result) {
        Set<Map.Entry<String, Set<ApiConfig>>> entries = pathPattern2apiConfigMap.entrySet();
        for (Map.Entry<String, Set<ApiConfig>> entry : entries) {
            String pathPattern = entry.getKey();
            Set<ApiConfig> apiConfigs = entry.getValue();
            if (pathPattern.equals(path)) {
                for (ApiConfig ac : apiConfigs) {
                    if (dedicatedLineRequest) {
                        if (!ac.dedicatedLine) continue;
                        result.add(ac);
                        continue;
                    }
                    if (ac.dedicatedLine) continue;
                    result.add(ac);
                }
                continue;
            }
            if (!UrlTransformUtils.ANT_PATH_MATCHER.match(pathPattern, path)) continue;
            for (ApiConfig ac : apiConfigs) {
                if (dedicatedLineRequest) {
                    if (!ac.dedicatedLine) continue;
                    result.add(ac);
                    continue;
                }
                if (ac.dedicatedLine) continue;
                result.add(ac);
            }
        }
    }
}

