/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.requestbody;

import com.fizzgate.plugin.FizzPluginFilter;
import com.fizzgate.plugin.FizzPluginFilterChain;
import com.fizzgate.spring.http.server.reactive.ext.FizzServerHttpRequestDecorator;
import com.fizzgate.spring.web.server.ext.FizzServerWebExchangeDecorator;
import com.fizzgate.util.NettyDataBufferUtils;
import com.fizzgate.util.WebUtils;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component(value="requestBodyPlugin")
public class RequestBodyPlugin
implements FizzPluginFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyPlugin.class);
    public static final String REQUEST_BODY_PLUGIN = "requestBodyPlugin";

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, Map<String, Object> config) {
        ServerHttpRequest req = exchange.getRequest();
        if (req instanceof FizzServerHttpRequestDecorator) {
            return this.doFilter(exchange, config);
        }
        return NettyDataBufferUtils.join((Publisher)req.getBody()).defaultIfEmpty((Object)NettyDataBufferUtils.EMPTY_DATA_BUFFER).flatMap(body -> {
            ServerWebExchange mutatedExchange;
            FizzServerHttpRequestDecorator requestDecorator = new FizzServerHttpRequestDecorator(req);
            if (body != NettyDataBufferUtils.EMPTY_DATA_BUFFER) {
                try {
                    requestDecorator.setBody(body);
                }
                finally {
                    NettyDataBufferUtils.release((DataBuffer)body);
                }
            }
            ServerWebExchange newExchange = mutatedExchange = exchange.mutate().request((ServerHttpRequest)requestDecorator).build();
            MediaType contentType = req.getHeaders().getContentType();
            if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
                newExchange = new FizzServerWebExchangeDecorator(mutatedExchange);
            }
            if (log.isDebugEnabled()) {
                String traceId = WebUtils.getTraceId(exchange);
                ThreadContext.put((String)"traceId", (String)traceId);
                log.debug("{} request is decorated", (Object)traceId);
            }
            return this.doFilter(newExchange, config);
        });
    }

    public Mono<Void> doFilter(ServerWebExchange exchange, Map<String, Object> config) {
        return FizzPluginFilterChain.next(exchange);
    }
}

