/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.stat;

import com.fizzgate.config.SchedConfig;
import com.fizzgate.plugin.stat.AccessStat;
import com.fizzgate.plugin.stat.StatPluginFilter;
import com.fizzgate.plugin.stat.StatPluginFilterProperties;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.StringUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class AccessStatSchedConfig
extends SchedConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessStatSchedConfig.class);
    private static final Logger STAT_LOGGER = LoggerFactory.getLogger((String)"stat");
    @Resource(name="aggregateReactiveRedisTemplate")
    private ReactiveStringRedisTemplate rt;
    @Resource
    private StatPluginFilterProperties statPluginFilterProperties;
    @Resource
    private StatPluginFilter statPluginFilter;

    @Scheduled(cron="${fizz-access-stat-sched.cron:2/10 * * * * ?}")
    public void sched() {
        long prevTimeWinStart = DateTimeUtils.get10sTimeWinStart((int)2);
        Map<String, AccessStat> accessStatMap = this.statPluginFilter.getAccessStat(prevTimeWinStart);
        if (accessStatMap.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no access stat in {} window", (Object)DateTimeUtils.convert((long)prevTimeWinStart, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        } else {
            accessStatMap.forEach((smp, accessStat) -> {
                String msg = accessStat.toString();
                String topic = this.statPluginFilterProperties.getFizzAccessStatTopic();
                if (StringUtils.isBlank((CharSequence)topic)) {
                    String channel = this.statPluginFilterProperties.getFizzAccessStatChannel();
                    this.rt.convertAndSend(channel, (Object)msg).subscribe();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("send access stat {} which belong to {} window to channel {}", new Object[]{msg, DateTimeUtils.convert((long)accessStat.start, (String)"yyyy-MM-dd HH:mm:ss"), channel});
                    }
                } else {
                    STAT_LOGGER.info(msg);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("send access stat {} which belong to {} window to topic", (Object)msg, (Object)DateTimeUtils.convert((long)accessStat.start, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                }
            });
        }
    }
}

