/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.plugin.stat;

import com.fizzgate.plugin.PluginFilter;
import com.fizzgate.plugin.stat.AccessStat;
import com.fizzgate.plugin.stat.StatPluginFilterProperties;
import com.fizzgate.util.DateTimeUtils;
import com.fizzgate.util.ThreadContext;
import com.fizzgate.util.WebUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component(value="statPlugin")
public class StatPluginFilter
extends PluginFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatPluginFilter.class);
    public static final String STAT_PLUGIN_FILTER = "statPlugin";
    @Resource
    private StatPluginFilterProperties statPluginFilterProperties;
    private Map<Long, Map<Long, Map<String, AccessStat>>> threadTimeWinAccessStatMap = new HashMap<Long, Map<Long, Map<String, AccessStat>>>();

    @Override
    public Mono<Void> doFilter(ServerWebExchange exchange, Map<String, Object> config, String fixedConfig) {
        if (this.statPluginFilterProperties.isStatOpen()) {
            long tid = Thread.currentThread().getId();
            LinkedHashMap<Long, Map<String, AccessStat>> timeWinAccessStatMap = this.threadTimeWinAccessStatMap.get(tid);
            if (timeWinAccessStatMap == null) {
                timeWinAccessStatMap = new LinkedHashMap<Long, Map<String, AccessStat>>(4, 1.0f){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry eldest) {
                        return this.size() > 2;
                    }
                };
                this.threadTimeWinAccessStatMap.put(tid, (Map<Long, Map<String, AccessStat>>)timeWinAccessStatMap);
            }
            long currentTimeWinStart = DateTimeUtils.get10sTimeWinStart((int)1);
            Map accessStatMap = timeWinAccessStatMap.computeIfAbsent(currentTimeWinStart, k -> new HashMap(128));
            String service = WebUtils.getClientService(exchange);
            String method = exchange.getRequest().getMethodValue();
            String path = WebUtils.getClientReqPath(exchange);
            String key = ThreadContext.getStringBuilder().append(service).append(method).append(path).toString();
            AccessStat accessStat = (AccessStat)accessStatMap.get(key);
            if (accessStat == null) {
                accessStat = new AccessStat();
                accessStat.service = service;
                accessStat.apiMethod = method;
                accessStat.apiPath = path;
                accessStatMap.put(key, accessStat);
            }
            accessStat.reqTime = System.currentTimeMillis();
            ++accessStat.reqs;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update access stat: {}, which request at {}", (Object)accessStat, (Object)DateTimeUtils.convert((long)accessStat.reqTime, (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        return WebUtils.transmitSuccessFilterResultAndEmptyMono(exchange, STAT_PLUGIN_FILTER, null);
    }

    public Map<String, AccessStat> getAccessStat(long timeWinStart) {
        HashMap result = ThreadContext.getHashMap();
        this.threadTimeWinAccessStatMap.forEach((t, timeWinAccessStatMap) -> {
            Map accessStatMap = (Map)timeWinAccessStatMap.get(timeWinStart);
            if (accessStatMap != null) {
                accessStatMap.forEach((smp, accessStat) -> {
                    AccessStat as = (AccessStat)result.get(smp);
                    if (as == null) {
                        accessStat.start = timeWinStart;
                        result.put(smp, accessStat);
                    } else {
                        as.reqs += accessStat.reqs;
                        if (accessStat.reqTime > as.reqTime) {
                            as.reqTime = accessStat.reqTime;
                        }
                    }
                });
            }
        });
        return result;
    }
}

