/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fizzgate.proxy.ServiceInstance;
import com.fizzgate.proxy.ServiceTypePath;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Utils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

public class CallbackReplayReq {
    public String id;
    public String app;
    public String gatewayGroup;
    public HttpMethod method;
    public String service;
    public String path;
    public String query;
    public HttpHeaders headers;
    public String body;
    public int replayType;
    public Map<String, ServiceInstance> receivers;
    public List<ServiceTypePath> assignServices;

    public void setMethod(String m) {
        this.method = HttpMethod.resolve((String)m);
    }

    public void setHeaders(Map<String, List<String>> hs) {
        if (hs != null && !hs.isEmpty()) {
            this.headers = new HttpHeaders();
            hs.forEach((h, vs) -> this.headers.addAll(h, vs));
        }
    }

    public void setReceivers(String rs) {
        if (StringUtils.isNotBlank((CharSequence)rs)) {
            try {
                this.receivers = (Map)JacksonUtils.getObjectMapper().readValue(rs, (TypeReference)new TypeReference<Map<String, ServiceInstance>>(){});
            }
            catch (JsonProcessingException e) {
                throw Utils.runtimeExceptionWithoutStack((String)(rs + " receivers str invalid"));
            }
        }
    }

    public String toString() {
        return JacksonUtils.writeValueAsString((Object)this);
    }

    public static interface Type {
        public static final int ORIGINAL_PATH = 1;
        public static final int ASSIGN_SERVICES = 2;
    }
}

