/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.fizz.AggregateResult;
import com.fizzgate.fizz.AggregateService;
import com.fizzgate.plugin.auth.ApiConfig;
import com.fizzgate.plugin.auth.ApiConfigService;
import com.fizzgate.plugin.auth.CallbackConfig;
import com.fizzgate.plugin.auth.Receiver;
import com.fizzgate.proxy.CallbackReplayReq;
import com.fizzgate.proxy.FailAggregateResult;
import com.fizzgate.proxy.FizzFailClientResponse;
import com.fizzgate.proxy.FizzWebClient;
import com.fizzgate.proxy.ServiceInstance;
import com.fizzgate.proxy.ServiceTypePath;
import com.fizzgate.service_registry.RegistryCenterService;
import com.fizzgate.util.Consts;
import com.fizzgate.util.JacksonUtils;
import com.fizzgate.util.Result;
import com.fizzgate.util.Utils;
import com.fizzgate.util.WebUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class CallbackService {
    private static final Logger log = LoggerFactory.getLogger(CallbackService.class);
    private static final String callback = "callback";
    @Resource
    private FizzWebClient fizzWebClient;
    @Resource
    private AggregateService aggregateService;
    @Resource
    private ApiConfigService apiConfigService;
    @Resource
    private SystemConfig systemConfig;
    private String aggrConfigPrefix;

    @PostConstruct
    public void postConstruct() {
        this.aggrConfigPrefix = this.systemConfig.getGatewayPrefix() + '/';
    }

    public Mono<Void> requestBackends(ServerWebExchange exchange, HttpHeaders headers, DataBuffer body, CallbackConfig cc, Map<String, ServiceInstance> service2instMap) {
        ServerHttpRequest req = exchange.getRequest();
        String traceId = WebUtils.getTraceId(exchange);
        HttpMethod method = req.getMethod();
        if (log.isDebugEnabled()) {
            ThreadContext.put((String)"traceId", (String)traceId);
            log.debug(traceId + " service2instMap: " + JacksonUtils.writeValueAsString(service2instMap));
        }
        int rs = cc.receivers.size();
        Mono[] sends = new Mono[rs];
        for (int i = 0; i < rs; ++i) {
            Mono send;
            Receiver r = cc.receivers.get(i);
            if (r.type == 2) {
                ServiceInstance si = service2instMap.get(r.service);
                if (si == null) {
                    send = this.fizzWebClient.send2service(traceId, method, r.service, r.path, headers, body).onErrorResume(this.crError(exchange, r, method, headers, body));
                } else {
                    String uri = this.buildUri(req, si, r.path);
                    send = this.fizzWebClient.send(traceId, method, uri, headers, body).onErrorResume(this.crError(exchange, r, method, headers, body));
                }
            } else {
                send = this.aggregateService.request(WebUtils.getTraceId(exchange), WebUtils.getClientReqPathPrefix(exchange), method.name(), r.service, r.path, (MultiValueMap<String, String>)req.getQueryParams(), headers, body).onErrorResume(this.arError(exchange, r, method, headers, body));
            }
            sends[i] = send;
        }
        return Flux.mergeSequential((Publisher[])sends).collectList().flatMap(sendResults -> {
            Object r = null;
            for (int i = 1; i < sendResults.size(); ++i) {
                r = sendResults.get(i);
                if (!(r instanceof ClientResponse) || r instanceof FizzFailClientResponse) continue;
                this.clean(r);
            }
            r = sendResults.get(0);
            Throwable t = null;
            if (r instanceof FizzFailClientResponse) {
                t = ((FizzFailClientResponse)r).throwable;
                return Mono.error((Throwable)Utils.runtimeExceptionWithoutStack((String)t.getMessage()));
            }
            if (r instanceof FailAggregateResult) {
                t = ((FailAggregateResult)r).throwable;
                return Mono.error((Throwable)Utils.runtimeExceptionWithoutStack((String)t.getMessage()));
            }
            if (r instanceof ClientResponse) {
                return this.genServerResponse(exchange, r);
            }
            return this.aggregateService.genAggregateResponse(exchange, r);
        });
    }

    private Function<Throwable, Mono<? extends ClientResponse>> crError(ServerWebExchange exchange, Receiver r, HttpMethod method, HttpHeaders headers, DataBuffer body) {
        return t -> {
            this.log(exchange, r, method, headers, body, (Throwable)t);
            return Mono.just((Object)new FizzFailClientResponse((Throwable)t));
        };
    }

    private Function<Throwable, Mono<AggregateResult>> arError(ServerWebExchange exchange, Receiver r, HttpMethod method, HttpHeaders headers, DataBuffer body) {
        return t -> {
            this.log(exchange, r, method, headers, body, (Throwable)t);
            return Mono.just((Object)new FailAggregateResult((Throwable)t));
        };
    }

    private void log(ServerWebExchange exchange, Receiver r, HttpMethod method, HttpHeaders headers, DataBuffer body, Throwable t) {
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        WebUtils.request2stringBuilder(exchange, b);
        b.append(Consts.S.LINE_SEPARATOR).append(callback).append(Consts.S.LINE_SEPARATOR);
        String traceId = WebUtils.getTraceId(exchange);
        WebUtils.request2stringBuilder(traceId, method, r.service + '/' + r.path, headers, body, b);
        ThreadContext.put((String)"traceId", (String)traceId);
        log.error(b.toString(), t);
    }

    private String buildUri(ServerHttpRequest req, ServiceInstance si, String path) {
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        b.append(req.getURI().getScheme()).append(':').append('/').append('/');
        b.append(si.ip).append(':').append(si.port).append(path);
        return b.toString();
    }

    private String buildUri(String scheme, ServiceInstance si, String path) {
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        b.append(scheme).append(':').append('/').append('/');
        b.append(si.ip).append(':').append(si.port).append(path);
        return b.toString();
    }

    private Mono<Void> genServerResponse(ServerWebExchange exchange, ClientResponse remoteResp) {
        ServerHttpResponse clientResp = exchange.getResponse();
        clientResp.setStatusCode(remoteResp.statusCode());
        HttpHeaders clientRespHeaders = clientResp.getHeaders();
        HttpHeaders remoteRespHeaders = remoteResp.headers().asHttpHeaders();
        remoteRespHeaders.entrySet().forEach(h -> {
            String k = (String)h.getKey();
            if (clientRespHeaders.containsKey((Object)k)) {
                if (!(k.equals("Access-Control-Allow-Origin") || k.equals("Access-Control-Allow-Credentials") || k.equals("Access-Control-Allow-Headers") || k.equals("Access-Control-Max-Age") || k.equals("Access-Control-Allow-Methods"))) {
                    clientRespHeaders.put(k, (List)h.getValue());
                }
            } else {
                clientRespHeaders.put(k, (List)h.getValue());
            }
        });
        if (log.isDebugEnabled()) {
            StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
            String traceId = WebUtils.getTraceId(exchange);
            WebUtils.response2stringBuilder(traceId, remoteResp, b);
            ThreadContext.put((String)"traceId", (String)traceId);
            log.debug(b.toString());
        }
        return clientResp.writeWith((Publisher)remoteResp.body(BodyExtractors.toDataBuffers())).doOnError(throwable -> this.clean(remoteResp)).doOnCancel(() -> this.clean(remoteResp));
    }

    public Mono<Result> replay(CallbackReplayReq req) {
        HashSet<String> gatewayGroups = new HashSet<String>();
        gatewayGroups.add(req.gatewayGroup);
        Result<ApiConfig> result = this.apiConfigService.get(false, gatewayGroups, req.app, req.service, req.method, req.path);
        ApiConfig ac = (ApiConfig)result.data;
        if (ac == null) {
            return Mono.just((Object)Result.fail((String)("no api config for " + req.path)));
        }
        CallbackConfig cc = ac.callbackConfig;
        ArrayList<Mono> sends = new ArrayList<Mono>();
        if (req.replayType == 1) {
            int rs = cc.receivers.size();
            for (int i = 0; i < rs; ++i) {
                Mono send;
                Receiver r = cc.receivers.get(i);
                if (r.type == 2) {
                    ServiceInstance si = req.receivers.get(r.service);
                    if (si == null) continue;
                    String uri = this.buildUri("http", si, r.path);
                    send = this.fizzWebClient.send(req.id, req.method, uri, req.headers, req.body).onErrorResume(this.crError(req, r.service, r.path));
                    sends.add(send);
                    continue;
                }
                String traceId = "fizz-" + req.id;
                send = this.aggregateService.request(traceId, this.aggrConfigPrefix, req.method.name(), r.service, r.path, null, req.headers, req.body).onErrorResume(this.arError(req, r.service, r.path));
                sends.add(send);
            }
        } else {
            for (ServiceTypePath stp : req.assignServices) {
                Mono send;
                if (stp.type == 2) {
                    String svc = null;
                    svc = RegistryCenterService.getServiceNameSpace(stp.registryCenter, stp.service);
                    send = this.fizzWebClient.send2service(req.id, req.method, svc, stp.path, req.headers, req.body).onErrorResume(this.crError(req, stp.service, stp.path));
                } else {
                    String traceId = "fizz-" + req.id;
                    send = this.aggregateService.request(traceId, this.aggrConfigPrefix, req.method.name(), stp.service, stp.path, null, req.headers, req.body).onErrorResume(this.arError(req, stp.service, stp.path));
                }
                sends.add(send);
            }
        }
        int ss = sends.size();
        Mono[] sendArr = sends.toArray(new Mono[ss]);
        return Flux.mergeSequential((Publisher[])sendArr).collectList().map(sendResults -> {
            int c = 1;
            Throwable t = null;
            for (int i = 0; i < sendResults.size(); ++i) {
                Object r = sendResults.get(i);
                if (r instanceof FizzFailClientResponse) {
                    c = 0;
                    t = ((FizzFailClientResponse)r).throwable;
                    continue;
                }
                if (r instanceof FailAggregateResult) {
                    c = 0;
                    t = ((FailAggregateResult)r).throwable;
                    continue;
                }
                if (!(r instanceof ClientResponse)) continue;
                this.clean((ClientResponse)r);
            }
            return Result.with((int)c, t);
        });
    }

    private Function<Throwable, Mono<? extends AggregateResult>> arError(CallbackReplayReq req, String service, String path) {
        return t -> {
            this.log(req, service, path, (Throwable)t);
            return Mono.just((Object)new FailAggregateResult((Throwable)t));
        };
    }

    private Function<Throwable, Mono<? extends ClientResponse>> crError(CallbackReplayReq req, String service, String path) {
        return t -> {
            this.log(req, service, path, (Throwable)t);
            return Mono.just((Object)new FizzFailClientResponse((Throwable)t));
        };
    }

    private void log(CallbackReplayReq req, String service, String path, Throwable t) {
        StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
        b.append(req.service).append('/').append(req.path);
        b.append(Consts.S.LINE_SEPARATOR).append(callback).append(Consts.S.LINE_SEPARATOR);
        WebUtils.request2stringBuilder(req.id, req.method, service + '/' + path, req.headers, req.body, b);
        ThreadContext.put((String)"traceId", (String)req.id);
        log.error(b.toString(), t);
    }

    private void clean(ClientResponse cr) {
        cr.bodyToMono(Void.class).subscribe();
    }
}

