/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.fizzgate.proxy.AbstractDiscoveryClientUriSelector;
import com.fizzgate.proxy.ServiceInstance;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Applications;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
@Service
public class EurekaUriSelector
extends AbstractDiscoveryClientUriSelector {
    @Resource
    private EurekaClient eurekaClient;

    @Override
    public String getNextUri(String service, String relativeUri) {
        InstanceInfo inst = this.roundRobinChoose1instFrom(service);
        return this.buildUri(inst.getIPAddr(), inst.getPort(), relativeUri);
    }

    @Override
    public ServiceInstance getNextInstance(String service) {
        InstanceInfo inst = this.roundRobinChoose1instFrom(service);
        return new ServiceInstance(inst.getIPAddr(), inst.getPort());
    }

    private InstanceInfo roundRobinChoose1instFrom(String service) {
        List insts = this.eurekaClient.getInstancesByVipAddress(service, false);
        if (insts == null || insts.isEmpty()) {
            throw new RuntimeException("eureka no " + service, null, false, false){};
        }
        Applications apps = this.eurekaClient.getApplications();
        int index = (int)(apps.getNextIndex(service.toUpperCase(), false).incrementAndGet() % (long)insts.size());
        return (InstanceInfo)insts.get(index);
    }
}

