/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.fizzgate.config.SystemConfig;
import com.fizzgate.exception.ExternalService4xxException;
import com.fizzgate.fizz.exception.FizzRuntimeException;
import com.fizzgate.proxy.DiscoveryClientUriSelector;
import com.fizzgate.service_registry.RegistryCenterService;
import com.fizzgate.util.NetworkUtils;
import com.fizzgate.util.WebUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Service
public class FizzWebClient {
    private static final Logger log = LoggerFactory.getLogger(FizzWebClient.class);
    private static final String localhost = "localhost";
    private static final String host = "Host";
    @Resource
    private SystemConfig systemConfig;
    @Resource
    private DiscoveryClientUriSelector discoveryClientUriSelector;
    @Resource
    private RegistryCenterService registryCenterService;
    @Resource(name="proxyWebClient")
    private WebClient webClient;

    public Mono<ClientResponse> send(String traceId, HttpMethod method, String uriOrSvc, @Nullable HttpHeaders headers, @Nullable Object body) {
        return this.send(traceId, method, uriOrSvc, headers, body, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Mono<ClientResponse> send(String traceId, HttpMethod method, String uriOrSvc, @Nullable HttpHeaders headers, @Nullable Object body, String ... uriQryParamVals) {
        return this.send(traceId, method, uriOrSvc, headers, body, 0L, 0L, 0L, uriQryParamVals);
    }

    public Mono<ClientResponse> send(String traceId, HttpMethod method, String uriOrSvc, @Nullable HttpHeaders headers, @Nullable Object body, long timeout, long numRetries, long retryInterval) {
        return this.send(traceId, method, uriOrSvc, headers, body, timeout, numRetries, retryInterval, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Mono<ClientResponse> send(String traceId, HttpMethod method, String uriOrSvc, @Nullable HttpHeaders headers, @Nullable Object body, long timeout, long numRetries, long retryInterval, String ... uriQryParamVals) {
        String s = this.extractServiceOrAddress(uriOrSvc);
        Mono cr = Mono.just((Object)"").flatMap(dummy -> {
            if (this.isService(s)) {
                String path = uriOrSvc.substring(uriOrSvc.indexOf(47, 10));
                String uri = null;
                int commaPos = s.indexOf(44);
                if (commaPos > -1) {
                    String rc = s.substring(0, commaPos);
                    String svc = s.substring(commaPos + 1);
                    String instance = this.registryCenterService.getInstance(rc, svc);
                    uri = com.fizzgate.util.ThreadContext.getStringBuilder().append("http://").append(instance).append(path).toString();
                } else {
                    uri = this.discoveryClientUriSelector.getNextUri(s, path);
                }
                return this.send2uri(traceId, method, uri, headers, body, timeout, uriQryParamVals);
            }
            return this.send2uri(traceId, method, uriOrSvc, headers, body, timeout, uriQryParamVals);
        });
        if (numRetries > 0L) {
            cr = cr.flatMap(resp -> {
                if (resp.statusCode().is4xxClientError()) {
                    return Mono.error((Throwable)new ExternalService4xxException());
                }
                return Mono.just((Object)resp);
            }).retryWhen((Retry)Retry.fixedDelay((long)numRetries, (Duration)Duration.ofMillis(retryInterval > 0L ? retryInterval : 0L)).filter(throwable -> !(throwable instanceof ExternalService4xxException)).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
                throw new FizzRuntimeException("External service failed to process after max retries");
            }));
        }
        return cr;
    }

    public Mono<ClientResponse> send2service(@Nullable String traceId, HttpMethod method, String service, String relativeUri, @Nullable HttpHeaders headers, @Nullable Object body) {
        return this.send2service(traceId, method, service, relativeUri, headers, body, 0L, 0L, 0L);
    }

    public Mono<ClientResponse> send2service(@Nullable String traceId, HttpMethod method, String service, String relativeUri, @Nullable HttpHeaders headers, @Nullable Object body, String ... relativeUriQryParamVals) {
        return this.send2service(traceId, method, service, relativeUri, headers, body, 0L, 0L, 0L, relativeUriQryParamVals);
    }

    public Mono<ClientResponse> send2service(@Nullable String traceId, HttpMethod method, String service, String relativeUri, @Nullable HttpHeaders headers, @Nullable Object body, long timeout, long numRetries, long retryInterval) {
        return this.send2service(traceId, method, service, relativeUri, headers, body, timeout, numRetries, retryInterval, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Mono<ClientResponse> send2service(@Nullable String traceId, HttpMethod method, String service, String relativeUri, @Nullable HttpHeaders headers, @Nullable Object body, long timeout, long numRetries, long retryInterval, String ... relativeUriQryParamVals) {
        Mono cr = Mono.just((Object)"").flatMap(dummy -> {
            String uri = null;
            int commaPos = service.indexOf(44);
            if (commaPos > -1) {
                String rc = service.substring(0, commaPos);
                String s = service.substring(commaPos + 1);
                String instance = this.registryCenterService.getInstance(rc, s);
                uri = com.fizzgate.util.ThreadContext.getStringBuilder().append("http://").append(instance).append(relativeUri).toString();
            } else {
                uri = this.discoveryClientUriSelector.getNextUri(service, relativeUri);
            }
            return this.send2uri(traceId, method, uri, headers, body, timeout, relativeUriQryParamVals);
        });
        if (numRetries > 0L) {
            cr = cr.flatMap(resp -> {
                if (resp.statusCode().is4xxClientError()) {
                    return Mono.error((Throwable)new ExternalService4xxException());
                }
                return Mono.just((Object)resp);
            }).retryWhen((Retry)Retry.fixedDelay((long)numRetries, (Duration)Duration.ofMillis(retryInterval > 0L ? retryInterval : 0L)).filter(throwable -> !(throwable instanceof ExternalService4xxException)).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> {
                throw new FizzRuntimeException("External service failed to process after max retries");
            }));
        }
        return cr;
    }

    public Mono<ClientResponse> send2uri(@Nullable String traceId, HttpMethod method, String uri, @Nullable HttpHeaders headers, @Nullable Object body) {
        return this.send2uri(traceId, method, uri, headers, body, 0L);
    }

    public Mono<ClientResponse> send2uri(@Nullable String traceId, HttpMethod method, String uri, @Nullable HttpHeaders headers, @Nullable Object body, String ... uriQryParamVals) {
        return this.send2uri(traceId, method, uri, headers, body, 0L, uriQryParamVals);
    }

    public Mono<ClientResponse> send2uri(@Nullable String traceId, HttpMethod method, String uri, @Nullable HttpHeaders headers, @Nullable Object body, long timeout) {
        return this.send2uri(traceId, method, uri, headers, body, timeout, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public Mono<ClientResponse> send2uri(@Nullable String traceId, HttpMethod method, String uri, @Nullable HttpHeaders headers, @Nullable Object body, long timeout, String ... uriQryParamVals) {
        if (log.isDebugEnabled()) {
            StringBuilder b = com.fizzgate.util.ThreadContext.getStringBuilder();
            WebUtils.request2stringBuilder(traceId, method, uri, headers, null, b);
            ThreadContext.put((String)"traceId", (String)traceId);
            log.debug(b.toString());
        }
        WebClient.RequestBodyUriSpec requestBodyUriSpec = this.webClient.method(method);
        WebClient.RequestBodySpec requestBodySpec = null;
        requestBodySpec = uriQryParamVals.length == 0 ? (WebClient.RequestBodySpec)requestBodyUriSpec.uri(uri, new Object[0]) : (WebClient.RequestBodySpec)requestBodyUriSpec.uri(uri, Arrays.stream(uriQryParamVals).toArray());
        WebClient.RequestBodySpec req = (WebClient.RequestBodySpec)requestBodySpec.headers(hdrs -> {
            if (headers != null) {
                headers.forEach((h, vs) -> hdrs.addAll(h, vs));
            }
            this.setHostHeader(uri, (HttpHeaders)hdrs);
            if (this.systemConfig.isFizzWebClientXForwardedForEnable()) {
                List values = hdrs.get((Object)"X-Forwarded-For");
                if (this.systemConfig.isFizzWebClientXForwardedForAppendGatewayIp()) {
                    hdrs.add("X-Forwarded-For", NetworkUtils.getServerIp());
                }
            } else {
                hdrs.remove((Object)"X-Forwarded-For");
            }
        });
        if (body != null) {
            if (body instanceof BodyInserter) {
                req.body((BodyInserter)body);
            } else if (body instanceof Flux) {
                Flux db = (Flux)body;
                req.body(BodyInserters.fromDataBuffers((Publisher)db));
            } else {
                req.bodyValue(body);
            }
        }
        Mono cr = req.exchange();
        if (timeout == 0L && this.systemConfig.getRouteTimeout() != 0L) {
            timeout = this.systemConfig.getRouteTimeout();
        }
        if (timeout > 0L) {
            cr = cr.timeout(Duration.ofMillis(timeout));
        }
        return cr;
    }

    private void setHostHeader(String uri, HttpHeaders headers) {
        boolean domain = false;
        int begin = uri.indexOf(47) + 2;
        int end = uri.indexOf(47, begin);
        for (int i = begin; i < end; ++i) {
            char c = uri.charAt(i);
            if ('/' < c && c < ':' || c == '.' || c == ':') continue;
            domain = true;
            break;
        }
        if (domain) {
            List<String> lst = Collections.singletonList(uri.substring(begin, end));
            headers.put(host, lst);
        }
    }

    public String extractServiceOrAddress(String uriOrSvc) {
        int i;
        char c4 = uriOrSvc.charAt(4);
        int start = 7;
        int end = uriOrSvc.length();
        if (c4 == 's' || c4 == 'S') {
            start = 8;
        }
        if ((i = uriOrSvc.indexOf(47, 9)) > 0) {
            end = i;
        }
        return uriOrSvc.substring(start, end);
    }

    private boolean isService(String s) {
        return StringUtils.indexOfAny((CharSequence)s, (char[])new char[]{'.', ':'}) <= 0 && !StringUtils.startsWith((CharSequence)s, (CharSequence)localhost);
    }
}

