/*
 * Decompiled with CFR 0.152.
 */
package com.fizzgate.proxy;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.fizzgate.proxy.AbstractDiscoveryClientUriSelector;
import com.fizzgate.proxy.ServiceInstance;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(value={"spring.cloud.nacos.discovery.enabled"})
@Service
public class NacosUriSelector
extends AbstractDiscoveryClientUriSelector {
    private static final Logger log = LoggerFactory.getLogger(NacosUriSelector.class);
    private final NacosServiceManager nacosServiceManager;
    private NamingService naming;
    private final NacosDiscoveryProperties discoveryProperties;
    private String groupName;
    private List<String> clusterNameList;
    private boolean useGroupName;
    private boolean userClusterName;

    public NacosUriSelector(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties discoveryProperties) {
        this.nacosServiceManager = nacosServiceManager;
        this.discoveryProperties = discoveryProperties;
    }

    @PostConstruct
    public void init() {
        String clusterName;
        this.naming = this.nacosServiceManager.getNamingService(this.discoveryProperties.getNacosProperties());
        this.groupName = this.discoveryProperties.getGroup();
        if (StringUtils.hasText((String)this.groupName)) {
            this.useGroupName = true;
        }
        if (StringUtils.hasText((String)(clusterName = this.discoveryProperties.getClusterName()))) {
            this.userClusterName = true;
            this.clusterNameList = Collections.singletonList(clusterName);
        }
    }

    @Override
    public String getNextUri(String service, String relativeUri) {
        Instance instance = this.selectOneHealthyInstance(service);
        return super.buildUri(instance.getIp(), instance.getPort(), relativeUri);
    }

    @Override
    public ServiceInstance getNextInstance(String service) {
        Instance inst = this.selectOneHealthyInstance(service);
        return new ServiceInstance(inst.getIp(), inst.getPort());
    }

    private Instance selectOneHealthyInstance(String service) {
        Instance instance = null;
        try {
            instance = this.useGroupName && this.userClusterName ? this.naming.selectOneHealthyInstance(service, this.groupName, this.clusterNameList) : (this.useGroupName ? this.naming.selectOneHealthyInstance(service, this.groupName) : (this.userClusterName ? this.naming.selectOneHealthyInstance(service, this.clusterNameList) : this.naming.selectOneHealthyInstance(service)));
        }
        catch (NacosException e) {
            log.warn("Nacos selectOneHealthyInstance({}) exception", (Object)service, (Object)e);
        }
        if (instance == null) {
            throw new RuntimeException("Nacos no " + service, null, false, false){};
        }
        return instance;
    }
}

